/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.armor.ArmorAttribute;
import xzeroair.trinkets.attributes.attackdamage.DamageAttribute;
import xzeroair.trinkets.attributes.knock.KnockResistAttribute;
import xzeroair.trinkets.attributes.speed.SpeedAttribute;
import xzeroair.trinkets.attributes.toughness.ToughnessAttribute;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.util.TrinketsConfig;

public class TrinketGreaterInertia
extends AccessoryBase {
    private final UUID uuid = UUID.fromString("e119ae9a-93b2-4053-ab3c-81108c16ff27");

    public TrinketGreaterInertia(String name) {
        super(name);
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        if (TrinketsConfig.SERVER.GREATER_INERTIA.damage) {
            DamageAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.GREATER_INERTIA.damage_amount, this.uuid, 2);
        } else {
            DamageAttribute.removeModifier((EntityLivingBase)player, this.uuid);
        }
        if (TrinketsConfig.SERVER.GREATER_INERTIA.armor) {
            ArmorAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.GREATER_INERTIA.armor_amount, this.uuid, 2);
        } else {
            ArmorAttribute.removeModifier((EntityLivingBase)player, this.uuid);
        }
        if (TrinketsConfig.SERVER.GREATER_INERTIA.toughness) {
            ToughnessAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.GREATER_INERTIA.toughness_amount, this.uuid, 2);
        } else {
            ToughnessAttribute.removeModifier((EntityLivingBase)player, this.uuid);
        }
        if (TrinketsConfig.SERVER.GREATER_INERTIA.speed) {
            SpeedAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.GREATER_INERTIA.speed_amount, this.uuid, 0);
        } else {
            SpeedAttribute.removeModifier((EntityLivingBase)player, this.uuid);
        }
        if (TrinketsConfig.SERVER.GREATER_INERTIA.knockback) {
            KnockResistAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.GREATER_INERTIA.knockback_amount, this.uuid, 2);
        } else {
            KnockResistAttribute.removeModifier((EntityLivingBase)player, this.uuid);
        }
    }

    @Override
    public void eventLivingJump(ItemStack stack, EntityLivingBase player) {
        if (TrinketsConfig.SERVER.GREATER_INERTIA.jump) {
            float jumpheight = TrinketsConfig.SERVER.GREATER_INERTIA.jumpheight;
            player.field_70181_x *= (double)jumpheight;
        }
    }

    @Override
    public void eventLivingFall(LivingFallEvent event, ItemStack stack, EntityLivingBase player) {
        if (TrinketsConfig.SERVER.GREATER_INERTIA.fall_damage) {
            event.setDamageMultiplier(TrinketsConfig.SERVER.GREATER_INERTIA.falldamage_amount);
        }
    }

    @Override
    public void eventPlayerLogout(ItemStack stack, EntityLivingBase player) {
        DamageAttribute.removeModifier(player, this.uuid);
        ToughnessAttribute.removeModifier(player, this.uuid);
        ArmorAttribute.removeModifier(player, this.uuid);
        SpeedAttribute.removeModifier(player, this.uuid);
        KnockResistAttribute.removeModifier(player, this.uuid);
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, stack.func_77973_b()) || TrinketHelper.AccessoryCheck(player, ModItems.trinkets.TrinketInertiaNull)) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
        DamageAttribute.removeModifier(player, this.uuid);
        ToughnessAttribute.removeModifier(player, this.uuid);
        ArmorAttribute.removeModifier(player, this.uuid);
        SpeedAttribute.removeModifier(player, this.uuid);
        KnockResistAttribute.removeModifier(player, this.uuid);
        super.playerUnequipped(stack, player);
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.GREATER_INERTIA.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

