/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xzeroair.trinkets.capabilities.sizeCap.ISizeCap;
import xzeroair.trinkets.network.BlocklistSyncPacket;
import xzeroair.trinkets.network.ItemCapDataMessage;
import xzeroair.trinkets.network.OpenDefaultInventory;
import xzeroair.trinkets.network.OpenTrinketGui;
import xzeroair.trinkets.network.PacketAccessorySync;
import xzeroair.trinkets.network.PacketConfigSync;
import xzeroair.trinkets.network.PolarizedStoneSyncPacket;
import xzeroair.trinkets.network.SizeDataPacket;
import xzeroair.trinkets.util.compat.firstaid.FirstAidSyncHPPacket;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class NetworkHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("xat".toLowerCase());
    private static int ID = 0;

    private static int nextId() {
        return ID++;
    }

    public static void init() {
        INSTANCE.registerMessage(SizeDataPacket.Handler.class, SizeDataPacket.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(SizeDataPacket.Handler.class, SizeDataPacket.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(ItemCapDataMessage.Handler.class, ItemCapDataMessage.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(ItemCapDataMessage.Handler.class, ItemCapDataMessage.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(PacketAccessorySync.Handler.class, PacketAccessorySync.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(PacketAccessorySync.Handler.class, PacketAccessorySync.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(PacketConfigSync.Handler.class, PacketConfigSync.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(PacketConfigSync.Handler.class, PacketConfigSync.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(BlocklistSyncPacket.Handler.class, BlocklistSyncPacket.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(BlocklistSyncPacket.Handler.class, BlocklistSyncPacket.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(FirstAidSyncHPPacket.Handler.class, FirstAidSyncHPPacket.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(FirstAidSyncHPPacket.Handler.class, FirstAidSyncHPPacket.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(PolarizedStoneSyncPacket.Handler.class, PolarizedStoneSyncPacket.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(PolarizedStoneSyncPacket.Handler.class, PolarizedStoneSyncPacket.class, NetworkHandler.nextId(), Side.CLIENT);
        INSTANCE.registerMessage(OpenTrinketGui.class, OpenTrinketGui.class, NetworkHandler.nextId(), Side.SERVER);
        INSTANCE.registerMessage(OpenDefaultInventory.class, OpenDefaultInventory.class, NetworkHandler.nextId(), Side.SERVER);
    }

    public static void sendItemDataTo(EntityLivingBase send, ItemStack stack, IAccessoryInterface capSend, boolean isTrinket, EntityPlayerMP recieve) {
        INSTANCE.sendTo((IMessage)new ItemCapDataMessage(send, stack, capSend, isTrinket), recieve);
    }

    public static void sendItemDataTracking(EntityLivingBase entity, ItemStack stack, IAccessoryInterface capSend, boolean isTrinket) {
        INSTANCE.sendToAllTracking((IMessage)new ItemCapDataMessage(entity, stack, capSend, isTrinket), (Entity)entity);
    }

    public static void sendItemDataAll(EntityLivingBase entity, ItemStack stack, IAccessoryInterface capSend, boolean isTrinket) {
        INSTANCE.sendToAll((IMessage)new ItemCapDataMessage(entity, stack, capSend, isTrinket));
    }

    public static void sendItemDataServer(EntityLivingBase send, ItemStack stack, IAccessoryInterface capSend, boolean isTrinket) {
        INSTANCE.sendToServer((IMessage)new ItemCapDataMessage(send, stack, capSend, isTrinket));
    }

    public static void sendPlayerDataTo(EntityLivingBase send, ISizeCap capSend, EntityPlayerMP recieve) {
        INSTANCE.sendTo((IMessage)new SizeDataPacket(send, capSend), recieve);
    }

    public static void sendPlayerDataTracking(EntityLivingBase entity, ISizeCap cap) {
        INSTANCE.sendToAllTracking((IMessage)new SizeDataPacket(entity, cap), (Entity)entity);
    }

    public static void sendPlayerDataAll(EntityLivingBase entity, ISizeCap cap) {
        INSTANCE.sendToAll((IMessage)new SizeDataPacket(entity, cap));
    }

    public static void sendPlayerDataServer(EntityLivingBase entity, ISizeCap cap) {
        INSTANCE.sendToServer((IMessage)new SizeDataPacket(entity, cap));
    }
}

