/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.TrinketCap.TrinketProvider;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class PolarizedStoneSyncPacket
implements IMessage {
    int type;
    int hits;
    int exp;
    boolean on;
    boolean altOn;
    boolean bauble;
    int entityID;
    int damage;
    ItemStack item;

    public PolarizedStoneSyncPacket() {
    }

    public PolarizedStoneSyncPacket(EntityLivingBase player, ItemStack stack, IAccessoryInterface cap, boolean isBauble, int damage) {
        this.type = cap.oreTarget();
        this.on = cap.ability();
        this.altOn = cap.altAbility();
        this.hits = cap.hitCount();
        this.exp = cap.storedExp();
        this.bauble = isBauble;
        this.item = stack;
        this.entityID = player.func_145782_y();
        this.damage = damage;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.hits);
        buf.writeInt(this.exp);
        buf.writeBoolean(this.on);
        buf.writeBoolean(this.altOn);
        buf.writeBoolean(this.bauble);
        buf.writeInt(this.entityID);
        buf.writeInt(this.damage);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        this.hits = buf.readInt();
        this.exp = buf.readInt();
        this.on = buf.readBoolean();
        this.altOn = buf.readBoolean();
        this.bauble = buf.readBoolean();
        this.entityID = buf.readInt();
        this.damage = buf.readInt();
        this.item = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PolarizedStoneSyncPacket, IMessage> {
        public IMessage onMessage(PolarizedStoneSyncPacket message, MessageContext ctx) {
            Trinkets.proxy.getThreadListener(ctx).func_152344_a(() -> {
                if (Trinkets.proxy.getEntityLivingBase(ctx, message.entityID) != null) {
                    EntityLivingBase entity = Trinkets.proxy.getEntityLivingBase(ctx, message.entityID);
                    ItemStack stack = TrinketHelper.getAccessory((EntityPlayer)entity, message.item.func_77973_b());
                    IAccessoryInterface iCap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
                    if (iCap != null) {
                        iCap.setOreTarget(message.type);
                        iCap.setAbility(message.on);
                        iCap.setAltAbility(message.altOn);
                        iCap.setHitCount(message.hits);
                        iCap.setStoredExp(message.exp);
                    }
                    stack.func_77964_b(message.damage);
                }
            });
            return null;
        }
    }
}

