/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.eventhandlers;

import com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties.ArrowPropertiesProvider;
import com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties.IArrowProperties;
import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentAgility;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.items.ItemCrossbow;
import com.mujmajnkraft.bettersurvival.items.ItemCustomShield;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModEnchantmentHandler {
    public static final ResourceLocation ARROWPROPERTIES_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "ArrowProperties");

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null) && event.getObject() instanceof EntityArrow) {
            event.addCapability(ARROWPROPERTIES_CAP, (ICapabilityProvider)new ArrowPropertiesProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer entity;
        if (event.getEntity() instanceof EntityPlayer && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.highjump, (EntityLivingBase)(entity = (EntityPlayer)event.getEntity())) != 0) {
            entity.field_70181_x += (double)EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.highjump, (EntityLivingBase)entity) / 10.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() instanceof EntityPlayer) {
            EntityPlayer player = event.getHarvester();
            if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.smelting, (EntityLivingBase)player) != 0) {
                List drops = event.getDrops();
                ArrayList dropsCopy = new ArrayList(drops);
                drops.clear();
                for (ItemStack drop : dropsCopy) {
                    if (drop == null) continue;
                    ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                    if (smeltingResult != ItemStack.field_190927_a) {
                        smeltingResult = smeltingResult.func_77946_l();
                        smeltingResult.func_190920_e(drop.func_190916_E());
                        int fortuneLevel = event.getFortuneLevel();
                        if (!(smeltingResult.func_77973_b() instanceof ItemBlock)) {
                            smeltingResult.func_190920_e(new Random().nextInt(fortuneLevel + 1) + 1);
                        }
                        drops.add(smeltingResult);
                        continue;
                    }
                    drops.add(drop);
                }
            }
            if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.diamonds, (EntityLivingBase)player) != 0) {
                ItemStack drop;
                Block block = event.getState().func_177230_c();
                List drops = event.getDrops();
                ArrayList<Item> itemdrops = new ArrayList<Item>();
                for (ItemStack itemstackdrop : drops) {
                    if (drops == null) continue;
                    Item itemdrop = itemstackdrop.func_77973_b();
                    itemdrops.add(itemdrop);
                }
                drop = Item.func_150898_a((Block)block);
                if ((block instanceof BlockOre || block instanceof BlockRedstoneOre) && !itemdrops.contains(drop) && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.diamonds, (EntityLivingBase)player) > new Random().nextInt(50)) {
                    ItemStack itemStackToDrop = new ItemStack(Items.field_151045_i, 1);
                    event.getDrops().add(itemStackToDrop);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.tunneling, (EntityLivingBase)player) != 0) {
            String facing = event.getFace().toString();
            player.func_184197_b("north");
            player.func_184197_b("south");
            player.func_184197_b("east");
            player.func_184197_b("west");
            player.func_184197_b("up");
            player.func_184197_b("down");
            player.func_184211_a(facing);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow && !event.getWorld().field_72995_K) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase shooter = (EntityLivingBase)arrow.field_70250_c;
                if (arrow.hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)) {
                    IArrowProperties properties = (IArrowProperties)arrow.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null);
                    if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.arrowrecovery, (EntityLivingBase)shooter) != 0) {
                        int l = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.arrowrecovery, (EntityLivingBase)shooter);
                        if (new Random().nextInt(4) < l) {
                            properties.setCanRecover(true);
                        }
                    }
                    if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.blast, (EntityLivingBase)shooter) != 0 && arrow.hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)) {
                        float power = (float)(EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.blast, (EntityLivingBase)shooter) + 1) / 4.0f;
                        boolean canDestroyBlocks = false;
                        canDestroyBlocks = shooter instanceof EntityPlayer ? ((EntityPlayer)shooter).field_71075_bZ.field_75099_e : event.getWorld().func_82736_K().func_82766_b("mobGriefing");
                        properties.setExplosion(power, canDestroyBlocks);
                    }
                    if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.range, (EntityLivingBase)shooter) != 0) {
                        arrow.field_70159_w *= 2.0;
                        arrow.field_70181_x *= 2.0;
                        arrow.field_70179_y *= 2.0;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = event.getWorld();
        Block block = event.getState().func_177230_c();
        Item tool = player.func_184614_ca().func_77973_b();
        IBlockState state = event.getState();
        boolean canBeMined = false;
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.tunneling, (EntityLivingBase)player) != 0) {
            for (String type : tool.getToolClasses(player.func_184614_ca())) {
                if (!block.isToolEffective(type, state) || block.getHarvestLevel(state) > tool.getHarvestLevel(player.func_184614_ca(), type, player, state)) continue;
                canBeMined = true;
            }
            if (canBeMined) {
                int l = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.tunneling, (EntityLivingBase)player);
                ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
                for (int x = -l; x < l + 1; ++x) {
                    if ((player.func_184216_O().contains("west") || player.func_184216_O().contains("east")) && x != 0) continue;
                    for (int y = -l; y < l + 1; ++y) {
                        if ((player.func_184216_O().contains("up") || player.func_184216_O().contains("down")) && y != 0) continue;
                        for (int z = -l; z < l + 1; ++z) {
                            if ((player.func_184216_O().contains("north") || player.func_184216_O().contains("south")) && z != 0 || !(Math.sqrt(x * x + y * y + z * z) <= (double)(((float)l + 1.0f) / 2.0f)) || x == 0 && y == 0 && z == 0) continue;
                            BlockPos pos = event.getPos().func_177982_a(x, y, z);
                            blocks.add(pos);
                        }
                    }
                }
                for (BlockPos blockpos : blocks) {
                    IBlockState block1 = world.func_180495_p(blockpos);
                    boolean canBeMined1 = false;
                    for (String type : tool.getToolClasses(player.func_184614_ca())) {
                        if (!block1.func_177230_c().isToolEffective(type, block1) || block1.func_177230_c().getHarvestLevel(block1) > tool.getHarvestLevel(player.func_184614_ca(), type, player, block1)) continue;
                        canBeMined1 = true;
                    }
                    if (!canBeMined1) continue;
                    block1.func_177230_c().func_180657_a(event.getWorld(), player, blockpos, block1, null, player.func_184614_ca());
                    world.func_175655_b(blockpos, false);
                    player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        if (player != null && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.education, (EntityLivingBase)player) != 0 && event.getEntityLiving().func_184222_aU()) {
            int lvl = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.education, (EntityLivingBase)player);
            event.setDroppedExperience(Math.round((float)event.getOriginalExperience() * ((float)lvl / 2.0f + 1.0f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        EntityLivingBase entity = event.getEntityLiving();
        double d = 0.01 * (double)EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.agility, (EntityLivingBase)entity);
        AttributeModifier modifier = new AttributeModifier(EnchantmentAgility.speedModifier, "agility", d, 0);
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.agility, (EntityLivingBase)entity) > 0) {
            if (!entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(modifier)) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(modifier);
            } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(EnchantmentAgility.speedModifier).func_111164_d() != d) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(EnchantmentAgility.speedModifier);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(modifier);
            }
        } else {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(EnchantmentAgility.speedModifier);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.vitality, (EntityLivingBase)entity) != 0 && entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration") && player.func_71024_bL().func_75116_a() >= 18 && entity.func_110143_aJ() < entity.func_110138_aP() && entity.field_70173_aa % (40 / EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.vitality, (EntityLivingBase)entity)) == 0) {
            entity.func_70691_i(1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entity = event.getEntityLiving();
        Item item = event.getItem().func_77973_b();
        if (item instanceof ItemBow && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.rapidfire, (EntityLivingBase)entity) != 0) {
            int d = event.getDuration();
            if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.rapidfire, (EntityLivingBase)entity) < 4) {
                if (d % (5 - EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.rapidfire, (EntityLivingBase)entity)) == 0) {
                    event.setDuration(d - 1);
                }
            } else {
                event.setDuration(d - EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.rapidfire, (EntityLivingBase)entity) - 3);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(PlayerEvent.BreakSpeed event) {
        Item item;
        EntityPlayer player = event.getEntityPlayer();
        event.getState();
        event.getState().func_177230_c();
        player.func_184614_ca();
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.versatility, (EntityLivingBase)player) != 0 && player.field_71071_by.func_184438_a(event.getState()) <= 1.0f && (item = player.func_184614_ca().func_77973_b()) instanceof ItemTool) {
            ItemTool tool = (ItemTool)item;
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)tool.func_77861_e());
            event.setNewSpeed(event.getOriginalSpeed() * (material.func_77998_b() / 2.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(LivingAttackEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (event.getSource().func_76364_f() != null) {
            ItemStack stack;
            Entity source;
            if (event.getSource().func_76364_f() instanceof EntityArrow) {
                IArrowProperties cap;
                EntityArrow arrow = (EntityArrow)event.getSource().func_76364_f();
                if (arrow.hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)) {
                    // empty if block
                }
                if ((cap = (IArrowProperties)arrow.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)).getCanRecover() && arrow.field_70250_c != null && arrow.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !arrow.field_70250_c.field_70128_L && arrow.field_70250_c instanceof EntityPlayer) {
                    EntityPlayer shooter = (EntityPlayer)arrow.field_70250_c;
                    ItemStack stack2 = new ItemStack(Items.field_151032_g);
                    boolean flag = shooter.field_71071_by.func_70441_a(stack2);
                    if (flag) {
                        shooter.field_71069_bz.func_75142_b();
                    } else {
                        EntityItem entityitem = shooter.func_71019_a(stack2, false);
                        entityitem.func_174868_q();
                        entityitem.func_145797_a(shooter.func_70005_c_());
                    }
                }
                if (cap.getExplosionPower() > 0.0f) {
                    arrow.field_70170_p.func_72885_a(arrow.field_70250_c, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, cap.getExplosionPower(), arrow.func_70027_ad(), false);
                    arrow.func_70106_y();
                    if (arrow instanceof EntityTippedArrow) {
                        NBTTagCompound compound = arrow.func_189511_e(new NBTTagCompound());
                        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                        if (compound.func_150297_b("Potion", 8)) {
                            PotionType potion = PotionUtils.func_185187_c((NBTTagCompound)compound);
                            for (PotionEffect potioneffect : potion.func_185170_a()) {
                                effects.add(new PotionEffect(potioneffect.func_188419_a(), potioneffect.func_76459_b() / 8, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                            }
                        }
                        for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
                            effects.add(potioneffect);
                        }
                        if (!effects.isEmpty()) {
                            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(arrow.field_70170_p, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v);
                            entityareaeffectcloud.func_184483_a(2.5f * cap.getExplosionPower());
                            entityareaeffectcloud.func_184495_b(-0.5f);
                            entityareaeffectcloud.func_184485_d(10);
                            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
                            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                            for (PotionEffect potioneffect : effects) {
                                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
                            }
                            arrow.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                        }
                    }
                }
            }
            if ((source = event.getSource().func_76364_f()) instanceof EntityLivingBase && !source.field_70170_p.field_72995_K && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.penetration, (EntityLivingBase)((EntityLivingBase)source)) > 0 && !event.getSource().func_82725_o()) {
                int l = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.penetration, (EntityLivingBase)((EntityLivingBase)source));
                float min = event.getAmount() * Math.min((float)(l + 2) / 10.0f, 1.0f);
                event.getEntityLiving().func_70097_a(DamageSource.func_76354_b((Entity)source, (Entity)source), min);
            }
            if (living.func_184607_cu().func_77973_b() instanceof ItemCustomShield && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.reflection, (ItemStack)(stack = living.func_184607_cu())) != 0) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.reflection, (ItemStack)stack);
                Random random = new Random();
                if (random.nextFloat() < 0.15f * (float)level) {
                    source.func_70097_a(DamageSource.func_92087_a((Entity)living), level > 10 ? (float)(level - 10) : (float)(1 + new Random().nextInt(4)));
                    stack.func_77972_a(1, living);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(ArrowLooseEvent event) {
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.multishot, (ItemStack)event.getBow()) > 0) {
            int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.multishot, (ItemStack)event.getBow());
            for (int x = 0; x < l; ++x) {
                int k;
                int j;
                float f;
                float Yaw = new Random().nextFloat() * 30.0f - 15.0f;
                float Pitch = new Random().nextFloat() * 30.0f - 15.0f;
                EntityPlayer entityplayer = event.getEntityPlayer();
                World worldIn = event.getWorld();
                ItemStack stack = event.getBow();
                boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
                ItemStack ammo = ItemStack.field_190927_a;
                if (stack.func_77973_b() instanceof ItemCrossbow) {
                    ItemCrossbow crossbow = (ItemCrossbow)stack.func_77973_b();
                    ammo = crossbow.loadedAmmo(stack);
                }
                if ((ammo = this.findAmmo(entityplayer)).func_190926_b() && !flag) continue;
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack(Items.field_151032_g);
                }
                if (!((double)(f = ItemBow.func_185059_b((int)event.getCharge())) >= 0.1) || worldIn.field_72995_K) continue;
                ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, ammo, (EntityLivingBase)entityplayer);
                entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A + Pitch, entityplayer.field_70177_z + Yaw, 0.0f, f * 3.0f, 1.0f);
                if (f == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityarrow.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityarrow.func_70015_d(100);
                }
                stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                worldIn.func_72838_d((Entity)entityarrow);
            }
        }
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemArrow) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemArrow) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!(itemstack.func_77973_b() instanceof ItemArrow)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onEvent(FOVUpdateEvent event) {
        if (ConfigHandler.FOV) {
            event.setNewfov(1.0f);
        }
    }
}

