/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.item.weapon;

import codersafterdark.compatskills.common.compats.tinkersconstruct.TinkersCompatHandler;
import codersafterdark.reskillable.api.data.FuzzyLockKey;
import codersafterdark.reskillable.api.data.LockKey;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.tools.ranged.IProjectile;

public class AttackDamageLockKey
implements FuzzyLockKey {
    private final double attackDamage;

    public AttackDamageLockKey(double attackDamage) {
        this.attackDamage = attackDamage;
    }

    public AttackDamageLockKey(ItemStack stack) {
        if (stack.func_190926_b()) {
            this.attackDamage = 0.0;
            return;
        }
        Item item = stack.func_77973_b();
        Multimap attributeModifiers = item.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
        Collection damage = attributeModifiers.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        if (damage.isEmpty() && TinkersCompatHandler.ENABLED && item instanceof IProjectile) {
            attributeModifiers = ((IProjectile)item).getProjectileAttributeModifier(stack);
            damage = attributeModifiers.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        }
        if (damage.isEmpty()) {
            this.attackDamage = 0.0;
            return;
        }
        this.attackDamage = damage.stream().findFirst().map(AttributeModifier::func_111164_d).orElse(0.0);
    }

    public boolean fuzzyEquals(FuzzyLockKey o) {
        return o == this || o instanceof AttackDamageLockKey && this.attackDamage >= ((AttackDamageLockKey)o).attackDamage;
    }

    public boolean isNotFuzzy() {
        return false;
    }

    public LockKey getNotFuzzy() {
        return null;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof AttackDamageLockKey && this.attackDamage == ((AttackDamageLockKey)o).attackDamage;
    }

    public int hashCode() {
        return Objects.hash(this.attackDamage);
    }
}

