/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util;

import com.alcatrazescapee.alcatrazcore.util.collections.ImmutablePair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CoreHelpers {
    @Nullable
    public static <TE extends TileEntity> TE getTE(IBlockAccess world, BlockPos pos, Class<TE> clazz) {
        TileEntity te = world.func_175625_s(pos);
        if (clazz.isInstance(te)) {
            return (TE)te;
        }
        return null;
    }

    public static BlockPos getTopSolidBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (mPos.func_177956_o() > 0) {
            mPos.func_189534_c(EnumFacing.DOWN, 1);
            IBlockState state = chunk.func_177435_g((BlockPos)mPos);
            if (!state.func_185904_a().func_76230_c() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mPos) || state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)mPos) || state.func_185904_a().func_76224_d()) continue;
            break;
        }
        return mPos.func_185334_h();
    }

    public static BlockPos getTopNonAirBlock(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (mPos.func_177956_o() > 0) {
            mPos.func_189534_c(EnumFacing.DOWN, 1);
            IBlockState state = chunk.func_177435_g((BlockPos)mPos);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            break;
        }
        return mPos.func_185334_h();
    }

    public static void dropItemInWorld(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    public static void dropItemInWorldExact(World world, BlockPos pos, ItemStack stack) {
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
    }

    public static void dropItemInWorldExact(World world, double x, double y, double z, ItemStack stack) {
        world.func_72838_d((Entity)new EntityItem(world, x, y, z, stack));
    }

    public static void giveItemToPlayer(World world, EntityPlayer player, ItemStack stack) {
        if (!player.func_191521_c(stack)) {
            CoreHelpers.dropItemInWorldExact(world, player.func_180425_c(), stack);
        }
    }

    public static ItemStack consumeItem(ItemStack stack) {
        return CoreHelpers.consumeItem(stack, 1);
    }

    public static ItemStack consumeItem(ItemStack stack, int amount) {
        if (stack.func_190916_E() > amount) {
            stack.func_190918_g(amount);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack consumeItem(EntityPlayer player, ItemStack stack) {
        return player.func_184812_l_() ? stack : CoreHelpers.consumeItem(stack, 1);
    }

    public static ItemStack consumeItem(EntityPlayer player, ItemStack stack, int amount) {
        return player.func_184812_l_() ? stack : CoreHelpers.consumeItem(stack, amount);
    }

    public static boolean doStacksMatch(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return stack2.func_190926_b();
        }
        if (stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE) {
            return true;
        }
        return stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static boolean doStacksMatchIgnoreWildcard(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return stack2.func_190926_b();
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean doStacksMatchUseNBT(ItemStack stack1, ItemStack stack2) {
        return CoreHelpers.doStacksMatch(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || CoreHelpers.doStacksMatchIgnoreWildcard(stack1, stack2);
    }

    public static boolean canMergeStacksUseNBT(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || CoreHelpers.doStacksMatchIgnoreWildcard(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack mergeStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return stack2;
        }
        if (stack2.func_190926_b()) {
            return stack1;
        }
        int amount = Math.min(stack1.func_77976_d(), stack1.func_190916_E() + stack2.func_190916_E());
        stack1.func_190920_e(amount);
        return stack1;
    }

    public static ImmutablePair<ItemStack, ItemStack> mergeStacksWithResult(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return ImmutablePair.of(stack2, ItemStack.field_190927_a);
        }
        if (stack2.func_190926_b()) {
            return ImmutablePair.of(stack1, ItemStack.field_190927_a);
        }
        int amount = stack1.func_190916_E() + stack2.func_190916_E();
        int maxAmount = stack1.func_77976_d();
        stack1.func_190920_e(Math.min(maxAmount, amount));
        if (amount <= maxAmount) {
            return ImmutablePair.of(stack1, ItemStack.field_190927_a);
        }
        stack2.func_190920_e(amount - maxAmount);
        return ImmutablePair.of(stack1, stack2);
    }

    public static boolean doesStackMatchOre(ItemStack stack, String name) {
        int[] ids;
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!name.equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesStackMatchOre(ItemStack stack, int id) {
        int[] ids;
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != i) continue;
            return true;
        }
        return false;
    }

    public static boolean doesStackMatchOrePrefix(ItemStack stack, String prefix) {
        int[] ids;
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (oreName.length() < prefix.length() || !oreName.substring(0, prefix.length()).equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesOreHaveStack(String ore) {
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            return false;
        }
        NonNullList stacks = OreDictionary.getOres((String)ore, (boolean)false);
        return !stacks.isEmpty();
    }

    public static ItemStack getStackForOre(String ore) {
        NonNullList stacks;
        if (OreDictionary.doesOreNameExist((String)ore) && !(stacks = OreDictionary.getOres((String)ore, (boolean)false)).isEmpty()) {
            return (ItemStack)stacks.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getStackForOre(String ore, String preferredModID) {
        NonNullList stacks;
        if (OreDictionary.doesOreNameExist((String)ore) && !(stacks = OreDictionary.getOres((String)ore, (boolean)false)).isEmpty()) {
            if (stacks.size() == 1) {
                return (ItemStack)stacks.get(0);
            }
            return stacks.stream().filter(x -> x.func_77973_b().getRegistryName().func_110624_b().equals(preferredModID)).findFirst().orElse((ItemStack)stacks.get(0));
        }
        return ItemStack.field_190927_a;
    }

    public static String getOreName(ItemStack stack) {
        int id = CoreHelpers.getOreID(stack);
        if (id >= 0) {
            return OreDictionary.getOreName((int)id);
        }
        return "";
    }

    public static int getOreID(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length >= 1) {
            return ids[0];
        }
        return -1;
    }

    public static ItemStack getStackByRegistryName(String name) {
        return CoreHelpers.getStackByRegistryName(name, 1, 0);
    }

    public static ItemStack getStackByRegistryName(String name, int meta) {
        return CoreHelpers.getStackByRegistryName(name, 1, meta);
    }

    public static ItemStack getStackByRegistryName(String name, int amount, int meta) {
        Item item = Item.func_111206_d((String)name);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, amount, meta);
    }

    public static boolean doStacksMatch(@Nullable FluidStack stack1, @Nullable FluidStack stack2) {
        if (stack1 == null) {
            return stack2 == null;
        }
        if (stack2 == null) {
            return false;
        }
        return stack1.getFluid() == stack2.getFluid();
    }

    public static boolean doStacksMatchUseNBT(@Nullable FluidStack stack1, @Nullable FluidStack stack2) {
        return stack1 != null ? stack1.isFluidEqual(stack2) : stack2 == null;
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }
}

