/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util;

import com.alcatrazescapee.alcatrazcore.block.BlockFluidCore;
import com.alcatrazescapee.alcatrazcore.client.IModelProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public final class RegistryHelper {
    private static final Map<String, RegistryHelper> MAP = new HashMap<String, RegistryHelper>();
    private final String modID;
    private final List<Block> BLOCKS = new ArrayList<Block>();
    private final List<Item> ITEMS = new ArrayList<Item>();
    private final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();

    @Nonnull
    public static RegistryHelper get(String modID) {
        if (!MAP.containsKey(modID)) {
            MAP.put(modID, new RegistryHelper(modID));
        }
        return MAP.get(modID);
    }

    private RegistryHelper(String modID) {
        this.modID = modID;
    }

    public void initModels(ModelRegistryEvent event) {
        for (Block block : this.BLOCKS) {
            if (!(block instanceof IModelProvider)) continue;
            ((IModelProvider)block).registerModel();
        }
        for (Item item : this.ITEMS) {
            if (!(item instanceof IModelProvider)) continue;
            ((IModelProvider)item).registerModel();
        }
        this.BLOCKS.clear();
        this.ITEMS.clear();
    }

    public void initBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : this.BLOCKS) {
            registry.register((IForgeRegistryEntry)block);
        }
    }

    public void initItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : this.ITEMS) {
            registry.register((IForgeRegistryEntry)item);
        }
    }

    public void initSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEvent sound : this.SOUNDS) {
            registry.register((IForgeRegistryEntry)sound);
        }
        this.SOUNDS.clear();
    }

    public <T extends Item> T registerItem(T item, String name, CreativeTabs tab) {
        item.func_77637_a(tab);
        return this.registerItem(item, name);
    }

    public <T extends Item> T registerItem(T item, String name) {
        item.setRegistryName(this.modID + ":" + name.toLowerCase());
        item.func_77655_b(this.modID + ":" + name.toLowerCase().replace('/', '.'));
        this.ITEMS.add(item);
        return item;
    }

    public <T extends TileEntity> void registerTile(Class<T> clazz, String name) {
        TileEntity.func_190560_a((String)(this.modID + ":" + name.toLowerCase()), clazz);
    }

    public <T extends Fluid> T registerFluid(T fluid, String name) {
        return (T)this.registerFluid(fluid, name, Material.field_151586_h, BlockFluidCore::new);
    }

    public <T extends Fluid> T registerFluid(T fluid, String name, Material material) {
        return (T)this.registerFluid(fluid, name, material, BlockFluidCore::new);
    }

    public <T extends Fluid> T registerFluid(T fluid, String name, Material material, @Nullable BiFunction<T, Material, BlockFluidBase> fluidBlockSupplier) {
        BlockFluidBase fluidBlock;
        fluid.setUnlocalizedName(this.modID + "." + name.toLowerCase().replace('/', '.'));
        FluidRegistry.registerFluid(fluid);
        FluidRegistry.addBucketForFluid(fluid);
        if (fluidBlockSupplier != null && (fluidBlock = fluidBlockSupplier.apply(fluid, material)) != null) {
            this.registerBlock(fluidBlock, null, "fluid/" + fluid.getName());
        }
        return fluid;
    }

    public <T extends SoundEvent> T registerSound(T sound, String name) {
        sound.setRegistryName(new ResourceLocation(this.modID, name.toLowerCase()));
        this.SOUNDS.add(sound);
        return sound;
    }

    public SoundEvent registerSound(String name) {
        ResourceLocation loc = new ResourceLocation(this.modID, name.toLowerCase());
        SoundEvent sound = new SoundEvent(loc);
        sound.setRegistryName(loc);
        this.SOUNDS.add(sound);
        return sound;
    }

    public <T extends Block> T registerBlock(T block, String name, CreativeTabs tab) {
        return this.registerBlock(block, ItemBlock::new, name, tab);
    }

    public <T extends Block> T registerBlock(T block, String name) {
        return this.registerBlock(block, ItemBlock::new, name);
    }

    public <T extends Block> T registerBlock(T block, @Nullable Function<Block, ItemBlock> itemBlockSupplier, String name, CreativeTabs tab) {
        block.func_149647_a(tab);
        return this.registerBlock(block, itemBlockSupplier, name);
    }

    public <T extends Block> T registerBlock(T block, @Nullable Function<Block, ItemBlock> itemBlockSupplier, String name) {
        ItemBlock itemBlock;
        block.setRegistryName(this.modID + ":" + name.toLowerCase());
        block.func_149663_c(this.modID + ":" + name.toLowerCase().replace('/', '.'));
        this.BLOCKS.add(block);
        if (itemBlockSupplier != null && (itemBlock = itemBlockSupplier.apply(block)) != null) {
            itemBlock.setRegistryName(this.modID + ":" + name.toLowerCase());
            itemBlock.func_77655_b(this.modID + ":" + name.toLowerCase().replace('/', '.'));
            this.ITEMS.add((Item)itemBlock);
        }
        return block;
    }
}

