/*
 * Decompiled with CFR 0.152.
 */
package tschipp.forgottenitems.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tschipp.forgottenitems.FIM;
import tschipp.forgottenitems.util.FIConfig;
import tschipp.forgottenitems.util.FIHelper;
import tschipp.tschipplib.item.TSAxe;

public class ItemBoundAxe
extends TSAxe {
    public ItemBoundAxe(Item.ToolMaterial material) {
        super("bound_axe", material, "forgottenitems", 8.0f, -3.0f);
        this.func_77637_a(FIM.forgottenItems);
        FIHelper.setOutputCore(22, (Item)this, Items.field_151056_x);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (player != null && player instanceof EntityPlayer && !(player instanceof FakePlayer)) {
            NBTTagCompound tag = new NBTTagCompound();
            String uuid = player.func_146103_bH().getName();
            tag.func_74778_a("owner", uuid);
            stack.func_77982_d(tag);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean onEntityItemUpdate(EntityItem item) {
        item.func_184224_h(true);
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer) {
            String owner;
            EntityPlayer player = (EntityPlayer)entity;
            String playername = player.func_146103_bH().getName();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && !(owner = stack.func_77978_p().func_74779_i("owner")).equals(playername)) {
                if (!world.field_72995_K) {
                    player.func_70099_a(stack, 0.5f);
                }
                player.field_71071_by.func_70304_b(itemSlot);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && !world.field_72995_K && player.func_184812_l_()) {
            FIHelper.printCraftingRecipe(world, player, 22);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("owner")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("owner", player.func_146103_bH().getName());
            stack.func_77982_d(tag);
            player.func_184611_a(hand, stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return "" + TextFormatting.AQUA + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner")) {
            tooltip.add("Bound to " + stack.func_77978_p().func_74779_i("owner"));
        } else {
            tooltip.add("Unbound");
        }
        tooltip.add("Stays in the inventory on death.");
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color
    implements IItemColor {
        @SideOnly(value=Side.CLIENT)
        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("owner") && tintIndex == 0) {
                String owner = stack.func_77978_p().func_74779_i("owner");
                String[] boundColors = FIConfig.customBoundColors;
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < boundColors.length; ++i) {
                    list.add(boundColors[i]);
                }
                if (list.contains(owner)) {
                    int index = list.indexOf(owner);
                    String color = (String)list.get(index + 1);
                    try {
                        int colorint = Integer.parseInt(color);
                        return colorint;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    Random rand = new Random(owner.hashCode());
                    return rand.nextInt(0xFFFFFF);
                }
            }
            return -1;
        }
    }
}

