/*
 * Decompiled with CFR 0.152.
 */
package tschipp.forgottenitems.items;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tschipp.forgottenitems.FIM;
import tschipp.forgottenitems.models.ModelGolemArmor;
import tschipp.forgottenitems.util.FIHelper;

public class ItemGolemArmor
extends ItemArmor {
    private int id;
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public ItemGolemArmor(String name, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, int id, Item core) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.registerItem(name);
        this.func_77637_a(FIM.forgottenItems);
        this.id = id;
        FIHelper.setOutputCore(id, (Item)this, core);
    }

    private void registerItem(String name) {
        super.func_77655_b(name);
        this.setRegistryName(new ResourceLocation("forgottenitems:" + name));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return "" + TextFormatting.DARK_AQUA + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add("Hard like a Rock");
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
        ModelGolemArmor armorModel;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor && (armorModel = (ModelGolemArmor)FIM.proxy.getGolemArmor().get((Object)this)) != null) {
            armorModel.field_78116_c.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            armorModel.field_178720_f.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            armorModel.field_78115_e.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            armorModel.field_178723_h.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            armorModel.field_178724_i.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            armorModel.LeftLeg.field_78806_j = slot == EntityEquipmentSlot.LEGS;
            armorModel.RightLeg.field_78806_j = slot == EntityEquipmentSlot.LEGS;
            armorModel.LeftFoot.field_78806_j = slot == EntityEquipmentSlot.FEET;
            armorModel.RightFoot.field_78806_j = slot == EntityEquipmentSlot.FEET;
            armorModel.field_78117_n = defaultModel.field_78117_n;
            armorModel.field_78093_q = defaultModel.field_78093_q;
            armorModel.field_78091_s = defaultModel.field_78091_s;
            if (living instanceof EntityArmorStand) {
                armorModel.field_78095_p = 0.0f;
            }
            armorModel.field_187076_m = defaultModel.field_187076_m;
            armorModel.field_187075_l = defaultModel.field_187075_l;
            return armorModel;
        }
        return null;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor toughness", (double)this.field_189415_e, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "generic.knockbackResistance", 0.25, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && !world.field_72995_K && player.func_184812_l_()) {
            FIHelper.printCraftingRecipe(world, player, this.id);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }
}

