/*
 * Decompiled with CFR 0.152.
 */
package tschipp.forgottenitems.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import tschipp.forgottenitems.util.FIConfig;
import tschipp.forgottenitems.util.FIWorldSavedData;

public class FIHelper {
    public static ArrayList<HashMap<Item, Item>> OUTPUTS_CORES = new ArrayList();
    public static ArrayList<HashMap<Item, Item>> CUSTOM_OUTPUTS_CORES = new ArrayList();
    public static ArrayList<String> forbiddenList = new ArrayList();
    public static ArrayList<String> whitelist = new ArrayList();
    public static ArrayList<Item> vanillaItems = new ArrayList();

    public static void setOutputCore(int id, Item output, Item core) {
        HashMap<Item, Item> map = new HashMap<Item, Item>();
        map.put(output, core);
        OUTPUTS_CORES.set(id, map);
    }

    public static Item getCoreItem(int id) {
        try {
            return OUTPUTS_CORES.get(id).entrySet().iterator().next().getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Item getOutputItem(int id) {
        try {
            return OUTPUTS_CORES.get(id).entrySet().iterator().next().getKey();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setOutputCoreCustom(int id, Item output, Item core) {
        HashMap<Item, Item> map = new HashMap<Item, Item>();
        map.put(output, core);
        CUSTOM_OUTPUTS_CORES.set(id, map);
    }

    public static Item getCoreItemCustom(int id) {
        try {
            return CUSTOM_OUTPUTS_CORES.get(id).entrySet().iterator().next().getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Item getOutputItemCustom(int id) {
        try {
            return CUSTOM_OUTPUTS_CORES.get(id).entrySet().iterator().next().getKey();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getSeed(World world) {
        if (!world.field_72995_K) {
            return Math.abs(world.func_72905_C());
        }
        return FIWorldSavedData.getInstance(world).getSeed();
    }

    public static Item getNewItemBySeed(long seed, World world) {
        Item item = null;
        ArrayList<String> forbiddenList = FIWorldSavedData.getInstance(world).getForbidden();
        int k = 0;
        while (forbiddenList != null && (item == null || forbiddenList.contains(item.getRegistryName().toString()))) {
            Random rand = new Random(seed + (long)k);
            if (FIConfig.useWhitelist) {
                ArrayList<String> whitelist = FIHelper.getWhitelist();
                item = Item.func_111206_d((String)whitelist.get(rand.nextInt(whitelist.size())));
            } else if (FIConfig.useNonVanillaItems) {
                item = Item.func_111206_d((String)((ResourceLocation)Item.field_150901_e.func_148742_b().toArray()[rand.nextInt(Item.field_150901_e.func_148742_b().size())]).toString());
            } else {
                ArrayList<Item> vanilla = FIHelper.getVanilla();
                item = vanilla.get(rand.nextInt(vanilla.size()));
            }
            ++k;
        }
        return item;
    }

    public static Item getItemBySeed(long seed, int number, int id, World world) {
        Item item = null;
        ArrayList<String> forbiddenList = FIWorldSavedData.getInstance(world).getForbidden();
        int k = 0;
        while (forbiddenList != null && (item == null || forbiddenList.contains(item.getRegistryName().toString()))) {
            Random rand = new Random((seed + (long)k) / (long)(number * id) + (long)id);
            if (FIConfig.useWhitelist) {
                ArrayList<String> whitelist = FIHelper.getWhitelist();
                item = Item.func_111206_d((String)whitelist.get(rand.nextInt(whitelist.size())));
            } else if (FIConfig.useNonVanillaItems) {
                item = Item.func_111206_d((String)((ResourceLocation)Item.field_150901_e.func_148742_b().toArray()[rand.nextInt(Item.field_150901_e.func_148742_b().size())]).toString());
            } else {
                ArrayList<Item> vanilla = FIHelper.getVanilla();
                item = vanilla.get(rand.nextInt(vanilla.size()));
            }
            ++k;
        }
        return item;
    }

    public static Item getCustomItemBySeed(long seed, int number, int id, World world) {
        Item item = null;
        ArrayList<String> forbiddenList = FIWorldSavedData.getInstance(world).getForbidden();
        int k = 0;
        while (forbiddenList != null && (item == null || forbiddenList.contains(item.getRegistryName().toString()))) {
            Random rand = new Random((seed * (seed / 2L) + (long)k) / (long)(number * id) + (long)id);
            if (FIConfig.useWhitelist) {
                ArrayList<String> whitelist = FIHelper.getWhitelist();
                item = Item.func_111206_d((String)whitelist.get(rand.nextInt(whitelist.size())));
            } else if (FIConfig.useNonVanillaItems) {
                item = Item.func_111206_d((String)((ResourceLocation)Item.field_150901_e.func_148742_b().toArray()[rand.nextInt(Item.field_150901_e.func_148742_b().size())]).toString());
            } else {
                ArrayList<Item> vanilla = FIHelper.getVanilla();
                item = vanilla.get(rand.nextInt(vanilla.size()));
            }
            ++k;
        }
        return item;
    }

    public static ArrayList<String> getForbiddenList() {
        if (forbiddenList.isEmpty()) {
            String[] forbidden = FIConfig.bannedItems;
            forbiddenList = new ArrayList();
            for (int i = 0; i < forbidden.length; ++i) {
                if (forbidden[i].contains("*")) {
                    String modid = forbidden[i].replace("*", "");
                    for (int k = 0; k < Item.field_150901_e.func_148742_b().size(); ++k) {
                        if (!Item.field_150901_e.func_148742_b().toArray()[k].toString().contains(modid)) continue;
                        forbiddenList.add(Item.field_150901_e.func_148742_b().toArray()[k].toString());
                    }
                }
                forbiddenList.add(forbidden[i]);
            }
        }
        return forbiddenList;
    }

    public static ArrayList<String> getWhitelist() {
        if (whitelist.isEmpty()) {
            String[] whitelistar = FIConfig.whitelist;
            whitelist = new ArrayList();
            for (int i = 0; i < whitelistar.length; ++i) {
                if (whitelistar[i].contains("*")) {
                    String modid = whitelistar[i].replace("*", "");
                    for (int k = 0; k < Item.field_150901_e.func_148742_b().size(); ++k) {
                        if (!Item.field_150901_e.func_148742_b().toArray()[k].toString().contains(modid)) continue;
                        whitelist.add(Item.field_150901_e.func_148742_b().toArray()[k].toString());
                    }
                }
                whitelist.add(whitelistar[i]);
            }
        }
        return whitelist;
    }

    public static ArrayList<Item> getVanilla() {
        if (vanillaItems.isEmpty()) {
            ForgeRegistries.ITEMS.getValues().forEach(item -> {
                if (item.getRegistryName().func_110624_b().equals("minecraft")) {
                    vanillaItems.add((Item)item);
                }
            });
        }
        return vanillaItems;
    }

    public static boolean hasItem(Item item, EntityPlayer player) {
        List<NonNullList> allInventories = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        for (List list : allInventories) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != item) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasArmorItem(Item item, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            if (((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static int getSlotForItem(Item item, EntityPlayer player) {
        List<NonNullList> allInventories = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        for (int k = 0; k < allInventories.size(); ++k) {
            NonNullList list = allInventories.get(k);
            for (int i = 0; i < list.size(); ++i) {
                if (((ItemStack)list.get(i)).func_190926_b() || ((ItemStack)list.get(i)).func_77973_b() != item) continue;
                if (list.size() == 4) {
                    return 36 + i;
                }
                if (list.size() == 1) {
                    return 40;
                }
                return i;
            }
        }
        return -1;
    }

    public static void printCraftingRecipe(World world, EntityPlayer player, int id) {
        long seed = FIHelper.getSeed(world);
        Item item1 = FIHelper.getItemBySeed(seed, 1, id, world);
        Item item2 = FIHelper.getItemBySeed(seed, 2, id, world);
        Item item3 = FIHelper.getItemBySeed(seed, 3, id, world);
        Item item4 = FIHelper.getItemBySeed(seed, 4, id, world);
        Item item5 = FIHelper.getItemBySeed(seed, 5, id, world);
        Item item6 = FIHelper.getItemBySeed(seed, 6, id, world);
        Item item7 = FIHelper.getItemBySeed(seed, 7, id, world);
        Item item8 = FIHelper.getItemBySeed(seed, 8, id, world);
        Item core = FIHelper.getCoreItem(id);
        if (FIConfig.recipeGivesItems) {
            player.field_71071_by.func_70441_a(new ItemStack(item1, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item2, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item3, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item4, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item5, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item6, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item7, 64));
            player.field_71071_by.func_70441_a(new ItemStack(item8, 64));
            player.field_71071_by.func_70441_a(new ItemStack(core, 64));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Core Item: " + core.getRegistryName() + ", Other Items: " + item1.getRegistryName() + ", " + item2.getRegistryName() + ", " + item3.getRegistryName() + ", " + item4.getRegistryName() + ", " + item5.getRegistryName() + ", " + item6.getRegistryName() + ", " + item7.getRegistryName() + ", " + item8.getRegistryName()));
        FMLLog.log((String)"ForgottenItems", (Level)Level.INFO, (String)("Core Item: " + core.getRegistryName() + ", Other Items: " + item1.getRegistryName() + ", " + item2.getRegistryName() + ", " + item3.getRegistryName() + ", " + item4.getRegistryName() + ", " + item5.getRegistryName() + ", " + item6.getRegistryName() + ", " + item7.getRegistryName() + ", " + item8.getRegistryName()), (Object[])new Object[0]);
    }

    public static ArrayList<Item> getItemsForRecipe(World world, int id) {
        long seed = FIHelper.getSeed(world);
        ArrayList<Item> craftingList = new ArrayList<Item>();
        Item item1 = FIHelper.getItemBySeed(seed, 1, id, world);
        Item item2 = FIHelper.getItemBySeed(seed, 2, id, world);
        Item item3 = FIHelper.getItemBySeed(seed, 3, id, world);
        Item item4 = FIHelper.getItemBySeed(seed, 4, id, world);
        Item item5 = FIHelper.getItemBySeed(seed, 5, id, world);
        Item item6 = FIHelper.getItemBySeed(seed, 6, id, world);
        Item item7 = FIHelper.getItemBySeed(seed, 7, id, world);
        Item item8 = FIHelper.getItemBySeed(seed, 8, id, world);
        Item core = null;
        try {
            core = FIHelper.getCoreItem(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        craftingList.add(item1);
        craftingList.add(item2);
        craftingList.add(item3);
        craftingList.add(item4);
        craftingList.add(core);
        craftingList.add(item5);
        craftingList.add(item6);
        craftingList.add(item7);
        craftingList.add(item8);
        return craftingList;
    }

    public static ArrayList<Item> getItemsForCustomRecipe(World world, int id) {
        long seed = FIHelper.getSeed(world);
        ArrayList<Item> craftingList = new ArrayList<Item>();
        String[] customRecipes = FIConfig.customCraftingRecipes;
        Item item1 = FIHelper.getCustomItemBySeed(seed, 1, id, world);
        Item item2 = FIHelper.getCustomItemBySeed(seed, 2, id, world);
        Item item3 = FIHelper.getCustomItemBySeed(seed, 3, id, world);
        Item item4 = FIHelper.getCustomItemBySeed(seed, 4, id, world);
        Item item5 = FIHelper.getCustomItemBySeed(seed, 5, id, world);
        Item item6 = FIHelper.getCustomItemBySeed(seed, 6, id, world);
        Item item7 = FIHelper.getCustomItemBySeed(seed, 7, id, world);
        Item item8 = FIHelper.getCustomItemBySeed(seed, 8, id, world);
        Item core = null;
        try {
            core = Item.func_111206_d((String)customRecipes[id - 1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        craftingList.add(item1);
        craftingList.add(item2);
        craftingList.add(item3);
        craftingList.add(item4);
        craftingList.add(core);
        craftingList.add(item5);
        craftingList.add(item6);
        craftingList.add(item7);
        craftingList.add(item8);
        return craftingList;
    }
}

