/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controllers;

import com.yyon.grapplinghook.GrappleCustomization;
import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.network.GrappleEndMessage;
import com.yyon.grapplinghook.network.PlayerMovementMessage;
import com.yyon.grapplinghook.vec;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class grappleController {
    public int entityId;
    public World world;
    public Entity entity;
    public HashSet<grappleArrow> arrows = new HashSet();
    public HashSet<Integer> arrowIds = new HashSet();
    public boolean attached = true;
    public vec motion;
    public double playerforward = 0.0;
    public double playerstrafe = 0.0;
    public boolean playerjump = false;
    public boolean waitingonplayerjump = false;
    public vec playermovement_unrotated = new vec(0.0, 0.0, 0.0);
    public vec playermovement = new vec(0.0, 0.0, 0.0);
    public int ongroundtimer = 0;
    public int maxongroundtimer = 3;
    public double maxlen;
    public double playermovementmult = 0.0;
    public int controllerid;
    public GrappleCustomization custom = null;
    public double repelmaxpush = 0.3;

    public grappleController(int arrowId, int entityId, World world, vec pos, int controllerid, GrappleCustomization custom) {
        this.entityId = entityId;
        this.world = world;
        this.custom = custom;
        if (this.custom != null) {
            this.playermovementmult = this.custom.playermovementmult;
            this.maxlen = custom.maxlen;
        }
        this.controllerid = controllerid;
        this.entity = world.func_73045_a(entityId);
        this.motion = vec.motionvec(this.entity);
        this.ongroundtimer = 0;
        grapplemod.registerController(this.entityId, this);
        if (arrowId != -1) {
            Entity arrowentity = world.func_73045_a(arrowId);
            if (arrowentity != null && !arrowentity.field_70128_L && arrowentity instanceof grappleArrow) {
                this.addArrow((grappleArrow)arrowentity);
            } else {
                this.unattach();
            }
        }
    }

    public void unattach() {
        if (grapplemod.controllers.containsValue(this)) {
            this.attached = false;
            grapplemod.unregisterController(this.entityId);
            if (this.controllerid != grapplemod.AIRID) {
                grapplemod.network.sendToServer((IMessage)new GrappleEndMessage(this.entityId, this.arrowIds));
                grapplemod.createControl(grapplemod.AIRID, -1, this.entityId, this.entity.field_70170_p, new vec(0.0, 0.0, 0.0), null, null);
            }
        }
    }

    public void doClientTick() {
        if (this.attached) {
            if (this.entity == null || this.entity.field_70128_L) {
                this.unattach();
            } else {
                grapplemod.proxy.getplayermovement(this, this.entityId);
                this.updatePlayerPos();
            }
        }
    }

    public void receivePlayerMovementMessage(float strafe, float forward, boolean jump) {
        this.playerforward = forward;
        this.playerstrafe = strafe;
        if (!jump) {
            this.playerjump = false;
        } else if (jump && !this.playerjump) {
            this.playerjump = true;
            this.waitingonplayerjump = true;
        }
        this.playermovement_unrotated = new vec(strafe, 0.0, forward);
        this.playermovement = this.playermovement_unrotated.rotate_yaw((float)((double)this.entity.field_70177_z * (Math.PI / 180)));
    }

    public boolean isjumping() {
        if (this.playerjump && this.waitingonplayerjump) {
            this.waitingonplayerjump = false;
            return true;
        }
        return false;
    }

    public void updatePlayerPos() {
        Entity entity = this.entity;
        if (this.attached && entity != null) {
            this.normalGround();
            this.normalCollisions();
            this.applyAirFriction();
            vec playerpos = vec.positionvec(entity);
            playerpos = playerpos.add(new vec(0.0, entity.func_70047_e(), 0.0));
            Object additionalmotion = new vec(0.0, 0.0, 0.0);
            vec gravity = new vec(0.0, -0.05, 0.0);
            if (this.ongroundtimer <= 0) {
                this.motion.add_ip(gravity);
            }
            boolean doJump = false;
            double jumpSpeed = 0.0;
            boolean isClimbing = false;
            boolean motor = false;
            if (this.custom.motor) {
                if (grapplemod.proxy.isSneaking(entity) && this.custom.motorwhencrouching) {
                    motor = true;
                } else if (!grapplemod.proxy.isSneaking(entity) && this.custom.motorwhennotcrouching) {
                    motor = true;
                }
            }
            boolean close = false;
            for (grappleArrow arrow : this.arrows) {
                vec arrowpos = vec.positionvec((Entity)arrow);
                if (this.custom.phaserope) {
                    arrow.segmenthandler.updatepos(arrowpos, playerpos, arrow.r);
                } else {
                    arrow.segmenthandler.update(arrowpos, playerpos, arrow.r, false);
                }
                vec anchor = arrow.segmenthandler.getclosest(arrowpos);
                double distToAnchor = arrow.segmenthandler.getDistToAnchor();
                double remaininglength = arrow.r - distToAnchor;
                vec oldspherevec = playerpos.sub(anchor);
                vec spherevec = oldspherevec.changelen(remaininglength);
                Iterator<grappleArrow> spherechange = spherevec.sub(oldspherevec);
                if (motor) {
                    arrow.r = distToAnchor + oldspherevec.length();
                }
                if (!(oldspherevec.length() < remaininglength) && !motor) {
                    additionalmotion = spherechange;
                }
                double dist = oldspherevec.length();
                this.calctaut(dist, arrow);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (this.isjumping()) {
                        if (this.ongroundtimer <= 0) {
                            doJump = true;
                            jumpSpeed = this.getJumpPower((Entity)player, spherevec, arrow);
                        }
                    } else if (grapplemod.proxy.isSneaking(entity) && !motor) {
                        isClimbing = true;
                        if (anchor.y > playerpos.y) {
                            vec motiontorwards = spherevec.changelen(-0.1);
                            motiontorwards = new vec(motiontorwards.x, 0.0, motiontorwards.z);
                            if (this.motion.dot(motiontorwards) < 0.0) {
                                this.motion.add_ip(motiontorwards);
                            }
                            vec newmotion = this.dampenmotion(this.motion, motiontorwards);
                            this.motion = new vec(newmotion.x, this.motion.y, newmotion.z);
                            if (this.playerforward != 0.0 && (dist < this.maxlen || this.playerforward > 0.0 || this.maxlen == 0.0)) {
                                additionalmotion = new vec(0.0, this.playerforward, 0.0);
                                arrow.r = dist + distToAnchor;
                                arrow.r -= this.playerforward * 0.3;
                                if (arrow.r < distToAnchor) {
                                    arrow.r = dist + distToAnchor;
                                }
                            }
                        }
                    }
                }
                if (dist + distToAnchor < 2.0) {
                    close = true;
                }
                if (!(anchor.sub(playerpos.add(this.motion)).length() > remaininglength) || motor) continue;
                this.motion = this.motion.removealong(spherevec);
            }
            vec facing = new vec(entity.func_70040_Z()).normalize();
            if (motor) {
                double sidewayspull;
                vec currentsideways;
                vec sideways;
                vec facingside;
                vec facingxy;
                vec pull;
                vec spherevec;
                vec anchor;
                vec arrowpos;
                boolean dopull = true;
                if (this.custom.doublehook && this.arrows.size() == 1) {
                    boolean isdouble = true;
                    for (grappleArrow arrow : this.arrows) {
                        if (arrow.isdouble) continue;
                        isdouble = false;
                    }
                    if (isdouble && !this.custom.oneropepull) {
                        dopull = false;
                    }
                }
                vec totalpull = new vec(0.0, 0.0, 0.0);
                double accel = this.custom.motoracceleration / (double)this.arrows.size();
                double minabssidewayspull = 999.0;
                boolean firstpull = true;
                boolean pullispositive = true;
                boolean pullissameway = true;
                for (grappleArrow arrow : this.arrows) {
                    arrowpos = vec.positionvec((Entity)arrow);
                    anchor = arrow.segmenthandler.getclosest(arrowpos);
                    spherevec = playerpos.sub(anchor);
                    pull = spherevec.mult(-1.0);
                    arrow.pull = accel;
                    totalpull.add_ip(pull.changelen(accel));
                    pull.changelen_ip(arrow.pull);
                    if (!(pull.dot(facing) > 0.0) && !this.custom.pullbackwards || !this.custom.smartdoublemotor || this.arrows.size() <= 1) continue;
                    facingxy = new vec(facing.x, 0.0, facing.z);
                    facingside = facingxy.cross(new vec(0.0, 1.0, 0.0)).normalize();
                    sideways = pull.proj(facingside);
                    currentsideways = this.motion.proj(facingside);
                    sideways.add_ip(currentsideways);
                    sidewayspull = sideways.dot(facingside);
                    if (Math.abs(sidewayspull) < minabssidewayspull) {
                        minabssidewayspull = Math.abs(sidewayspull);
                    }
                    if (firstpull) {
                        firstpull = false;
                        pullispositive = sidewayspull >= 0.0;
                        continue;
                    }
                    if (pullispositive == sidewayspull >= 0.0) continue;
                    pullissameway = false;
                }
                if (this.custom.smartdoublemotor && this.arrows.size() > 1) {
                    totalpull = new vec(0.0, 0.0, 0.0);
                    for (grappleArrow arrow : this.arrows) {
                        arrowpos = vec.positionvec((Entity)arrow);
                        anchor = arrow.segmenthandler.getclosest(arrowpos);
                        spherevec = playerpos.sub(anchor);
                        pull = spherevec.mult(-1.0);
                        pull.changelen_ip(arrow.pull);
                        if (pull.dot(facing) > 0.0 || this.custom.pullbackwards) {
                            facingxy = new vec(facing.x, 0.0, facing.z);
                            facingside = facingxy.cross(new vec(0.0, 1.0, 0.0)).normalize();
                            sideways = pull.proj(facingside);
                            currentsideways = this.motion.proj(facingside);
                            sideways.add_ip(currentsideways);
                            sidewayspull = sideways.dot(facingside);
                            if (pullissameway) {
                                if (Math.abs(sidewayspull) > minabssidewayspull + 0.05) {
                                    arrow.pull = 0.0;
                                }
                            } else {
                                arrow.pull = arrow.pull * minabssidewayspull / Math.abs(sidewayspull);
                            }
                            totalpull.add_ip(pull.changelen(arrow.pull));
                            continue;
                        }
                        if (!arrow.isdouble || this.custom.oneropepull) continue;
                        dopull = false;
                    }
                }
                double pullmult = 1.0;
                if (this.custom.smartmotor && totalpull.y > 0.0 && this.ongroundtimer <= 0 && !entity.field_70122_E) {
                    double pulll;
                    vec pullxzvector = new vec(totalpull.x, 0.0, totalpull.z);
                    double pullxz = pullxzvector.length();
                    double motionxz = this.motion.proj(pullxzvector).dot(pullxzvector.normalize());
                    double facingxz = facing.proj(pullxzvector).dot(pullxzvector.normalize());
                    pullmult = (facingxz * (this.motion.y + gravity.y) - motionxz * facing.y) / (facing.y * pullxz - facingxz * totalpull.y);
                    if (facing.y * pullxz - facingxz * totalpull.y == 0.0) {
                        pullmult = 9999.0;
                    }
                    if ((pulll = pullmult * totalpull.length()) > this.custom.motoracceleration) {
                        pulll = this.custom.motoracceleration;
                    }
                    if (pulll < 0.0) {
                        pulll = 0.0;
                    }
                    pullmult = pulll / totalpull.length();
                }
                if (this.motion.dot(totalpull) > 0.0 && this.motion.proj(totalpull).length() + totalpull.mult(pullmult).length() > this.custom.motormaxspeed && (pullmult = (this.custom.motormaxspeed - this.motion.proj(totalpull).length()) / totalpull.length()) < 0.0) {
                    pullmult = 0.0;
                }
                if (this.custom.motordampener && totalpull.length() != 0.0) {
                    this.motion = this.dampenmotion(this.motion, totalpull);
                }
                if (dopull) {
                    for (grappleArrow arrow : this.arrows) {
                        vec arrowpos2 = vec.positionvec((Entity)arrow);
                        vec anchor2 = arrow.segmenthandler.getclosest(arrowpos2);
                        vec spherevec2 = playerpos.sub(anchor2);
                        vec pull2 = spherevec2.mult(-1.0);
                        pull2.changelen_ip(arrow.pull * pullmult);
                        if (!(pull2.dot(facing) > 0.0) && !this.custom.pullbackwards || !(arrow.pull > 0.0)) continue;
                        this.motion.add_ip(pull2);
                    }
                }
                if (close && this.arrows.size() <= 1 && (entity.field_70132_H || entity.field_70122_E)) {
                    this.motion.mult_ip(0.6);
                }
            }
            if (this.custom.repel) {
                vec blockpush = this.check_repel(playerpos, entity.field_70170_p);
                blockpush.mult_ip(this.custom.repelforce * 0.5);
                blockpush = new vec(blockpush.x * 0.5, blockpush.y * 2.0, blockpush.z * 0.5);
                this.motion.add_ip(blockpush);
            }
            if (!doJump && !isClimbing) {
                this.applyPlayerMovement();
            }
            if (doJump) {
                if (jumpSpeed <= 0.0) {
                    jumpSpeed = 0.0;
                }
                if (jumpSpeed > 1.0) {
                    jumpSpeed = 1.0;
                }
                this.doJump(entity, jumpSpeed);
                return;
            }
            vec newmotion = this.motion.add((vec)additionalmotion);
            if (Double.isNaN(newmotion.x) || Double.isNaN(newmotion.y) || Double.isNaN(newmotion.z)) {
                newmotion = new vec(0.0, 0.0, 0.0);
                this.motion = new vec(0.0, 0.0, 0.0);
                System.out.println("error: motion is NaN");
            }
            entity.field_70159_w = newmotion.x;
            entity.field_70181_x = newmotion.y;
            entity.field_70179_y = newmotion.z;
            this.updateServerPos();
        }
    }

    public void calctaut(double dist, grappleArrow arrow) {
        if (arrow != null) {
            if (dist < arrow.r) {
                double taut = 1.0 - (arrow.r - dist) / 5.0;
                if (taut < 0.0) {
                    taut = 0.0;
                }
                arrow.taut = taut;
            } else {
                arrow.taut = 1.0;
            }
        }
    }

    public void normalCollisions() {
        if (this.entity.field_70123_F) {
            if (this.entity.field_70159_w == 0.0) {
                this.motion.x = 0.0;
            }
            if (this.entity.field_70179_y == 0.0) {
                this.motion.z = 0.0;
            }
        }
        if (this.entity.field_70124_G) {
            if (this.entity.field_70122_E) {
                if (this.motion.y < 0.0) {
                    this.motion.y = 0.0;
                }
            } else if (this.motion.y > 0.0 && this.entity.field_70137_T == this.entity.field_70163_u) {
                this.motion.y = 0.0;
            }
        }
    }

    public void normalGround() {
        if (this.entity.field_70122_E) {
            this.ongroundtimer = this.maxongroundtimer;
            if (this.motion.y < 0.0) {
                this.motion.y = 0.0;
            }
        } else if (this.ongroundtimer > 0) {
            --this.ongroundtimer;
        }
        if (this.ongroundtimer > 0 && !grapplemod.proxy.isSneaking(this.entity)) {
            this.motion = vec.motionvec(this.entity);
        }
    }

    public double getJumpPower(Entity player, double jumppower) {
        double maxjump = 1.0;
        if (this.ongroundtimer > 0) {
            this.ongroundtimer = 20;
            return 0.0;
        }
        if (player.field_70122_E) {
            jumppower = 0.0;
        }
        if (player.field_70132_H) {
            jumppower = maxjump;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        return jumppower;
    }

    public void doJump(Entity player, double jumppower) {
        if (jumppower > 0.0) {
            player.field_70181_x = jumppower > player.field_70181_x + jumppower ? jumppower : (player.field_70181_x += jumppower);
        }
        this.unattach();
        this.updateServerPos();
    }

    public double getJumpPower(Entity player, vec spherevec, grappleArrow arrow) {
        double maxjump = 1.0;
        vec jump = new vec(0.0, maxjump, 0.0);
        if (spherevec != null) {
            jump = jump.proj(spherevec);
        }
        double jumppower = jump.y;
        if (spherevec != null && spherevec.y > 0.0) {
            jumppower = 0.0;
        }
        if (arrow != null && arrow.r < 1.0 && player.field_70163_u < arrow.field_70163_u) {
            jumppower = maxjump;
        }
        return this.getJumpPower(player, jumppower);
    }

    public vec dampenmotion(vec motion, vec forward) {
        vec newmotion = motion.proj(forward);
        double dampening = 0.05;
        return new vec(newmotion.x * dampening + motion.x * (1.0 - dampening), newmotion.y * dampening + motion.y * (1.0 - dampening), newmotion.z * dampening + motion.z * (1.0 - dampening));
    }

    public void updateServerPos() {
        grapplemod.network.sendToServer((IMessage)new PlayerMovementMessage(this.entityId, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y));
    }

    public void receiveGrappleClick(boolean leftclick) {
        if (!leftclick) {
            this.unattach();
        }
    }

    public void receiveEnderLaunch(double x, double y, double z) {
        this.motion.add_ip(x, y, z);
        this.entity.field_70159_w = this.motion.x;
        this.entity.field_70181_x = this.motion.y;
        this.entity.field_70179_y = this.motion.z;
    }

    public void applyAirFriction() {
        double dragforce = 0.005f;
        if (this.entity.func_70090_H()) {
            dragforce = 0.25;
        }
        double vel = this.motion.length();
        dragforce = vel * vel * dragforce;
        vec airfric = new vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changelen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void applyPlayerMovement() {
        this.motion.add_ip(this.playermovement.changelen(0.015 + this.motion.length() * 0.01).mult(this.playermovementmult));
    }

    public void addArrow(grappleArrow arrow) {
        this.arrows.add(arrow);
        arrow.r = arrow.segmenthandler.getDist(vec.positionvec((Entity)arrow), vec.positionvec(this.entity).add(new vec(0.0, this.entity.func_70047_e(), 0.0)));
        this.arrowIds.add(arrow.func_145782_y());
    }

    public vec check_repel(vec p, World w) {
        p = p.add(0.0, 0.75, 0.0);
        vec v = new vec(0.0, 0.0, 0.0);
        double t = (1.0 + Math.sqrt(5.0)) / 2.0;
        BlockPos pos = new BlockPos(Math.floor(p.x), Math.floor(p.y), Math.floor(p.z));
        if (this.hasblock(pos, w)) {
            v.add_ip(0.0, 1.0, 0.0);
        } else {
            v.add_ip(this.vecdist(p, new vec(-1.0, t, 0.0), w));
            v.add_ip(this.vecdist(p, new vec(1.0, t, 0.0), w));
            v.add_ip(this.vecdist(p, new vec(-1.0, -t, 0.0), w));
            v.add_ip(this.vecdist(p, new vec(1.0, -t, 0.0), w));
            v.add_ip(this.vecdist(p, new vec(0.0, -1.0, t), w));
            v.add_ip(this.vecdist(p, new vec(0.0, 1.0, t), w));
            v.add_ip(this.vecdist(p, new vec(0.0, -1.0, -t), w));
            v.add_ip(this.vecdist(p, new vec(0.0, 1.0, -t), w));
            v.add_ip(this.vecdist(p, new vec(t, 0.0, -1.0), w));
            v.add_ip(this.vecdist(p, new vec(t, 0.0, 1.0), w));
            v.add_ip(this.vecdist(p, new vec(-t, 0.0, -1.0), w));
            v.add_ip(this.vecdist(p, new vec(-t, 0.0, 1.0), w));
        }
        if (v.length() > this.repelmaxpush) {
            v.changelen_ip(this.repelmaxpush);
        }
        return v;
    }

    public vec vecdist(vec p, vec v, World w) {
        for (double i = 0.5; i < 10.0; i += 0.5) {
            vec v2 = v.changelen(i);
            BlockPos pos = new BlockPos(Math.floor(p.x + v2.x), Math.floor(p.y + v2.y), Math.floor(p.z + v2.z));
            if (!this.hasblock(pos, w)) continue;
            vec v3 = new vec((double)pos.func_177958_n() + 0.5 - p.x, (double)pos.func_177956_o() + 0.5 - p.y, (double)pos.func_177952_p() + 0.5 - p.z);
            v3.changelen_ip(-1.0 / Math.pow(v3.length(), 2.0));
            return v3;
        }
        return new vec(0.0, 0.0, 0.0);
    }

    public boolean hasblock(BlockPos pos, World w) {
        boolean isblock = false;
        IBlockState blockstate = w.func_180495_p(pos);
        Block b = blockstate.func_177230_c();
        if (!b.isAir(blockstate, (IBlockAccess)w, pos)) {
            isblock = true;
        }
        return isblock;
    }
}

