/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mcft.copy.backpacks.client.GuiTextureResource;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiImage;
import net.mcft.copy.backpacks.client.gui.GuiLabel;
import net.mcft.copy.backpacks.client.gui.GuiLayout;
import net.mcft.copy.backpacks.client.gui.config.IConfigEntry;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.client.gui.control.GuiButtonGlyph;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.Status;
import net.mcft.copy.backpacks.misc.util.LangUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseEntry
extends GuiLayout
implements IConfigEntry {
    public static final GuiTextureResource TEXTURE_CONFIG_ICONS = new GuiTextureResource("config_icons", 64, 64);
    public final GuiImage iconStatus;
    public final GuiLabel label;
    public final GuiButton buttonUndo;
    public final GuiButton buttonReset;

    public BaseEntry() {
        super(Direction.HORIZONTAL);
        this.setFillHorizontal();
        this.iconStatus = new GuiImage(16, 16, TEXTURE_CONFIG_ICONS);
        this.iconStatus.setCenteredVertical();
        this.label = new GuiLabel("");
        this.label.setCenteredVertical();
        this.label.setShadowDisabled();
        this.buttonUndo = new GuiButtonGlyph(18, 18, "\u21b6", 1.0f);
        this.buttonUndo.setCenteredVertical();
        this.buttonUndo.setAction(this::undoChanges);
        this.buttonReset = new GuiButtonGlyph(18, 18, "\u2604", 1.0f);
        this.buttonReset.setCenteredVertical();
        this.buttonReset.setAction(this::setToDefault);
    }

    public boolean hasLabel() {
        return this.label.getParent() == this;
    }

    public void setLabel(String languageKey) {
        this.label.setText(I18n.func_135052_a((String)languageKey, (Object[])new Object[0]));
    }

    public void setLabelAndTooltip(String languageKey) {
        this.setLabelAndTooltip(languageKey, null, null);
    }

    public void setLabelAndTooltip(String languageKey, String def, String warn) {
        languageKey = "config.wearablebackpacks." + languageKey;
        this.setLabel(languageKey);
        this.label.setTooltip(this.formatTooltip(languageKey, languageKey + ".tooltip", def, warn));
    }

    protected List<String> formatTooltip(String title, String text, String def, String warn) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(TOOLTIP_TITLE + I18n.func_135052_a((String)title, (Object[])new Object[0]));
        if (text != null) {
            LangUtils.format(tooltip, text, new Object[0]);
            if (text.equals(tooltip.get(1))) {
                tooltip.remove(1);
            } else {
                tooltip.set(1, TOOLTIP_TEXT + (String)tooltip.get(1));
            }
        }
        if (def != null) {
            tooltip.add(TOOLTIP_DEFAULT + I18n.func_135052_a((String)"fml.configgui.tooltip.default", (Object[])new Object[]{def}));
        }
        if (warn != null) {
            tooltip.add(TOOLTIP_WARN + "[" + I18n.func_135052_a((String)warn, (Object[])new Object[0]) + "]");
        }
        return tooltip;
    }

    public abstract List<Status> getStatus();

    @Override
    public final boolean isValid() {
        return Status.getSeverity(this.getStatus()) != Status.Severity.ERROR;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        List<Status> status = this.getStatus();
        Status.Severity severity = Status.getSeverity(status);
        List<String> tooltip = Status.getMessage(status);
        boolean isFine = severity == Status.Severity.FINE;
        BaseEntry.enableBlendAlphaStuffs();
        BaseEntry.drawColoredRectARGB(16, -1, this.getWidth() - 12, this.getHeight() + 2, severity.backgroundColor);
        BaseEntry.disableBlendAlphaStuffs();
        this.iconStatus.setTextureUV(severity.guiIconIndex * 16, 0);
        this.iconStatus.setTooltip(tooltip);
        if (this.hasLabel()) {
            String text = this.label.getText();
            if (text.startsWith(TextFormatting.ITALIC.toString())) {
                text = text.substring(2);
            }
            if (this.isChanged()) {
                text = TextFormatting.ITALIC + text;
            }
            this.label.setText(text);
            this.label.setColor(!this.isEnabled() ? GuiUtils.getColorCode((char)'8', (boolean)true) : (isFine ? GuiUtils.getColorCode((char)'7', (boolean)true) : severity.foregroundColor));
        }
        this.buttonUndo.setEnabled(this.isChanged());
        this.buttonReset.setEnabled(!this.isDefault());
        super.draw(mouseX, mouseY, partialTicks);
    }

    public static class Value<T>
    extends BaseEntry {
        protected IConfigValue<T> control;
        public final Optional<T> defaultValue;
        public final Optional<T> previousValue;

        public Value(IConfigValue<T> control, T defaultValue, T currentValue) {
            this(control, Optional.ofNullable(defaultValue), Optional.ofNullable(currentValue));
        }

        public Value(IConfigValue<T> control, Optional<T> defaultValue, Optional<T> currentValue) {
            if (control == null) {
                throw new NullPointerException("control must not be null");
            }
            this.control = control;
            this.defaultValue = defaultValue;
            this.previousValue = currentValue;
            this.setSpacing(4, 8, 6, 4);
            this.addFixed(this.iconStatus);
            this.addFixed(this.label);
            this.addWeighted((GuiElementBase)((Object)control));
            if (this.previousValue.isPresent()) {
                this.addFixed(this.buttonUndo);
            }
            if (defaultValue.isPresent()) {
                this.addFixed(this.buttonReset);
            }
            currentValue.ifPresent(this::setValue);
        }

        public Optional<T> getValue() {
            return this.control.getValue();
        }

        public void setValue(T value) {
            this.control.setValue(value);
        }

        @Override
        public List<Status> getStatus() {
            ArrayList<Status> status = new ArrayList<Status>();
            if (!this.getValue().isPresent()) {
                status.add(Status.INVALID);
            }
            return status;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks) {
            if (this.control instanceof IConfigValue.ShowsStatus) {
                ((IConfigValue.ShowsStatus)((Object)this.control)).setStatus(this.getStatus());
            }
            super.draw(mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean isChanged() {
            return !this.previousValue.equals(this.getValue());
        }

        @Override
        public boolean isDefault() {
            return this.defaultValue.equals(this.getValue());
        }

        @Override
        public void undoChanges() {
            this.previousValue.ifPresent(this::setValue);
        }

        @Override
        public void setToDefault() {
            this.defaultValue.ifPresent(this::setValue);
        }

        @Override
        public Setting.ChangeRequiredAction applyChanges() {
            return Setting.ChangeRequiredAction.None;
        }
    }
}

