/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.aireducer.handler;

import com.charles445.aireducer.AIReducer;
import com.charles445.aireducer.ai.AIAvoidReducedRabbit;
import com.charles445.aireducer.ai.WrappedTask;
import com.charles445.aireducer.ai.myrmex.PathNavigateMyrmexAlternate;
import com.charles445.aireducer.ai.myrmex.ReflectMyrmex;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAIEscortEntity;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAIFindHidingSpot;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAIForage;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAILeaveHive;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAIMoveThroughHive;
import com.charles445.aireducer.ai.myrmex.WrappedTaskMyrmexAIReEnterHive;
import com.charles445.aireducer.compat.iceandfire.VillagerAIFearUntamedReduced;
import com.charles445.aireducer.config.ModConfig;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpawnHandler {
    public boolean loaded_iceandfire = Loader.isModLoaded((String)"iceandfire");
    public boolean loaded_minecraft = true;
    public boolean can_apply_tickrate;
    public Field f_EntityLiving_navigator;
    public Field f_tickRate;
    public Class c_rabbit_AIAvoidEntity;
    public Class c_iceandfire_VillagerAIFearUntamed;
    public Class c_iceandfire_IAnimalFear;
    public Method m_iceandfire_shouldAnimalsFear;
    public Class c_iceandfire_IVillagerFear;
    public Class c_iceandfire_DragonUtils;
    public Method m_iceandfire_isLivestock;
    public Method m_iceandfire_isVillager;
    public Class c_iceandfire_MyrmexAIForage;
    public Class c_iceandfire_MyrmexAIFindHidingSpot;
    public Class c_iceandfire_MyrmexAILeaveHive;
    public Class c_iceandfire_MyrmexAIMoveThroughHive;
    public Class c_iceandfire_MyrmexAIReEnterHive;
    public Class c_iceandfire_MyrmexAIEscortEntity;
    public Map<Class, Constructor> wrappedConstructorMap = new HashMap<Class, Constructor>();

    public SpawnHandler() {
        try {
            try {
                this.f_tickRate = EntityAITasks.class.getDeclaredField("field_75779_e");
            }
            catch (Exception e) {
                this.f_tickRate = EntityAITasks.class.getDeclaredField("tickRate");
            }
            this.f_tickRate.setAccessible(true);
            try {
                this.f_EntityLiving_navigator = EntityLiving.class.getDeclaredField("field_70699_by");
            }
            catch (Exception e) {
                this.f_EntityLiving_navigator = EntityLiving.class.getDeclaredField("navigator");
            }
            this.f_EntityLiving_navigator.setAccessible(true);
        }
        catch (Exception e) {
            AIReducer.logger.error("Failed to setup tickrate tweaking in SpawnHandler!", (Throwable)e);
            this.f_tickRate = null;
        }
        try {
            this.c_rabbit_AIAvoidEntity = Class.forName("net.minecraft.entity.passive.EntityRabbit$AIAvoidEntity");
        }
        catch (Exception e) {
            AIReducer.logger.error("Failed to setup vanilla reflection in SpawnHandler!", (Throwable)e);
            this.loaded_minecraft = false;
        }
        if (this.loaded_iceandfire) {
            try {
                this.c_iceandfire_VillagerAIFearUntamed = Class.forName("com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed");
                this.c_iceandfire_IAnimalFear = Class.forName("com.github.alexthe666.iceandfire.entity.IAnimalFear");
                this.m_iceandfire_shouldAnimalsFear = this.c_iceandfire_IAnimalFear.getDeclaredMethod("shouldAnimalsFear", Entity.class);
                this.c_iceandfire_IVillagerFear = Class.forName("com.github.alexthe666.iceandfire.entity.IVillagerFear");
                this.c_iceandfire_DragonUtils = Class.forName("com.github.alexthe666.iceandfire.entity.DragonUtils");
                this.m_iceandfire_isLivestock = this.c_iceandfire_DragonUtils.getDeclaredMethod("isLivestock", Entity.class);
                this.m_iceandfire_isVillager = this.c_iceandfire_DragonUtils.getDeclaredMethod("isVillager", Entity.class);
                this.c_iceandfire_MyrmexAIForage = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAIForage");
                this.c_iceandfire_MyrmexAIFindHidingSpot = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFindHidingSpot");
                this.c_iceandfire_MyrmexAILeaveHive = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive");
                this.c_iceandfire_MyrmexAIMoveThroughHive = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive");
                this.c_iceandfire_MyrmexAIReEnterHive = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive");
                this.c_iceandfire_MyrmexAIEscortEntity = Class.forName("com.github.alexthe666.iceandfire.entity.ai.MyrmexAIEscortEntity");
                new ReflectMyrmex();
            }
            catch (Exception e) {
                AIReducer.logger.error("Failed to setup iceandfire reflection in SpawnHandler!", (Throwable)e);
                this.loaded_iceandfire = false;
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!ModConfig.enabled) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity rawEntity = event.getEntity();
        if (rawEntity instanceof EntityLiving) {
            EntityLiving entity = (EntityLiving)rawEntity;
            ResourceLocation id = EntityList.func_191306_a(entity.getClass());
            if (id == null) {
                return;
            }
            String domain = id.func_110624_b();
            String path = id.func_110623_a();
            if (this.loaded_iceandfire) {
                try {
                    if (ModConfig.iceandfire.replaceVillageAIFearUntamed) {
                        if (((Boolean)this.m_iceandfire_isLivestock.invoke(null, entity)).booleanValue()) {
                            this.tryReplaceIceAndFireLivestockFearTask(entity);
                        } else if (((Boolean)this.m_iceandfire_isVillager.invoke(null, entity)).booleanValue()) {
                            this.tryReplaceIceAndFireVillagerFearTask(entity);
                        }
                    }
                }
                catch (Exception e) {
                    AIReducer.debugError("Failed to check isLivestock!", e);
                }
            }
            if (this.loaded_minecraft && domain.equals("minecraft")) {
                this.handleVanilla(entity, path);
            } else if (this.loaded_iceandfire && domain.equals("iceandfire")) {
                this.handleIceAndFire(entity, path);
            }
        }
    }

    private void handleIceAndFire(EntityLiving entity, String path) {
        switch (path) {
            case "deathworm": {
                this.handleDeathWorm(entity);
                break;
            }
            case "myrmex_worker": 
            case "myrmex_soldier": 
            case "myrmex_sentinel": 
            case "myrmex_royal": 
            case "myrmex_queen": {
                this.handleMyrmex(entity, path);
                break;
            }
        }
    }

    private void handleDeathWorm(EntityLiving entity) {
        if (!ModConfig.iceandfire.deathworm) {
            return;
        }
        AIReducer.debugDebug("Applying deathworm delay: " + ModConfig.iceandfire.deathworm_ai_delay);
        this.applyTickRate(entity.field_70714_bg, ModConfig.iceandfire.deathworm_ai_delay);
        this.applyTickRate(entity.field_70715_bh, ModConfig.iceandfire.deathworm_ai_delay);
    }

    private void handleMyrmex(EntityLiving entity, String path) {
        if (!ModConfig.iceandfire.myrmex) {
            return;
        }
        if (ModConfig.iceandfire.myrmexAlternateNavigation && !path.equals("myrmex_royal") && !path.equals("myrmex_queen")) {
            AIReducer.debugDebug("Swapping out myrmex navigator");
            this.setNavigator(entity, (PathNavigate)new PathNavigateMyrmexAlternate(entity, entity.func_130014_f_()));
        }
        entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.iceandfire.myrmexFollowRange);
        AIReducer.debugDebug("Applying myrmex delay: " + ModConfig.iceandfire.myrmex_ai_delay);
        this.applyTickRate(entity.field_70714_bg, ModConfig.iceandfire.myrmex_ai_delay);
        this.applyTickRate(entity.field_70715_bh, ModConfig.iceandfire.myrmex_ai_delay);
        AIReducer.debugDebug("Current Tasks Count: " + entity.field_70714_bg.field_75782_a.size());
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAIEscortEntity, WrappedTaskMyrmexAIEscortEntity.class);
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAIForage, WrappedTaskMyrmexAIForage.class);
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAIFindHidingSpot, WrappedTaskMyrmexAIFindHidingSpot.class);
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAILeaveHive, WrappedTaskMyrmexAILeaveHive.class);
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAIMoveThroughHive, WrappedTaskMyrmexAIMoveThroughHive.class);
        this.wrapTask(entity, entity.field_70714_bg, this.c_iceandfire_MyrmexAIReEnterHive, WrappedTaskMyrmexAIReEnterHive.class);
        AIReducer.debugDebug("Final Tasks Count: " + entity.field_70714_bg.field_75782_a.size());
    }

    private boolean removeAllTasksOfClass(EntityLiving entity, Class classToRemove) {
        boolean found = false;
        Iterator iterator = entity.field_70714_bg.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (task.field_75733_a.getClass() != classToRemove) continue;
            AIReducer.debugDebug("Removing " + classToRemove.getName() + " from " + entity.getClass().getName());
            found = true;
            iterator.remove();
        }
        return found;
    }

    private void tryAndReplaceAllTasks(EntityLiving entity, EntityAITasks tasks, Class toMatch, Function<EntityAITasks.EntityAITaskEntry, EntityAIBase> action) {
        int count = 0;
        LinkedList<EntityAITasks.EntityAITaskEntry> entries = new LinkedList<EntityAITasks.EntityAITaskEntry>();
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            if (toMatch.isInstance(entry.field_75733_a)) {
                EntityAITasks entityAITasks = tasks;
                entityAITasks.getClass();
                entries.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, entry.field_75731_b, (EntityAIBase)action.apply((Object)entry)));
                ++count;
                continue;
            }
            entries.add(entry);
        }
        if (count > 0) {
            AIReducer.debugDebug("Replacing " + count + " tasks of " + toMatch.getName());
            tasks.field_75782_a.clear();
            tasks.field_75782_a.addAll(entries);
        }
    }

    private void wrapTask(EntityLiving entity, EntityAITasks tasks, Class clazz, Class<? extends WrappedTask> wrapperClazz) {
        this.tryAndReplaceAllTasks(entity, tasks, clazz, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)oldTaskEntry -> {
            try {
                Constructor construct = this.wrappedConstructorMap.get(wrapperClazz);
                if (construct == null) {
                    AIReducer.logger.info("Caching Wrapped Task Constructor: " + wrapperClazz.getName());
                    construct = wrapperClazz.getDeclaredConstructor(EntityLiving.class, EntityAIBase.class);
                    this.wrappedConstructorMap.put(wrapperClazz, construct);
                }
                WrappedTask wrapper = (WrappedTask)((Object)((Object)construct.newInstance(entity, oldTaskEntry.field_75733_a)));
                AIReducer.debugDebug("Wrapped task with priority " + oldTaskEntry.field_75731_b + ": " + oldTaskEntry.field_75733_a.getClass().getName() + " " + ((Object)((Object)wrapper)).getClass().getName());
                return wrapper;
            }
            catch (Exception e) {
                AIReducer.logger.error("Failed to reflect to requested WrappedTask constructor!", (Throwable)e);
                return oldTaskEntry.field_75733_a;
            }
        }));
    }

    private void handleVanilla(EntityLiving entity, String path) {
        if (entity instanceof EntityCreature) {
            switch (path) {
                case "rabbit": {
                    this.handleVanillaRabbit((EntityCreature)entity);
                    break;
                }
            }
        }
    }

    private void handleVanillaRabbit(EntityCreature entity) {
        if (!ModConfig.vanilla.rabbit) {
            return;
        }
        EntityRabbit entityRabbit = (EntityRabbit)entity;
        this.applyTickRate(entityRabbit.field_70714_bg, ModConfig.vanilla.rabbit_ai_delay);
        if (this.removeAllTasksOfClass((EntityLiving)entityRabbit, this.c_rabbit_AIAvoidEntity)) {
            entityRabbit.field_70714_bg.func_75776_a(4, new AIAvoidReducedRabbit<EntityPlayer>(entityRabbit, EntityPlayer.class, 8.0f, 2.2, 2.2));
            entityRabbit.field_70714_bg.func_75776_a(4, new AIAvoidReducedRabbit<EntityWolf>(entityRabbit, EntityWolf.class, 10.0f, 2.2, 2.2));
            entityRabbit.field_70714_bg.func_75776_a(4, new AIAvoidReducedRabbit<EntityMob>(entityRabbit, EntityMob.class, 4.0f, 2.2, 2.2));
        }
    }

    private void tryReplaceIceAndFireVillagerFearTask(EntityLiving entity) {
        if (entity instanceof EntityCreature) {
            this.tryAndReplaceAllTasks(entity, entity.field_70714_bg, this.c_iceandfire_VillagerAIFearUntamed, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)task -> this.makeIceAndFireVillagerFearTask((EntityCreature)entity)));
        }
    }

    private EntityAIBase makeIceAndFireVillagerFearTask(EntityCreature entity) {
        return new VillagerAIFearUntamedReduced<EntityLivingBase>(entity, EntityLivingBase.class, new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase targentity) {
                return targentity != null && SpawnHandler.this.c_iceandfire_IVillagerFear.isInstance(targentity);
            }
        }, 12.0f, 0.8, 0.8);
    }

    private void tryReplaceIceAndFireLivestockFearTask(EntityLiving entity) {
        if (entity instanceof EntityCreature) {
            this.tryAndReplaceAllTasks(entity, entity.field_70714_bg, this.c_iceandfire_VillagerAIFearUntamed, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)task -> this.makeIceAndFireLivestockFearTask((EntityCreature)entity)));
        }
    }

    private EntityAIBase makeIceAndFireLivestockFearTask(final EntityCreature entity) {
        return new VillagerAIFearUntamedReduced<EntityLivingBase>(entity, EntityLivingBase.class, new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase targentity) {
                try {
                    return targentity != null && SpawnHandler.this.c_iceandfire_IAnimalFear.isInstance(targentity) && (Boolean)SpawnHandler.this.m_iceandfire_shouldAnimalsFear.invoke((Object)targentity, entity) != false;
                }
                catch (Exception e) {
                    AIReducer.debugError("Failed to makeIceAndFireLivestockFearTask!", e);
                    return false;
                }
            }
        }, 12.0f, 1.2, 1.5);
    }

    private void setNavigator(EntityLiving entity, PathNavigate navigator) {
        try {
            this.f_EntityLiving_navigator.set(entity, navigator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyTickRate(EntityAITasks tasks, int tickRate) {
        try {
            this.f_tickRate.setInt(tasks, tickRate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

