/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.bidirectional;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class DeleteMarkerPacket
extends AbstractMessage<DeleteMarkerPacket> {
    private static final int GLOBAL = -1;
    private int atlasID;
    private int markerID;

    public DeleteMarkerPacket() {
    }

    public DeleteMarkerPacket(int atlasID, int markerID) {
        this.atlasID = atlasID;
        this.markerID = markerID;
    }

    public DeleteMarkerPacket(int markerID) {
        this(-1, markerID);
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.markerID = buffer.func_150792_a();
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.markerID);
    }

    private boolean isGlobal() {
        return this.atlasID == -1;
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (side.isServer()) {
            if (side.isServer() && SettingsConfig.gameplay.itemNeeded && !player.field_71071_by.func_70431_c(new ItemStack((Item)RegistrarAntiqueAtlas.ATLAS, 1, this.atlasID))) {
                Log.warn("Player %s attempted to delete marker from someone else's Atlas #%d", player.func_146103_bH().getName(), this.atlasID);
                return;
            }
            if (this.isGlobal()) {
                AtlasAPI.markers.deleteGlobalMarker(player.func_130014_f_(), this.markerID);
            } else {
                AtlasAPI.markers.deleteMarker(player.func_130014_f_(), this.atlasID, this.markerID);
            }
        } else {
            GlobalMarkersData data = this.isGlobal() ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.func_130014_f_());
            data.removeMarker(this.markerID);
        }
    }
}

