/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.registry;

import hunternif.mc.atlas.registry.MarkerRegistryImpl;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.SaveData;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class MarkerRegistry
extends SaveData {
    public static final MarkerRegistry INSTANCE = new MarkerRegistry();
    private static final ResourceLocation DEFAULT_LOC = new ResourceLocation("antiqueatlas:red_x_small");
    private final MarkerRegistryImpl<MarkerType> registry = new MarkerRegistryImpl(DEFAULT_LOC);

    private MarkerRegistry() {
    }

    public static void register(ResourceLocation location, MarkerType type) {
        type.setRegistryName(location);
        MarkerRegistry.register(type);
    }

    public static void register(MarkerType type) {
        MarkerRegistry.INSTANCE.registry.register(type);
        INSTANCE.markDirty();
    }

    public static ResourceLocation getLoc(String type) {
        if (!type.contains(":")) {
            type = "antiqueatlas:" + type;
        }
        return new ResourceLocation(type);
    }

    public static MarkerType find(String type) {
        return MarkerRegistry.find(MarkerRegistry.getLoc(type));
    }

    public static MarkerType find(ResourceLocation type) {
        return MarkerRegistry.INSTANCE.registry.getObject(type);
    }

    public static boolean hasKey(String type) {
        return MarkerRegistry.hasKey(MarkerRegistry.getLoc(type));
    }

    public static boolean hasKey(ResourceLocation loc) {
        return MarkerRegistry.INSTANCE.registry.containsKey(loc);
    }

    public static List<MarkerType> getValues() {
        return MarkerRegistry.INSTANCE.registry.getValues();
    }

    public static Set<ResourceLocation> getKeys() {
        return MarkerRegistry.INSTANCE.registry.func_148742_b();
    }
}

