/*
 * Decompiled with CFR 0.152.
 */
package ljfa.tntutils.handlers;

import ljfa.tntutils.Config;
import ljfa.tntutils.asm.HooksExplosion;
import ljfa.tntutils.util.ListHelper;
import ljfa.tntutils.util.Predicate;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExplosionHandler {
    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (Config.disableExplosions) {
            event.setCanceled(true);
        } else {
            event.getExplosion().field_77280_f *= Config.sizeMultiplier;
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        final World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (Config.disableBlockDamage || Config.disableCreeperBlockDamage && event.getExplosion().field_77283_e instanceof EntityCreeper) {
            event.getAffectedBlocks().clear();
        } else {
            if (Config.spareTileEntities || Config.blacklistActive) {
                ListHelper.removeIf(event.getAffectedBlocks(), new Predicate<BlockPos>(){

                    @Override
                    public boolean test(BlockPos pos) {
                        return ExplosionHandler.shouldBePreserved(world.func_180495_p(pos));
                    }
                });
            }
            if (Config.preventChainExpl) {
                for (BlockPos pos : event.getAffectedBlocks()) {
                    IBlockState state = world.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof BlockTNT)) continue;
                    state.func_177230_c().func_180653_a(world, pos, state, HooksExplosion.getDropChance(event.getExplosion()), 0);
                    world.func_175698_g(pos);
                }
            }
        }
        if (Config.disableEntityDamage) {
            event.getAffectedEntities().clear();
        } else if (Config.disablePlayerDamage || Config.disableItemDamage || Config.disableNPCDamage || Config.preventChainExpl) {
            ListHelper.removeIf(event.getAffectedEntities(), new Predicate<Entity>(){

                @Override
                public boolean test(Entity ent) {
                    return Config.disableNPCDamage && ent instanceof EntityLivingBase && !(ent instanceof EntityPlayer) || Config.disablePlayerDamage && ent instanceof EntityPlayer || Config.disableItemDamage && ent instanceof EntityItem || Config.preventChainExpl && ent instanceof EntityMinecartTNT;
                }
            });
        }
    }

    public static boolean shouldBePreserved(IBlockState state) {
        boolean matches;
        if (Config.spareTileEntities && state.func_177230_c().hasTileEntity(state)) {
            return true;
        }
        Integer mask = Config.blackWhiteList.get(state.func_177230_c());
        boolean bl = matches = mask != null && (mask & 1 << state.func_177230_c().func_176201_c(state)) != 0;
        return Config.listIsWhitelist ? !matches : matches;
    }
}

