/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills;

import levelup2.api.IPlayerSkill;
import net.minecraft.util.ResourceLocation;

public abstract class BaseSkill
implements IPlayerSkill {
    private int[] skillLevels = new int[0];
    private String[] prereqs = new String[0];
    private int column = 0;
    private int row = 0;
    private boolean enabled = true;
    private boolean active = true;

    @Override
    public void setLevelCosts(int[] levelCosts) {
        this.skillLevels = levelCosts;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return this.skillLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public void setPrerequisites(String[] prerequisites) {
        this.prereqs = prerequisites;
    }

    @Override
    public String[] getPrerequisites() {
        return this.prereqs;
    }

    @Override
    public void setSkillColumn(int column) {
        this.column = column;
    }

    @Override
    public int getSkillColumn() {
        return this.column;
    }

    @Override
    public void setSkillRow(int row) {
        this.row = row;
    }

    @Override
    public int getSkillRow() {
        return this.row;
    }

    @Override
    public int getMaxLevel() {
        return this.skillLevels.length;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isMaxLevel(int level) {
        return level == this.getMaxLevel();
    }

    @Override
    public String getJsonLocation() {
        String category = this.getSkillType() == 0 ? "mining" : (this.getSkillType() == 1 ? "crafting" : "combat");
        ResourceLocation location = new ResourceLocation(this.getSkillName());
        return category + "/" + location.func_110623_a();
    }

    @Override
    public boolean hasExternalJson() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean isActive) {
        this.active = isActive;
    }
}

