/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import levelup2.api.IPlayerSkill;
import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.items.ItemOreChunk;
import levelup2.items.ItemRespecBook;
import levelup2.network.SkillPacketHandler;
import levelup2.player.IPlayerClass;
import levelup2.skills.combat.ArrowSpeedBonus;
import levelup2.skills.combat.DrawSpeedBonus;
import levelup2.skills.combat.NaturalArmorBonus;
import levelup2.skills.combat.ShieldBlockBonus;
import levelup2.skills.combat.StealthBonus;
import levelup2.skills.combat.StealthDamage;
import levelup2.skills.combat.StealthSpeed;
import levelup2.skills.combat.SwordCritBonus;
import levelup2.skills.combat.SwordDamageBonus;
import levelup2.skills.combat.XPBonusCombat;
import levelup2.skills.crafting.BrewingEfficiencyBonus;
import levelup2.skills.crafting.FishingLootBonus;
import levelup2.skills.crafting.FoodGrowthBonus;
import levelup2.skills.crafting.FoodHarvestBonus;
import levelup2.skills.crafting.FurnaceEfficiencyBonus;
import levelup2.skills.crafting.FurnaceSmeltBonus;
import levelup2.skills.crafting.XPBonusCrafting;
import levelup2.skills.mining.DiggingTreasureBonus;
import levelup2.skills.mining.FallDamageBonus;
import levelup2.skills.mining.FlintLootBonus;
import levelup2.skills.mining.SprintSpeedBonus;
import levelup2.skills.mining.StoneMiningBonus;
import levelup2.skills.mining.StoneSpeedBonus;
import levelup2.skills.mining.WoodSpeedBonus;
import levelup2.skills.mining.WoodcuttingBonus;
import levelup2.skills.mining.XPBonusMining;
import levelup2.util.Library;
import levelup2.util.PlankCache;
import levelup2.util.SkillProperties;
import levelup2.util.SmeltingBlacklist;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkillRegistry {
    private static Map<String, Integer> oreBonusXP = new HashMap<String, Integer>();
    private static List<IPlayerSkill> skillRegistry = new ArrayList<IPlayerSkill>();
    private static Map<String, IPlayerSkill> skillHashMap = new HashMap<String, IPlayerSkill>();
    private static Map<String, SkillProperties> skillProperties = new HashMap<String, SkillProperties>();
    private static List<IPlantable> cropBlacklist = new ArrayList<IPlantable>();
    public static int smallestDisplayColumn = 0;
    public static int smallestDisplayRow = 0;
    public static int largestDisplayColumn = 0;
    public static int largestDisplayRow = 0;
    public static Item surfaceOreChunk = (Item)new ItemOreChunk(LevelUpConfig.oreList).func_77655_b("levelup:surfaceore").setRegistryName(new ResourceLocation("levelup2", "surfaceore"));
    public static Item netherOreChunk = (Item)new ItemOreChunk(LevelUpConfig.netherOreList).func_77655_b("levelup:netherore").setRegistryName(new ResourceLocation("levelup2", "netherore"));
    public static Item endOreChunk = (Item)new ItemOreChunk(LevelUpConfig.endOreList).func_77655_b("levelup:endore").setRegistryName(new ResourceLocation("levelup2", "endore"));
    public static Item respecBook = (Item)new ItemRespecBook().func_77655_b("levelup:respec").setRegistryName(new ResourceLocation("levelup2", "respecbook"));

    public static void loadSkills() {
        SkillRegistry.addSkill(new XPBonusCombat());
        SkillRegistry.addSkill(new XPBonusCrafting());
        SkillRegistry.addSkill(new XPBonusMining());
        SkillRegistry.addSkill(new StoneSpeedBonus());
        SkillRegistry.addSkill(new StoneMiningBonus());
        SkillRegistry.addSkill(new WoodSpeedBonus());
        SkillRegistry.addSkill(new WoodcuttingBonus());
        SkillRegistry.addSkill(new FlintLootBonus());
        SkillRegistry.addSkill(new DiggingTreasureBonus());
        SkillRegistry.addSkill(new SwordCritBonus());
        SkillRegistry.addSkill(new SwordDamageBonus());
        SkillRegistry.addSkill(new DrawSpeedBonus());
        SkillRegistry.addSkill(new ArrowSpeedBonus());
        SkillRegistry.addSkill(new StealthBonus());
        SkillRegistry.addSkill(new StealthDamage());
        SkillRegistry.addSkill(new ShieldBlockBonus());
        SkillRegistry.addSkill(new NaturalArmorBonus());
        SkillRegistry.addSkill(new FoodGrowthBonus());
        SkillRegistry.addSkill(new FoodHarvestBonus());
        SkillRegistry.addSkill(new SprintSpeedBonus());
        SkillRegistry.addSkill(new FallDamageBonus());
        SkillRegistry.addSkill(new StealthSpeed());
        SkillRegistry.addSkill(new FurnaceEfficiencyBonus());
        SkillRegistry.addSkill(new FurnaceSmeltBonus());
        SkillRegistry.addSkill(new BrewingEfficiencyBonus());
        SkillRegistry.addSkill(new FishingLootBonus());
        SkillRegistry.addCropsToBlacklist(LevelUpConfig.cropBlacklist);
        Library.registerLootManager();
    }

    public static void postLoadSkills() {
        for (IPlayerSkill skill : skillRegistry) {
            if (!skill.hasSubscription()) continue;
            MinecraftForge.EVENT_BUS.register((Object)skill);
        }
    }

    public static void registerRecipes() {
        if (!SkillRegistry.isNullList(LevelUpConfig.oreList)) {
            Library.registerOreToChunk(LevelUpConfig.oreList, surfaceOreChunk);
            Library.addToOreList(LevelUpConfig.oreList);
            Library.assignExperienceValues(LevelUpConfig.oreList, LevelUpConfig.oreExperience);
            SkillRegistry.registerSmelting(LevelUpConfig.oreList, surfaceOreChunk);
            if (LevelUpConfig.oreList.contains("oreRedstone")) {
                Library.getOreList().add(Blocks.field_150439_ay);
            }
        }
        if (!SkillRegistry.isNullList(LevelUpConfig.netherOreList)) {
            Library.registerOreToChunk(LevelUpConfig.netherOreList, netherOreChunk);
            Library.addToOreList(LevelUpConfig.netherOreList);
            Library.assignExperienceValues(LevelUpConfig.netherOreList, LevelUpConfig.netherOreExperience);
            SkillRegistry.registerSmelting(LevelUpConfig.netherOreList, netherOreChunk);
        }
        if (!SkillRegistry.isNullList(LevelUpConfig.endOreList)) {
            Library.registerOreToChunk(LevelUpConfig.endOreList, endOreChunk);
            Library.addToOreList(LevelUpConfig.endOreList);
            Library.assignExperienceValues(LevelUpConfig.endOreList, LevelUpConfig.endOreExperience);
            SkillRegistry.registerSmelting(LevelUpConfig.endOreList, endOreChunk);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (LevelUpConfig.dupeAllOres) {
            for (String name : OreDictionary.getOreNames()) {
                if (name.startsWith("ore")) {
                    names.add(name);
                }
                if (Library.getOreList().contains(Blocks.field_150439_ay)) continue;
                Library.getOreList().add(Blocks.field_150439_ay);
            }
        } else {
            names.addAll(LevelUpConfig.oreList);
            names.addAll(LevelUpConfig.netherOreList);
            names.addAll(LevelUpConfig.endOreList);
        }
        Library.registerOres(names);
    }

    private static void registerSmelting(List<String> ores, Item item) {
        for (int i = 0; i < ores.size(); ++i) {
            ItemStack ore;
            String names = ores.get(i);
            if (!OreDictionary.doesOreNameExist((String)names) || (ore = SkillRegistry.getOreEntry(names)).func_190926_b() || FurnaceRecipes.func_77602_a().func_151395_a(ore).func_190926_b()) continue;
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(ore);
            GameRegistry.addSmelting((ItemStack)new ItemStack(item, 1, i), (ItemStack)result, (float)FurnaceRecipes.func_77602_a().func_151398_b(result));
        }
        SmeltingBlacklist.addItem(new ItemStack(Blocks.field_150360_v, 1, 1));
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.startsWith("dust")) continue;
            SmeltingBlacklist.addOres(ore);
        }
    }

    private static void registerCrafting(List<String> ores, Item item) {
        for (int i = 0; i < ores.size(); ++i) {
            ItemStack ore;
            String names = ores.get(i);
            if (!OreDictionary.doesOreNameExist((String)names) || (ore = SkillRegistry.getOreEntry(names)).func_190926_b()) continue;
            ItemStack chunk = new ItemStack(item, 1, i);
            SkillRegistry.registerShapelessRecipe(ore.func_77946_l(), chunk, chunk);
            OreDictionary.registerOre((String)names, (ItemStack)chunk);
        }
    }

    private static void registerShapelessRecipe(ItemStack output, Object ... inputs) {
        GameRegistry.findRegistry(IRecipe.class).register((IForgeRegistryEntry)new ShapelessOreRecipe(new ResourceLocation("levelup", "orechunk"), output, inputs));
    }

    public static boolean isNullList(List<String> list) {
        return !list.isEmpty() && list.get(0).equals("null");
    }

    public static List<IPlayerSkill> getSkillRegistry() {
        return skillRegistry;
    }

    public static IPlayerSkill getSkillFromName(String name) {
        if (skillHashMap.containsKey(name)) {
            return skillHashMap.get(name);
        }
        return null;
    }

    public static void addSkill(IPlayerSkill skill) {
        skillRegistry.add(skill);
        skillHashMap.put(skill.getSkillName(), skill);
    }

    public static int getSkillLevel(EntityPlayer player, String skill) {
        return SkillRegistry.getPlayer(player).getSkillLevel(skill);
    }

    public static IPlayerClass getPlayer(EntityPlayer player) {
        return (IPlayerClass)player.getCapability(PlayerCapability.PLAYER_CLASS, null);
    }

    public static void addStackToOreBonus(String stack, int bonusXP) {
        oreBonusXP.put(stack, bonusXP);
    }

    public static Map<String, Integer> getOreBonusXP() {
        return oreBonusXP;
    }

    public static void addExperience(EntityPlayer player, int amount) {
        player.func_71023_q(amount);
    }

    public static boolean stackMatches(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean listContains(ItemStack stack, List<ItemStack> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (ItemStack lStack : list) {
            if (!SkillRegistry.stackMatches(stack, lStack)) continue;
            return true;
        }
        return false;
    }

    public static void increaseSkillLevel(EntityPlayer player, String skillName) {
        IPlayerSkill skill = SkillRegistry.getPlayer(player).getSkillFromName(skillName);
        int skillCost = skill.getLevelCost(SkillRegistry.getPlayer(player).getSkillLevel(skillName));
        if (skillCost > 0 && player.field_71068_ca >= skillCost) {
            player.field_71068_ca -= skillCost;
            SkillRegistry.getPlayer(player).addToSkill(skillName, 1);
        }
    }

    public static void loadPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            byte spec = SkillRegistry.getPlayer(player).getSpecialization();
            Map<String, Integer> skills = SkillRegistry.getPlayer(player).getSkills();
            SkillPacketHandler.initChannel.sendTo(SkillPacketHandler.getPacket(Side.CLIENT, 0, spec, skills), (EntityPlayerMP)player);
        }
    }

    public static void addCropsToBlacklist(List<String> blacklist) {
        for (String str : blacklist) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(str));
            if (block == null || !(block instanceof IPlantable)) continue;
            cropBlacklist.add((IPlantable)block);
        }
    }

    public static List<IPlantable> getCropBlacklist() {
        return cropBlacklist;
    }

    public static ItemStack getOreEntry(String ore) {
        if (OreDictionary.doesOreNameExist((String)ore) && !OreDictionary.getOres((String)ore).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                if (!(stack.func_77973_b() instanceof ItemBlock) || stack.func_77942_o()) continue;
                return new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void initPlankCache() {
        PlankCache.refresh();
        for (ItemStack log : OreDictionary.getOres((String)"logWood")) {
            if (!(log.func_77973_b() instanceof ItemBlock)) continue;
            if (log.func_77960_j() == Short.MAX_VALUE) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack logTest = new ItemStack(log.func_77973_b(), 1, i);
                    ItemStack plank = SkillRegistry.getPlankOutput(logTest);
                    if (plank.func_190926_b()) continue;
                    SkillRegistry.registerLog(logTest, plank);
                }
                continue;
            }
            ItemStack plank = SkillRegistry.getPlankOutput(log);
            if (plank.func_190926_b()) continue;
            SkillRegistry.registerLog(log, plank);
        }
    }

    private static void registerLog(ItemStack log, ItemStack plank) {
        Block block = ((ItemBlock)log.func_77973_b()).func_179223_d();
        ItemStack plankCopy = plank.func_77946_l();
        plankCopy.func_190920_e(plank.func_190916_E() / 2);
        PlankCache.addBlock(block, log.func_77960_j(), plankCopy);
    }

    private static ItemStack getPlankOutput(ItemStack log) {
        Iterator it = CraftingManager.field_193380_a.iterator();
        ItemStack stack = ItemStack.field_190927_a;
        while (it.hasNext() && stack.func_190926_b()) {
            IRecipe recipe = (IRecipe)it.next();
            if (!recipe.func_193358_e().equals("planks")) continue;
            NonNullList ing = recipe.func_192400_c();
            if (!SkillRegistry.isPlank(recipe.func_77571_b())) continue;
            for (Ingredient in : ing) {
                for (ItemStack check : in.func_193365_a()) {
                    if (!check.func_77969_a(log)) continue;
                    stack = recipe.func_77571_b().func_77946_l();
                }
            }
        }
        return stack;
    }

    private static boolean isPlank(ItemStack output) {
        for (ItemStack plank : OreDictionary.getOres((String)"plankWood")) {
            if (plank.func_77960_j() == Short.MAX_VALUE) {
                return output.func_77973_b() == plank.func_77973_b();
            }
            if (!plank.func_77969_a(output)) continue;
            return true;
        }
        return false;
    }

    public static void registerSkillProperties() {
        for (IPlayerSkill skill : SkillRegistry.getSkillRegistry()) {
            SkillProperties prop = SkillRegistry.loadFromJson(skill);
            if (prop == null) continue;
            skillProperties.put(skill.getSkillName(), prop);
        }
        SkillRegistry.calculateHighLow();
    }

    private static SkillProperties loadFromJson(IPlayerSkill skill) {
        SkillProperties prop = null;
        Path dir = LevelUpConfig.jsonDir.resolve("skills");
        Path location = dir.resolve(skill.getJsonLocation() + ".json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            BufferedReader reader = Files.newBufferedReader(location);
            prop = SkillProperties.fromJson(skill.getSkillName(), (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static SkillProperties getProperty(IPlayerSkill skill) {
        return skillProperties.get(skill.getSkillName());
    }

    public static void calculateHighLow() {
        largestDisplayRow = 0;
        largestDisplayColumn = 0;
        smallestDisplayRow = 0;
        smallestDisplayColumn = 0;
        for (IPlayerSkill skill : SkillRegistry.getSkillRegistry()) {
            IPlayerSkill sk = SkillRegistry.getSkillFromName(skill.getSkillName());
            int column = sk.getSkillColumn();
            int row = sk.getSkillRow();
            if (column > largestDisplayColumn) {
                largestDisplayColumn = column;
            } else if (column < smallestDisplayColumn) {
                smallestDisplayColumn = column;
            }
            if (row > largestDisplayRow) {
                largestDisplayRow = row;
                continue;
            }
            if (row >= smallestDisplayRow) continue;
            smallestDisplayRow = row;
        }
    }
}

