/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcjty.lostcities.api.ILostChunkGenerator;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostsouls.LostSouls;
import mcjty.lostsouls.config.Config;
import mcjty.lostsouls.data.LostChunkData;
import mcjty.lostsouls.data.LostSoulData;
import mcjty.lostsouls.varia.ChunkCoord;
import mcjty.lostsouls.varia.Tools;
import net.minecraft.command.CommandSenderWrapper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    public static int timeout = Config.SERVERTICK_TIMEOUT;
    private Map<UUID, ChunkCoord> playerChunks = new HashMap<UUID, ChunkCoord>();

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ILostChunkGenerator generator;
        World world = event.getWorld();
        if (Config.LOCK_CHESTS_UNTIL_CLEARED && !world.field_72995_K && (generator = LostSouls.lostCities.getLostGenerator(world.field_73011_w.getDimension())) != null) {
            BlockPos pos = event.getPos();
            TileEntity te = world.func_175625_s(pos);
            if (Config.LOCK_ONLY_CHESTS && te instanceof TileEntityChest || !Config.LOCK_ONLY_CHESTS && te != null) {
                ILostChunkInfo chunkInfo;
                String buildingType;
                int chunkX = pos.func_177958_n() >> 4;
                int chunkZ = pos.func_177952_p() >> 4;
                LostChunkData data = LostSoulData.getSoulData(world, world.field_73011_w.getDimension(), chunkX, chunkZ, generator);
                if (this.isHaunted(data, buildingType = (chunkInfo = generator.getChunkInfo(chunkX, chunkZ)).getBuildingType())) {
                    event.setCanceled(true);
                    if (Config.ANNOUNCE_CHESTLOCKED) {
                        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + Config.MESSAGE_UNSAFE_BUILDING));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ServerTickEvent event) {
        if (--timeout > 0) {
            return;
        }
        timeout = Config.SERVERTICK_TIMEOUT;
        PlayerList list = DimensionManager.getWorld((int)0).func_73046_m().func_184103_al();
        for (EntityPlayerMP player : list.func_181057_v()) {
            ILostChunkGenerator generator;
            UUID uuid = player.func_110124_au();
            BlockPos position = player.func_180425_c();
            int chunkX = position.func_177958_n() >> 4;
            int chunkZ = position.func_177952_p() >> 4;
            ChunkCoord chunkCoord = new ChunkCoord(player.func_130014_f_().field_73011_w.getDimension(), chunkX, chunkZ);
            boolean entered = false;
            if (!this.playerChunks.containsKey(uuid)) {
                this.playerChunks.put(uuid, chunkCoord);
                entered = true;
            } else {
                ChunkCoord oldPos = this.playerChunks.get(uuid);
                if (!oldPos.equals(chunkCoord)) {
                    this.playerChunks.put(uuid, chunkCoord);
                    entered = true;
                }
            }
            if ((generator = LostSouls.lostCities.getLostGenerator(player.func_130014_f_().field_73011_w.getDimension())) == null) continue;
            this.handleSpawn(player, generator, entered);
        }
    }

    private boolean isHaunted(LostChunkData data, String buildingType) {
        if (buildingType == null) {
            return false;
        }
        if (Config.getExcludedBuildings().contains(buildingType)) {
            return false;
        }
        return data.isHaunted() && data.getNumberKilled() < data.getTotalMobs();
    }

    private void handleSpawn(EntityPlayerMP player, ILostChunkGenerator lost, boolean entered) {
        World world;
        LostChunkData data;
        int chunkZ;
        BlockPos position = player.func_180425_c();
        int chunkX = position.func_177958_n() >> 4;
        ILostChunkInfo chunkInfo = lost.getChunkInfo(chunkX, chunkZ = position.func_177952_p() >> 4);
        String buildingType = chunkInfo.getBuildingType();
        if (buildingType != null && this.isHaunted(data = LostSoulData.getSoulData(world = player.func_130014_f_(), world.field_73011_w.getDimension(), chunkX, chunkZ, lost), buildingType)) {
            if (entered) {
                data.enterBuilding();
                LostSoulData.getData(world).save(world);
                int enteredCount = data.getEnteredCount();
                if (enteredCount == 1 && Config.ANNOUNCE_ENTER) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + Config.MESSAGE_BUILDING_HAUNTED));
                }
                if (enteredCount == 1) {
                    this.executeCommands(player, world, Config.COMMAND_FIRSTTIME);
                }
                if (enteredCount >= 1) {
                    this.executeCommands(player, world, Config.COMMAND_ENTERED);
                }
            }
            int realHeight = lost.getRealHeight(chunkInfo.getCityLevel());
            int miny = realHeight - (chunkInfo.getNumCellars() + 1) * 6;
            int maxy = realHeight + (chunkInfo.getNumFloors() + 1) * 6;
            if (position.func_177956_o() >= miny && position.func_177956_o() <= maxy) {
                String mob;
                Entity entity;
                int cnt;
                double distance;
                double z;
                double y;
                double x = (double)(chunkX * 16) + world.field_73012_v.nextDouble() * 16.0;
                if (world.func_175623_d(new BlockPos(x, (y = (double)(position.func_177956_o() + world.field_73012_v.nextInt(3) - 1)) - 1.0, z = (double)(chunkZ * 16) + world.field_73012_v.nextDouble() * 16.0))) {
                    y -= 1.0;
                }
                if (!world.func_175623_d(new BlockPos(x, y, z))) {
                    y += 1.0;
                }
                if (world.func_175623_d(new BlockPos(x, y, z)) && (distance = position.func_185332_f((int)x, (int)y, (int)z)) >= (double)Config.MIN_SPAWN_DISTANCE && (cnt = world.func_72872_a((entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(mob = Tools.getRandomFromList(world.field_73012_v, Config.getRandomMobs())), (World)world)).getClass(), new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(8.0)).size()) <= Config.SPAWN_MAX_NEARBY) {
                    entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if ((!Config.CHECK_VALID_SPAWN || ((EntityLiving)entity).func_70601_bi()) && ((EntityLiving)entity).func_70058_J()) {
                        this.boostEntity(world, (EntityLiving)entity);
                        entity.func_184211_a("_ls_:" + world.field_73011_w.getDimension() + ":" + chunkX + ":" + chunkZ);
                        world.func_72838_d(entity);
                    }
                }
            }
        }
    }

    private void executeCommands(EntityPlayerMP player, World world, String[] commands) {
        if (commands.length > 0) {
            CommandSenderWrapper sender = new CommandSenderWrapper((ICommandSender)player, player.func_174791_d(), player.func_180425_c(), 4, (Entity)player, null){

                public boolean func_70003_b(int permLevel, String commandName) {
                    return true;
                }
            };
            MinecraftServer server = world.func_73046_m();
            for (String cmd : commands) {
                server.field_71321_q.func_71556_a((ICommandSender)sender, cmd);
            }
        }
    }

    private void boostEntity(World world, EntityLiving entity) {
        Item item;
        String boots;
        Item item2;
        String leggings;
        Item item3;
        String chestplate;
        Item item4;
        String helmet;
        Item item5;
        double newMax;
        float f;
        IAttributeInstance entityAttribute = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (entityAttribute != null) {
            f = world.field_73012_v.nextFloat() * (Config.MAX_HEALTH_BONUS - Config.MIN_HEALTH_BONUS) + Config.MIN_HEALTH_BONUS;
            newMax = entityAttribute.func_111125_b() * (double)f;
            entityAttribute.func_111128_a(newMax);
            entity.func_70606_j((float)newMax);
        }
        if ((entityAttribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null) {
            f = world.field_73012_v.nextFloat() * (Config.MAX_DAMAGE_BONUS - Config.MIN_DAMAGE_BONUS) + Config.MIN_DAMAGE_BONUS;
            newMax = entityAttribute.func_111125_b() * (double)f;
            entityAttribute.func_111128_a(newMax);
        }
        for (Pair<Float, String> pair : Config.getRandomEffects()) {
            if (!(world.field_73012_v.nextFloat() < ((Float)pair.getLeft()).floatValue())) continue;
            String s = (String)pair.getRight();
            String[] split = StringUtils.split((String)s, (char)',');
            Potion value = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(split[0]));
            if (value == null) {
                throw new RuntimeException("Cannot find potion effect '" + split[0] + "'!");
            }
            int amplitude = Integer.parseInt(split[1]);
            entity.func_70690_d(new PotionEffect(value, 10000, amplitude));
        }
        String weapon = Tools.getRandomFromList(world.field_73012_v, Config.getRandomWeapons());
        if (!"null".equals(weapon) && (item5 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weapon))) != null) {
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(item5));
        }
        if (!"null".equals(helmet = Tools.getRandomFromList(world.field_73012_v, Config.getRandomHelmets())) && (item4 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(helmet))) != null) {
            entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(item4));
        }
        if (!"null".equals(chestplate = Tools.getRandomFromList(world.field_73012_v, Config.getRandomChests())) && (item3 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(chestplate))) != null) {
            entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(item3));
        }
        if (!"null".equals(leggings = Tools.getRandomFromList(world.field_73012_v, Config.getRandomLeggings())) && (item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(leggings))) != null) {
            entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(item2));
        }
        if (!"null".equals(boots = Tools.getRandomFromList(world.field_73012_v, Config.getRandomBoots())) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(boots))) != null) {
            entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(item));
        }
    }

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (source instanceof EntityPlayerMP) {
            for (String tag : event.getEntity().func_184216_O()) {
                if (!tag.startsWith("_ls_:")) continue;
                String[] split = StringUtils.split((String)tag, (char)':');
                try {
                    int dim = Integer.parseInt(split[1]);
                    int x = Integer.parseInt(split[2]);
                    int z = Integer.parseInt(split[3]);
                    LostChunkData data = LostSoulData.getSoulData(event.getEntity().field_70170_p, dim, x, z, null);
                    data.newKill();
                    if (Config.ANNOUNCE_CLEARED) {
                        if (data.getNumberKilled() == data.getTotalMobs()) {
                            source.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + Config.MESSAGE_BUILDING_CLEARED));
                            this.executeCommands((EntityPlayerMP)source, source.func_130014_f_(), Config.COMMAND_CLEARED);
                        } else if (data.getNumberKilled() == data.getTotalMobs() / 2) {
                            source.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + Config.MESSAGE_BUILDING_HALFWAY));
                        }
                    }
                    LostSoulData.getData(event.getEntity().field_70170_p).save(event.getEntity().field_70170_p);
                }
                catch (NumberFormatException e) {
                    System.out.println("ForgeEventHandlers.onKill ERROR");
                }
                return;
            }
        }
    }
}

