/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.nodeeditor.GuiNodeEditor;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiDropDownList {
    public static final int HEIGHT = 16;
    public static final int LIST_HEIGHT = 90;
    public static final int ELEMENT_HEIGHT = 11;
    public static final int SCROLLBAR_WIDTH = 5;
    public GuiNodeEditor nodeEditor;
    private int x;
    private int y;
    private int width = 94;
    private List<Entry> entries = new ArrayList<Entry>();
    private int selectedId = 0;
    private boolean valueChangeUnhandled = false;
    private int entryAmount = 0;
    private boolean noValueAllowed = true;
    private final FontRenderer fontRenderer;
    private boolean enabled = true;
    private boolean hovered = false;
    private boolean listHovered = false;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private boolean dropped = false;
    private int hoveredEntryId = -1;
    private float scrollAmount;
    private int scrollBarY;
    private int scrollBarHeight;
    private int scrollBarGrabY;

    public GuiDropDownList(GuiNodeEditor nodeEditor) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.scrollAmount = 0.0f;
        this.nodeEditor = nodeEditor;
    }

    public GuiDropDownList init() {
        this.entries = new ArrayList<Entry>();
        this.selectedId = 0;
        this.scrollAmount = 0.0f;
        this.enabled = true;
        return this;
    }

    public GuiDropDownList setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public GuiDropDownList addEntry(String displayName) {
        this.entries.add(new Entry(this.entries.size(), displayName, this.entries.size()));
        this.updateDimensions();
        return this;
    }

    public GuiDropDownList addEntry(String displayName, Object value) {
        this.entries.add(new Entry(this.entries.size(), displayName, value));
        this.updateDimensions();
        return this;
    }

    public GuiDropDownList setEntryAmount(int entryAmount) {
        this.entryAmount = entryAmount;
        this.updateDimensions();
        return this;
    }

    public void update(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        this.hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + 16;
        this.listHovered = false;
        this.hoveredEntryId = -1;
        this.scrollBarHovered = false;
        if (this.scrollBarGrabbed) {
            this.scroll((float)(mouseY - this.y - 16 - this.scrollBarY - this.scrollBarGrabY) / 11.0f);
        } else if (mouseX >= this.x && mouseX <= this.x + this.getWidth() && mouseY >= this.y + 16 && mouseY <= this.y + this.getVisualHeight()) {
            if (mouseX >= this.x + this.getWidth() - 5 - 1) {
                if (mouseY >= this.y + 16 + this.scrollBarY && mouseY <= this.y + 16 + this.scrollBarY + this.scrollBarHeight) {
                    this.scrollBarHovered = true;
                }
            } else {
                this.hoveredEntryId = this.getScrollInEntries() + (mouseY - this.y - 16) / 11;
            }
            this.listHovered = true;
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.scrollBarGrabbed = false;
        if (this.hovered) {
            this.dropped = !this.dropped;
        } else if (this.dropped) {
            if (mouseX >= this.x + this.getWidth() - 5 - 1) {
                this.scrollBarGrabbed = true;
                this.scrollBarGrabY = this.scrollBarHovered ? mouseY - this.y - 16 - this.scrollBarY : this.scrollBarHeight / 2;
            } else {
                if (this.hoveredEntryId >= 0 && this.hoveredEntryId < this.entries.size() + (this.noValueAllowed ? 1 : 0) && this.hoveredEntryId != this.selectedId) {
                    this.selectedId = this.hoveredEntryId;
                    this.nodeEditor.onChange();
                    this.valueChangeUnhandled = true;
                }
                this.dropped = false;
            }
            return true;
        }
        return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.getVisualHeight();
    }

    public void onMouseReleased(int mouseX, int mouseY, int event) {
        if (!this.isEnabled()) {
            return;
        }
        this.scrollBarGrabbed = false;
    }

    public boolean handleMouseInput() {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.dropped && this.listHovered) {
            int i2 = Mouse.getEventDWheel();
            if (i2 != 0) {
                if (i2 > 0) {
                    i2 = -1;
                } else if (i2 < 0) {
                    i2 = 1;
                }
                this.scroll((float)((double)i2 * 0.5));
            }
            return true;
        }
        if (this.hovered) {
            int i2 = Mouse.getEventDWheel();
            if (i2 != 0) {
                if (i2 > 0) {
                    i2 = -1;
                } else if (i2 < 0) {
                    i2 = 1;
                }
                this.selectedId = (int)GUtil.clamp(this.selectedId + i2, 0.0f, this.entries.size() + (this.noValueAllowed ? 0 : -1));
                this.valueChangeUnhandled = true;
            }
            return true;
        }
        this.hoveredEntryId = -1;
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiDropDownList enable() {
        this.enabled = true;
        return this;
    }

    public GuiDropDownList disable() {
        this.enabled = false;
        return this;
    }

    public void display() {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.rectangle(this.x, this.y, this.width, 16, -6250336);
        Draw.rectangle(this.x + 1, this.y + 1, this.width - 2, 16 - 2, this.hovered || this.dropped ? -14540254 : -16777216);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean noValue = this.noValueAllowed && this.selectedId == 0;
        String text = noValue ? "None" : this.fontRenderer.func_78269_a(this.getSelectedEntry().getDisplayName(), this.getWidth() - 20);
        this.fontRenderer.func_175063_a(text, (float)(this.x + 5), (float)(this.y + 4), noValue ? 0x999999 : 0xE2E2E2);
        Draw.rectangle_xgradient((float)(this.x + this.width - 40), (float)(this.y + 1), 27.0f, 14.0f, 0, this.hovered || this.dropped ? -14540254 : -16777216);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.texturedModalRect(this.x + this.width - 12, this.y + 3, 94, 24 + (this.hovered || this.dropped ? 10 : 0), 10, 10);
        if (this.dropped) {
            int elements = this.getNumberOfElements();
            Draw.rectangle(this.x, this.y + 16, this.width, elements * 11 + 3, -7829368);
            Draw.rectangle(this.x + 1, this.y + 16, this.width - 2, elements * 11 + 2, -16777216);
            for (int i = 0; i < elements; ++i) {
                int entryID = this.getScrollInEntries() + i - (this.noValueAllowed ? 1 : 0);
                boolean bl = noValue = this.noValueAllowed && i == 0;
                if (this.hoveredEntryId == this.getScrollInEntries() + i) {
                    Draw.rectangle(this.x + 1, this.y + 16 + i * 11, this.width - 2, 11, -14535873);
                } else if (this.selectedId == this.getScrollInEntries() + i) {
                    Draw.rectangle(this.x + 1, this.y + 16 + i * 11, this.width - 2, 11, -15395547);
                }
                String name = noValue ? "None" : this.fontRenderer.func_78269_a(this.entries.get(entryID).getDisplayName(), this.getWidth());
                this.fontRenderer.func_175063_a(name, (float)(this.x + 3), (float)(this.y + 16 + i * 11 + 2), noValue ? 0x999999 : 0xE2E2E2);
            }
            if (this.showScrollBar()) {
                Draw.rectangle(this.x + this.width - 5 - 1, this.y + 16, 5, elements * 11 + 2, -14540254);
                Draw.rectangle(this.x + this.width - 5 - 1, this.y + 16 + this.scrollBarY, 5, this.scrollBarHeight, this.scrollBarHovered ? -10066330 : -12303292);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getVisualHeight() {
        return this.dropped ? 16 + this.getNumberOfElements() * 11 + 3 : 16;
    }

    public Entry getSelectedEntry() {
        if (this.selectedId < 0 || this.selectedId >= this.entries.size() + (this.noValueAllowed ? 1 : 0)) {
            return null;
        }
        if (this.noValueAllowed && this.selectedId == 0) {
            return null;
        }
        return this.entries.get(this.selectedId - (this.noValueAllowed ? 1 : 0));
    }

    public int getNumberOfElements() {
        int elements = this.entries.size() + (this.noValueAllowed ? 1 : 0);
        if (this.entryAmount > 0) {
            elements = Math.min(elements, this.entryAmount);
        }
        return elements;
    }

    public GuiDropDownList allowNoValue() {
        this.noValueAllowed = true;
        return this;
    }

    public GuiDropDownList forbidNoValue() {
        this.noValueAllowed = false;
        return this;
    }

    public boolean showScrollBar() {
        return this.entries.size() > this.getNumberOfElements();
    }

    public float getScrollPercentage() {
        return this.scrollAmount / (float)(this.entries.size() - this.getNumberOfElements());
    }

    public int getScrollInEntries() {
        return (int)Math.max(0.0f, this.scrollAmount);
    }

    public void scroll(float amount) {
        this.scrollAmount = GUtil.clamp(this.scrollAmount + amount, 0.0f, this.entries.size() - this.getNumberOfElements());
        this.scrollBarY = (int)(this.getScrollPercentage() * (float)(this.getNumberOfElements() * 11 + 2 - this.scrollBarHeight));
    }

    public void selectValue(Object value) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).value.equals(value)) continue;
            this.selectedId = i + (this.noValueAllowed ? 1 : 0);
            return;
        }
        this.selectedId = 0;
    }

    public Object getSelectedValue() {
        if (this.getSelectedEntry() == null) {
            return null;
        }
        return this.getSelectedEntry().getValue();
    }

    public void updateDimensions() {
        this.scrollBarHeight = (int)((float)this.getNumberOfElements() / (float)this.entries.size() * (float)(this.getNumberOfElements() * 11 + 2));
        this.scrollBarY = (int)(this.getScrollPercentage() * (float)(this.getNumberOfElements() * 11 + 2 - this.scrollBarHeight));
    }

    public void setChangesHandled() {
        this.valueChangeUnhandled = false;
    }

    public boolean areChangedUnhandled() {
        return this.valueChangeUnhandled;
    }

    public class Entry {
        private String displayName;
        private Object value;
        private int ordinal;

        public Entry(int ordinal) {
            this.displayName = "";
            this.value = ordinal;
            this.ordinal = ordinal;
        }

        public Entry(int ordinal, String displayName, Object value) {
            this.displayName = displayName;
            this.value = value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

