/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.nodeeditor;

import java.util.HashMap;
import java.util.function.BiConsumer;
import net.gobbob.mobends.client.gui.GuiBendsMenu;
import net.gobbob.mobends.client.gui.elements.GuiCompactTextField;
import net.gobbob.mobends.client.gui.elements.GuiCustomButton;
import net.gobbob.mobends.client.gui.elements.GuiDropDownList;
import net.gobbob.mobends.client.gui.elements.GuiRadio;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationNode;
import net.gobbob.mobends.client.gui.nodeeditor.GuiAnimationSection;
import net.gobbob.mobends.client.gui.nodeeditor.GuiCalculation;
import net.gobbob.mobends.client.gui.nodeeditor.GuiNodeEditor;
import net.gobbob.mobends.pack.BendsAction;
import net.gobbob.mobends.pack.variable.BendsVariable;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.EnumAxis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiParameterEditor {
    public GuiNodeEditor nodeEditor;
    public GuiAnimationSection selectedSection;
    public GuiAnimationNode selectedNode;
    public GuiCalculation selectedCalculation;
    public int x;
    public int y;
    public int width;
    public int height;
    public EnumChanged changedState;
    private String title;
    private FontRenderer fontRenderer;
    public GuiCompactTextField textField;
    public GuiRadio radioField;
    public GuiRadio radioField2;
    public GuiCustomButton removeButton;
    public GuiDropDownList dropDownList;
    public GuiDropDownList modifierList;
    private HashMap partMap;

    public GuiParameterEditor(GuiNodeEditor nodeEditor) {
        this.nodeEditor = nodeEditor;
        this.x = 0;
        this.y = 0;
        this.width = 100;
        this.height = 130;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.textField = new GuiCompactTextField(0, Minecraft.func_71410_x().field_71466_p, this.x + 4, this.y + 14, this.width - 8, 14);
        this.radioField = new GuiRadio(nodeEditor);
        this.radioField2 = new GuiRadio(nodeEditor);
        this.radioField2.setButton(0, 76, 10, 12).setElement(36, 64, 6, 8).setNumberOfElements(4).setOffset(2, 2).setPadding(0, 4).setBackground(42, 48, 46, 16);
        this.removeButton = new GuiCustomButton(60, 20);
        this.dropDownList = new GuiDropDownList(nodeEditor).setEntryAmount(5);
        this.modifierList = new GuiDropDownList(nodeEditor);
        for (int i = 0; i < BendsAction.EnumModifier.values().length; ++i) {
            this.modifierList.addEntry(BendsAction.EnumModifier.values()[i].getDisplayName());
        }
        this.title = "";
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
        this.radioField.initGui(x + 3, y + 30);
        this.radioField2.initGui(x + 46, y + 30);
        this.textField.setPosition(x + 4, y + 14);
        this.removeButton.setPosition(x + 4, y + this.height - 24);
        this.modifierList.setPosition(x + 3, y + 50);
        if (this.changedState != null) {
            switch (this.changedState) {
                case CALCULATION: {
                    this.dropDownList.setPosition(x + 3, y + 50);
                    break;
                }
                case CONDITION: {
                    break;
                }
                case NODE: {
                    this.dropDownList.setPosition(x + 3, y + 13);
                    break;
                }
            }
        }
    }

    public void display(int mouseX, int mouseY, float partialTicks) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBendsMenu.ICONS_TEXTURE);
        Draw.texturedModalRect(this.x, this.y - 4, this.width, 4, 64, 82, 1, 4);
        Draw.texturedModalRect(this.x + this.width, this.y - 4, 4, 4, 65, 82, 4, 4);
        Draw.texturedModalRect(this.x + this.width, this.y, 4, this.height, 65, 86, 4, 1);
        Draw.texturedModalRect(this.x + this.width, this.y + this.height, 4, 4, 65, 87, 4, 4);
        Draw.texturedModalRect(this.x, this.y + this.height, this.width, 4, 64, 87, 1, 4);
        Draw.texturedModalRect(this.x, this.y, this.width, this.height, 64, 86, 1, 1);
        if (this.changedState != null) {
            this.removeButton.drawButton(mouseX, mouseY, partialTicks);
            this.fontRenderer.func_175063_a(this.title, (float)(this.x + (this.width - this.fontRenderer.func_78256_a(this.title)) / 2), (float)(this.y + 3), 0xFFFFFF);
        }
        this.textField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.radioField.display();
        this.radioField2.display();
        this.modifierList.display();
        this.dropDownList.display();
    }

    public void select(GuiAnimationSection section) {
        this.selectedSection = section;
        this.selectedNode = null;
        this.selectedCalculation = null;
        this.changedState = EnumChanged.CONDITION;
        this.title = I18n.func_135052_a((String)"mobends.gui.condition", (Object[])new Object[0]);
        this.textField.func_146189_e(true);
        this.textField.setPlaceholderText("Animation");
        this.textField.func_146180_a(String.valueOf(section.getAnimationName()));
        this.radioField.disable();
        this.radioField2.disable();
        this.removeButton.setText("Remove");
        this.removeButton.field_146120_f = this.width - 8;
        this.dropDownList.disable();
        this.modifierList.disable();
    }

    public void select(GuiAnimationNode node) {
        this.selectedSection = null;
        this.selectedNode = node;
        this.selectedCalculation = null;
        this.changedState = EnumChanged.NODE;
        this.title = I18n.func_135052_a((String)"mobends.gui.node", (Object[])new Object[0]);
        this.textField.func_146189_e(false);
        this.radioField.enable();
        this.radioField.setButton(0, 64, 12, 12).setElement(81, 0, 10, 10).setNumberOfElements(3).setOffset(2, 2).setPadding(0, 3).setBackground(0, 48, 42, 16);
        this.radioField2.enable();
        this.radioField.choose(node.getProperty().ordinal());
        this.radioField2.choose(node.getAxis() == null ? 0 : node.getAxis().ordinal() + 1);
        this.removeButton.setText("Remove");
        this.removeButton.field_146120_f = this.width - 8;
        this.dropDownList.init().setEntryAmount(5).forbidNoValue();
        this.dropDownList.setPosition(this.x + 3, this.y + 13);
        if (this.nodeEditor.getAlterableParts() != null) {
            for (String part : this.nodeEditor.getAlterableParts()) {
                this.dropDownList.addEntry(part, part);
            }
        }
        this.dropDownList.selectValue(this.selectedNode.getModel());
        this.modifierList.enable();
        this.modifierList.selectValue(node.getModifier() == null ? null : Integer.valueOf(node.getModifier().ordinal()));
    }

    public void select(GuiCalculation calculation) {
        this.selectedSection = null;
        this.selectedNode = null;
        this.selectedCalculation = calculation;
        calculation.setSelected(true);
        this.changedState = EnumChanged.CALCULATION;
        this.title = I18n.func_135052_a((String)"mobends.gui.calculation", (Object[])new Object[0]);
        this.textField.func_146189_e(true);
        this.textField.setPlaceholderText("Box");
        this.textField.func_146180_a(String.valueOf(calculation.getValue()));
        this.radioField.enable();
        this.radioField.setButton(51, 0, 10, 10).setElement(21, 6, 6, 6).setNumberOfElements(5).setOffset(2, 2).setPadding(0, 4).setBackground(51, 10, 57, 14);
        this.radioField2.disable();
        this.radioField.choose(calculation.operator.ordinal());
        this.removeButton.setText("Remove");
        this.removeButton.field_146120_f = this.width - 8;
        this.dropDownList.init().setEntryAmount(5).allowNoValue();
        this.dropDownList.setPosition(this.x + 3, this.y + 50);
        BendsVariable.variables.forEach(new BiConsumer(){

            public void accept(Object key, Object value) {
                GuiParameterEditor.this.dropDownList.addEntry(((BendsVariable)value).getDisplayName(), key);
            }
        });
        this.dropDownList.selectValue(this.selectedCalculation.globalVar);
        this.modifierList.disable();
        this.textField.func_146184_c(this.selectedCalculation.getGlobalVariable() == null);
    }

    public void deselect() {
        if (this.changedState != null) {
            switch (this.changedState) {
                case CALCULATION: {
                    this.selectedCalculation.setSelected(false);
                    break;
                }
                case CONDITION: {
                    this.selectedSection.setSelected(false);
                    break;
                }
                case NODE: {
                    this.selectedNode.setSelected(false);
                    break;
                }
            }
        }
        this.selectedSection = null;
        this.selectedNode = null;
        this.selectedCalculation = null;
        this.changedState = null;
    }

    public boolean isEnabled() {
        return this.changedState != null;
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.textField.func_146206_l()) {
            this.textField.func_146201_a(typedChar, keyCode);
            if (this.changedState != null) {
                this.nodeEditor.onChange();
                switch (this.changedState) {
                    case CALCULATION: {
                        try {
                            this.selectedCalculation.setValue(Float.parseFloat(this.textField.func_146179_b()));
                        }
                        catch (NumberFormatException e) {
                            this.selectedCalculation.setValue(0.0f);
                        }
                        this.selectedCalculation.getParentNode().updateAddNodeX();
                        break;
                    }
                    case CONDITION: {
                        this.selectedSection.setAnimationName(this.textField.func_146179_b());
                        break;
                    }
                    case NODE: {
                        this.selectedNode.setModel(this.textField.func_146179_b());
                        break;
                    }
                }
            }
        }
    }

    public void update(int mouseX, int mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        this.textField.func_146178_a();
        this.radioField.update(mouseX, mouseY);
        this.radioField2.update(mouseX, mouseY);
        this.dropDownList.update(mouseX, mouseY);
        this.modifierList.update(mouseX, mouseY);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.dropDownList.mouseClicked(mouseX, mouseY, event)) {
            this.updateDropListChoice();
        } else if (this.modifierList.mouseClicked(mouseX, mouseY, event)) {
            this.selectedNode.setModifier(this.modifierList.getSelectedValue() == null ? null : BendsAction.EnumModifier.values()[(Integer)this.modifierList.getSelectedValue()]);
        } else {
            this.textField.func_146192_a(mouseX, mouseY, event);
            if (this.radioField.onMousePressed(mouseX, mouseY, event)) {
                this.updateRadioChoice();
            }
            if (this.radioField2.onMousePressed(mouseX, mouseY, event)) {
                this.updateAxisChoice();
            }
            if (this.changedState != null && this.removeButton.mousePressed(mouseX, mouseY)) {
                this.removeSelected();
            }
        }
        return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
    }

    public void mouseReleased(int mouseX, int mouseY, int event) {
        this.dropDownList.onMouseReleased(mouseX, mouseY, event);
    }

    public boolean handleMouseInput() {
        if (this.dropDownList.handleMouseInput()) {
            this.updateDropListChoice();
            return true;
        }
        if (this.modifierList.handleMouseInput()) {
            this.selectedNode.setModifier(this.modifierList.getSelectedValue() == null ? null : BendsAction.EnumModifier.values()[(Integer)this.modifierList.getSelectedValue()]);
            return true;
        }
        return false;
    }

    public void updateDropListChoice() {
        if (this.changedState != null) {
            switch (this.changedState) {
                case CALCULATION: {
                    this.selectedCalculation.setGlobalVariable((String)this.dropDownList.getSelectedValue());
                    this.textField.func_146184_c(this.selectedCalculation.getGlobalVariable() == null);
                    this.selectedCalculation.getParentNode().updateAddNodeX();
                    break;
                }
                case NODE: {
                    this.selectedNode.setModel((String)this.dropDownList.getSelectedValue());
                    break;
                }
            }
        }
    }

    public void updateRadioChoice() {
        if (this.changedState != null) {
            switch (this.changedState) {
                case CALCULATION: {
                    this.selectedCalculation.operator = BendsAction.EnumOperator.values()[this.radioField.selectedId];
                    break;
                }
                case NODE: {
                    this.selectedNode.setProperty(BendsAction.EnumBoxProperty.values()[this.radioField.selectedId]);
                    break;
                }
            }
        }
    }

    public void updateAxisChoice() {
        if (this.changedState == EnumChanged.NODE) {
            this.selectedNode.setAxis(this.radioField2.selectedId == 0 ? null : EnumAxis.values()[this.radioField2.selectedId - 1]);
        }
    }

    public void removeSelected() {
        if (this.changedState == null) {
            return;
        }
        switch (this.changedState) {
            case CONDITION: {
                this.selectedSection.remove();
                break;
            }
            case NODE: {
                this.selectedNode.remove();
                break;
            }
            case CALCULATION: {
                this.selectedCalculation.remove();
                break;
            }
        }
        this.deselect();
    }

    public static enum EnumChanged {
        CONDITION,
        NODE,
        CALCULATION;

    }
}

