/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.data;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.gobbob.mobends.data.EntityData;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class EntityDatabase {
    public HashMap entries;
    protected final String name;
    protected final Class dataClass;

    public EntityDatabase(Class dataClassIn) {
        this.name = null;
        this.dataClass = dataClassIn;
        this.entries = new HashMap();
    }

    public EntityData getEntry(int identifier) {
        if (this.entries.containsKey(identifier)) {
            return (EntityData)this.entries.get(identifier);
        }
        return null;
    }

    public EntityData newEntry(int identifier) {
        EntityData data = null;
        try {
            data = (EntityData)this.dataClass.getConstructor(Integer.TYPE).newInstance(identifier);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (data != null) {
            this.entries.put(identifier, data);
        }
        return data;
    }

    public void addEntry(int identifier, EntityData data) {
        this.entries.put(identifier, data);
    }

    public void removeEntry(int identifier) {
        this.entries.remove(identifier);
    }

    public String getName() {
        return this.name;
    }

    public void updateClient() {
        Integer[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            EntityData data = (EntityData)this.entries.get(keys[i]);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(data.entityID);
            if (entity != null) {
                if (!data.entityType.equalsIgnoreCase(entity.func_70005_c_())) {
                    this.newEntry(entity.func_145782_y());
                    continue;
                }
                data.motion_prev.set((ReadableVector3f)data.motion);
                data.motion.x = (float)entity.field_70165_t - data.position.x;
                data.motion.y = (float)entity.field_70163_u - data.position.y;
                data.motion.z = (float)entity.field_70161_v - data.position.z;
                data.position = new Vector3f((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v);
                continue;
            }
            this.removeEntry(data.entityID);
        }
    }

    public void updateRender(float partialTicks) {
        Integer[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            ((EntityData)this.entries.get(keys[i])).update(partialTicks);
        }
    }

    public EntityData[] toArray() {
        if (!this.entries.isEmpty()) {
            return this.entries.values().toArray(new EntityData[0]);
        }
        return new EntityData[0];
    }

    public Integer[] getKeys() {
        return this.entries.keySet().toArray(new Integer[0]);
    }
}

