/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dttraverse.ModContent;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import prospector.traverse.world.TraverseWorld;

public class SpeciesAutumnRed
extends SpeciesRare {
    public SpeciesAutumnRed(TreeFamily treeFamily) {
        super(new ResourceLocation("dttraverse", "autumn_red"), treeFamily, ModContent.autumnRedLeavesProperties);
        this.setBasicGrowingParameters(0.15f, 14.0f, 4, 4, 1.05f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.generateSeed();
        this.setupStandardSeedDropping();
        this.leavesProperties.setTree(treeFamily);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesAutumnRed.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{TraverseWorld.autumnalWoodedHillsBiome, TraverseWorld.autumnalWoodsBiome});
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }
}

