/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.trees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dttraverse.ModContent;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import prospector.traverse.world.TraverseWorld;

public class SpeciesAutumnYellow
extends SpeciesRare {
    public SpeciesAutumnYellow(TreeFamily treeFamily) {
        super(new ResourceLocation("dttraverse", "autumn_yellow"), treeFamily, ModContent.autumnYellowLeavesProperties);
        this.setBasicGrowingParameters(0.1f, 14.0f, 4, 4, 1.25f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.generateSeed();
        this.setupStandardSeedDropping();
        this.leavesProperties.setTree(treeFamily);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesAutumnYellow.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{TraverseWorld.autumnalWoodedHillsBiome, TraverseWorld.autumnalWoodsBiome});
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, Blocks.field_150338_P.func_176223_P());
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
            }
            return true;
        }
        return false;
    }
}

