/*
 * Decompiled with CFR 0.152.
 */
package jsit.campfire;

import java.util.HashSet;
import java.util.Set;
import jsit.campfire.Campfire;
import jsit.campfire.blocks.BlockAshMark;
import jsit.campfire.blocks.BlockCampfire;
import jsit.campfire.tileentity.TileEntityCampfire;
import jsit.campfire.tileentity.TileEntityCampfireRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="campfire")
@Mod.EventBusSubscriber(modid="campfire")
public class RegistryManager {
    public static Set<Item> itemsToReg = new HashSet<Item>();
    public static Set<Block> blocksToReg = new HashSet<Block>();
    public static Block campfire;
    public static Block ash;

    public static void init() {
        campfire = new BlockCampfire("campfire");
        RegistryManager.registerBlock(campfire);
        ash = new BlockAshMark("ash");
        RegistryManager.registerBlock(ash);
        GameRegistry.registerTileEntity(TileEntityCampfire.class, (String)"campfire:tile_entity_campfire");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRenders(RegistryEvent.Register<Item> event) {
        for (Item item : itemsToReg) {
            RegistryManager.registerRender(item);
        }
        for (Block block : blocksToReg) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCampfire.class, (TileEntitySpecialRenderer)new TileEntityCampfireRenderer());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemsToReg) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Block block : blocksToReg) {
            event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blocksToReg) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    public static void registerBlock(Block block) {
        block.func_149647_a(Campfire.tab);
        blocksToReg.add(block);
    }

    public static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void registerRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }
}

