/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.config;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Objects;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.IConfigElement;

public class UniqueProperty {
    private final String name;
    private final String langKey;
    private final Type type;

    public static String getLangKey(Field field, String modid, String category) {
        Config.LangKey la = field.getAnnotation(Config.LangKey.class);
        if (la != null) {
            return la.value();
        }
        return modid + "." + (category.isEmpty() ? "" : category + ".") + field.getName().toLowerCase(Locale.ENGLISH);
    }

    public static UniqueProperty fromProperty(Field field, String modid, String category, Type type) {
        String name = field.isAnnotationPresent(Config.Name.class) ? field.getAnnotation(Config.Name.class).value() : field.getName();
        String langKey = UniqueProperty.getLangKey(field, modid, category);
        return new UniqueProperty(name, langKey, type);
    }

    public UniqueProperty(String name, String langKey, Type type) {
        this.name = name;
        this.langKey = langKey;
        this.type = type;
    }

    public boolean matches(IConfigElement element) {
        return element.getLanguageKey().equals(this.langKey) && (element.isProperty() ? Type.fromType(element.getType()).equals((Object)this.type) : this.type == Type.CATEGORY) && Objects.equals(element.getName(), this.name);
    }

    public static enum Type {
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE,
        COLOR,
        MOD_ID,
        CATEGORY,
        UNKNOWN;


        public static Type fromType(Property.Type type) {
            if (type == null) {
                return UNKNOWN;
            }
            switch (type) {
                case STRING: {
                    return STRING;
                }
                case INTEGER: {
                    return INTEGER;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case COLOR: {
                    return COLOR;
                }
                case MOD_ID: {
                    return MOD_ID;
                }
            }
            throw new RuntimeException("Unknown property type " + type);
        }

        public static Type fromType(ConfigGuiType type) {
            if (type == null) {
                return UNKNOWN;
            }
            switch (type) {
                case STRING: {
                    return STRING;
                }
                case INTEGER: {
                    return INTEGER;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case COLOR: {
                    return COLOR;
                }
                case MOD_ID: {
                    return MOD_ID;
                }
                case CONFIG_CATEGORY: {
                    return CATEGORY;
                }
            }
            throw new RuntimeException("Unknown property type " + type);
        }
    }
}

