/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.PlayerHelper;

public class ItemLootContainer
extends Item {
    private static final String NBT_ROOT = "silentlib.LootContainer";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private final ResourceLocation defaultLootTable;

    public ItemLootContainer(ResourceLocation defaultLootTable) {
        this.defaultLootTable = defaultLootTable;
    }

    public ItemStack getStack() {
        return this.getStack(this.defaultLootTable);
    }

    public ItemStack getStack(ResourceLocation lootTable) {
        ItemStack result = new ItemStack((Item)this);
        result.func_190925_c(NBT_ROOT).func_74778_a(NBT_LOOT_TABLE, lootTable.toString());
        return result;
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, EntityPlayerMP player) {
        ResourceLocation lootTable = this.getLootTable(heldItem);
        LootContext lootContext = new LootContext.Builder(player.func_71121_q()).func_186472_a((Entity)player).func_186470_a((EntityPlayer)player).func_186469_a(player.func_184817_da()).func_186471_a();
        return new ArrayList<ItemStack>(player.field_70170_p.func_184146_ak().func_186521_a(lootTable).func_186462_a(player.func_70681_au(), lootContext));
    }

    private ResourceLocation getLootTable(ItemStack stack) {
        NBTTagCompound tags = stack.func_190925_c(NBT_ROOT);
        if (tags.func_74764_b(NBT_LOOT_TABLE)) {
            return new ResourceLocation(tags.func_74779_i(NBT_LOOT_TABLE));
        }
        return this.defaultLootTable;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_GRAY + "Loot Table: " + this.getLootTable(stack));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (!(playerIn instanceof EntityPlayerMP)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, playerMP);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("ItemLootContainer has no drops? {}", (Object)heldItem);
        }
        lootDrops.forEach(stack -> PlayerHelper.giveItem((EntityPlayer)playerMP, stack));
        playerMP.field_70170_p.func_184148_a(null, playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((playerMP.func_70681_au().nextFloat() - playerMP.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        heldItem.func_190918_g(1);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.func_77659_a(worldIn, player, hand).func_188397_a();
        return EnumActionResult.FAIL;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)this.getStack());
    }
}

