/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons;

import io.github.xcube16.iseedragons.ISeeDragons;
import io.github.xcube16.iseedragons.StaticConfig;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.config.Configuration;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.CheckClassAdapter;

public class AsmTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("com.github.alexthe666.iceandfire.item.ItemModAxe") || transformedName.equals("com.github.alexthe666.iceandfire.entity.EntityDragonBase") || transformedName.equals("net.minecraft.advancements.AdvancementManager") || transformedName.equals("net.minecraftforge.common.ForgeHooks") || transformedName.equals("com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg")) {
            ISeeDragons.logger.info("ATTEMPTING TO PATCH " + transformedName + "!");
            try {
                ClassReader reader = new ClassReader(bytes);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                boolean success = true;
                if (transformedName.equals("com.github.alexthe666.iceandfire.item.ItemModAxe")) {
                    success = this.fixItemModAxe(node);
                } else if (transformedName.equals("com.github.alexthe666.iceandfire.entity.EntityDragonBase")) {
                    success = this.fixEntityDragonBase(node);
                } else if (transformedName.equals("net.minecraft.advancements.AdvancementManager")) {
                    if (StaticConfig.disableAdvancements) {
                        success = this.nukeAdvancementManager(node);
                    }
                    if (success && StaticConfig.muteErroringAdvancements) {
                        success = this.muteAdvancementManager(node);
                    }
                } else if (transformedName.equals("net.minecraftforge.common.ForgeHooks")) {
                    Configuration cfg = new Configuration(Paths.get("config", "iseedragons.cfg").toFile());
                    cfg.load();
                    if (cfg.get("general", "muteErroringAdvancements", false).getBoolean()) {
                        success = this.muteForgeHooksLoadAdv(node);
                    }
                } else {
                    success = transformedName.equals("com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg") ? this.fixMyrmexEggDupe(node) : false;
                }
                if (success) {
                    ClassWriter writer = new ClassWriter(1);
                    node.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)writer));
                    bytes = writer.toByteArray();
                    ISeeDragons.logger.info("Patched " + transformedName);
                } else {
                    ISeeDragons.logger.error("Failed to patch " + transformedName + "!");
                }
            }
            catch (Throwable t) {
                ISeeDragons.logger.error("Aborting patch!", t);
            }
        }
        return bytes;
    }

    private boolean fixItemModAxe(ClassNode node) {
        AbstractInsnNode getstaticIns;
        int fieldCount = node.fields.size();
        node.fields = node.fields.stream().filter(field -> !field.name.equals("EFFECTIVE_ON")).collect(Collectors.toList());
        if (fieldCount != node.fields.size() + 1) {
            ISeeDragons.logger.error("Failed to remove EFFECTIVE_ON field");
            return false;
        }
        node.superName = "net/minecraft/item/ItemAxe";
        Optional<MethodNode> clinitMethod = node.methods.stream().filter(method -> method.name.equals("<clinit>")).findFirst();
        if (!clinitMethod.isPresent()) {
            ISeeDragons.logger.warn("Failed to find <clinit> method");
            return false;
        }
        node.methods.remove(clinitMethod.get());
        Optional<MethodNode> initMethod = node.methods.stream().filter(method -> method.name.equals("<init>")).findFirst();
        if (!initMethod.isPresent()) {
            ISeeDragons.logger.error("Failed to find <init> method");
            return false;
        }
        for (getstaticIns = initMethod.get().instructions.getFirst(); getstaticIns != null && getstaticIns.getOpcode() != 178; getstaticIns = getstaticIns.getNext()) {
        }
        if (getstaticIns == null) {
            ISeeDragons.logger.error("Failed to find GETSTATIC instruction");
            return false;
        }
        AbstractInsnNode invokespecialIns = getstaticIns.getNext();
        initMethod.get().instructions.remove(getstaticIns.getPrevious());
        ((FieldInsnNode)getstaticIns).owner = "net/minecraft/item/Item$ToolMaterial";
        ((FieldInsnNode)getstaticIns).name = "DIAMOND";
        ((FieldInsnNode)getstaticIns).desc = "Lnet/minecraft/item/Item$ToolMaterial;";
        if (invokespecialIns == null || invokespecialIns.getOpcode() != 183) {
            ISeeDragons.logger.error("Failed to find INVOKESPECIAL instruction");
            return false;
        }
        ((MethodInsnNode)invokespecialIns).owner = "net/minecraft/item/ItemAxe";
        ((MethodInsnNode)invokespecialIns).desc = "(Lnet/minecraft/item/Item$ToolMaterial;)V";
        InsnList setToolMaterial = new InsnList();
        setToolMaterial.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setToolMaterial.add((AbstractInsnNode)new VarInsnNode(25, 1));
        setToolMaterial.add((AbstractInsnNode)new FieldInsnNode(181, "com/github/alexthe666/iceandfire/item/ItemModAxe", "field_77862_b", "Lnet/minecraft/item/Item$ToolMaterial;"));
        initMethod.get().instructions.insert(invokespecialIns, setToolMaterial);
        return true;
    }

    private boolean fixEntityDragonBase(ClassNode node) {
        AbstractInsnNode breakBlockCall;
        Optional<MethodNode> breakBlockMethod = node.methods.stream().filter(method -> method.name.equals("breakBlock")).findFirst();
        if (!breakBlockMethod.isPresent()) {
            ISeeDragons.logger.warn("Failed to find breakBlock() method");
            return false;
        }
        for (breakBlockCall = breakBlockMethod.get().instructions.getFirst(); !(breakBlockCall == null || breakBlockCall.getOpcode() == 182 && ((MethodInsnNode)breakBlockCall).name.equals("func_175655_b")); breakBlockCall = breakBlockCall.getNext()) {
        }
        if (breakBlockCall == null) {
            ISeeDragons.logger.error("Failed to find func_175655_b (World#destroyBlock()) call");
            return false;
        }
        breakBlockMethod.get().instructions.remove(breakBlockCall.getPrevious());
        InsnList callHook = new InsnList();
        callHook.add((AbstractInsnNode)new VarInsnNode(25, 5));
        callHook.add((AbstractInsnNode)new MethodInsnNode(184, "io/github/xcube16/iseedragons/ISeeDragons", "dragonBreakBlockHook", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"));
        breakBlockMethod.get().instructions.insertBefore(breakBlockCall, callHook);
        breakBlockMethod.get().instructions.remove(breakBlockCall);
        return true;
    }

    private boolean nukeAdvancementManager(ClassNode node) {
        Optional<MethodNode> breakBlockMethod = node.methods.stream().filter(method -> method.name.equals("func_192779_a")).findFirst();
        if (!breakBlockMethod.isPresent()) {
            ISeeDragons.logger.warn("Failed to find func_192779_a() (reload) method");
            return false;
        }
        breakBlockMethod.get().instructions.clear();
        breakBlockMethod.get().localVariables.clear();
        breakBlockMethod.get().tryCatchBlocks.clear();
        breakBlockMethod.get().instructions.add((AbstractInsnNode)new InsnNode(177));
        return true;
    }

    private boolean fixMyrmexEggDupe(ClassNode node) throws NoSuchMethodException {
        MethodNode attackEntityFrom = AsmTransformer.findMethod(node, "func_70097_a");
        InsnList deadCheck = new InsnList();
        LabelNode continueLabel = new LabelNode();
        deadCheck.add((AbstractInsnNode)new VarInsnNode(25, 0));
        deadCheck.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "field_70128_L", "Z"));
        deadCheck.add((AbstractInsnNode)new JumpInsnNode(153, continueLabel));
        deadCheck.add((AbstractInsnNode)new InsnNode(3));
        deadCheck.add((AbstractInsnNode)new InsnNode(172));
        deadCheck.add((AbstractInsnNode)new FrameNode(3, 3, new Object[]{"com/github/alexthe666/entity/EntityMyrmexEgg", "net/minecraft/util/DamageSource", Opcodes.FLOAT}, 0, new Object[0]));
        deadCheck.add((AbstractInsnNode)continueLabel);
        attackEntityFrom.instructions.insert(deadCheck);
        return true;
    }

    private boolean muteAdvancementManager(ClassNode node) throws NoSuchMethodException {
        return this.muteMethod(AsmTransformer.findMethod(node, "func_192781_c")) && this.muteMethod(AsmTransformer.findMethod(node, "func_192777_a"));
    }

    private boolean muteForgeHooksLoadAdv(ClassNode node) throws NoSuchMethodException {
        return this.muteMethod(AsmTransformer.findMethod(node, "lambda$loadAdvancements$0"));
    }

    private boolean muteMethod(MethodNode method) {
        boolean flag = false;
        for (AbstractInsnNode ip = method.instructions.getFirst(); ip != null; ip = ip.getNext()) {
            if (ip.getOpcode() != 185) continue;
            MethodInsnNode call = (MethodInsnNode)ip;
            if (!call.owner.equals("org/apache/logging/log4j/Logger") || !call.name.equals("error") || !call.desc.equals("(Ljava/lang/String;Ljava/lang/Throwable;)V")) continue;
            method.instructions.insert((AbstractInsnNode)call, (AbstractInsnNode)new InsnNode(88));
            method.instructions.insert((AbstractInsnNode)call, (AbstractInsnNode)new InsnNode(87));
            ip = call.getPrevious();
            method.instructions.remove((AbstractInsnNode)call);
            flag = true;
        }
        return flag;
    }

    private static MethodNode findMethod(ClassNode node, String name) throws NoSuchMethodException {
        return AsmTransformer.findMethod(node, name, null);
    }

    private static MethodNode findMethod(ClassNode node, String name, @Nullable String desc) throws NoSuchMethodException {
        Optional<MethodNode> method = node.methods.stream().filter(m -> m.name.equals(name)).filter(m -> desc == null || m.desc.equals(desc)).findFirst();
        if (!method.isPresent()) {
            ISeeDragons.logger.warn("Failed to find loadCustomAdvancements() method");
            throw new NoSuchMethodException(node.name + " " + name + " " + desc);
        }
        return method.get();
    }
}

