/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FakeThirstStatHandler {
    private Object handler;
    private Method onPlayerJump;
    private Method onPlayerHurt;
    private Method onBlockBreak;
    private Method getThirstData;
    private Class thirstHandlerClass;
    private Method addExhaustion;

    public FakeThirstStatHandler(Object handler) throws Exception {
        this.handler = handler;
        this.onPlayerJump = handler.getClass().getMethod("onPlayerJump", LivingEvent.LivingJumpEvent.class);
        this.onPlayerHurt = handler.getClass().getMethod("onPlayerHurt", LivingHurtEvent.class);
        this.onBlockBreak = handler.getClass().getMethod("onBlockBreak", BlockEvent.BreakEvent.class);
        this.getThirstData = Class.forName("toughasnails.api.thirst.ThirstHelper").getMethod("getThirstData", EntityPlayer.class);
        this.thirstHandlerClass = Class.forName("toughasnails.thirst.ThirstHandler");
        this.addExhaustion = this.thirstHandlerClass.getMethod("addExhaustion", Float.TYPE);
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        try {
            this.onPlayerJump.invoke(this.handler, event);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.failMethod(e);
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        try {
            this.onPlayerHurt.invoke(this.handler, event);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.failMethod(e);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        try {
            this.onBlockBreak.invoke(this.handler, event);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.failMethod(e);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        try {
            World world = event.getEntity().field_70170_p;
            if (world.field_72995_K) {
                return;
            }
            EntityPlayer player = event.getEntityPlayer();
            Entity monster = event.getTarget();
            if (monster.func_70075_an() && !player.func_184812_l_() && !monster.func_85031_j((Entity)player)) {
                Object thirstHandler = this.thirstHandlerClass.cast(this.getThirstData.invoke(null, player));
                this.addExhaustion.invoke(thirstHandler, Float.valueOf(0.3f));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.failMethod(e);
        }
    }

    private void failMethod(Exception e) {
        throw new RuntimeException("FakeThirstStatHandler failed reflection", e);
    }
}

