/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="dynamictrees")
public class ModRecipes {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void register(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ModItems.dendroPotion.registerRecipes((IForgeRegistry<IRecipe>)registry);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("dynamictrees", "dirtbucket"), null, (ItemStack)new ItemStack((Item)ModItems.dirtBucket), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151133_ar), Ingredient.func_193367_a((Item)ItemBlock.func_150898_a((Block)Blocks.field_150346_d))});
        for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
            Species species = TreeRegistry.findSpecies(new ResourceLocation("dynamictrees", woodType.func_176610_l().replace("_", "")));
            ItemStack saplingStack = new ItemStack(Blocks.field_150345_g, 1, woodType.func_176839_a());
            ItemStack seedStack = species.getSeedStack(1);
            ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, true);
        }
        if (ModConfigs.enableAppleTrees) {
            ModRecipes.createDirtBucketExchangeRecipes(new ItemStack(Items.field_151034_e), TreeRegistry.findSpecies(new ResourceLocation("dynamictrees", "apple")).getSeedStack(1), false);
        }
    }

    public static void createDirtBucketExchangeRecipes(ItemStack saplingStack, ItemStack seedStack, boolean seedIsSapling) {
        ModRecipes.createDirtBucketExchangeRecipes(saplingStack, seedStack, seedIsSapling, "seed");
    }

    public static void createDirtBucketExchangeRecipes(ItemStack saplingStack, ItemStack seedStack, boolean seedIsSapling, String suffix) {
        if (!saplingStack.func_190926_b() && !seedStack.func_190926_b() && seedStack.func_77973_b() instanceof Seed) {
            Seed seed = (Seed)seedStack.func_77973_b();
            String speciesPath = seed.getSpecies(seedStack).getRegistryName().func_110623_a();
            String speciesDomain = seed.getSpecies(seedStack).getRegistryName().func_110624_b();
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(speciesDomain, speciesPath + suffix), null, (ItemStack)seedStack, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{saplingStack}), Ingredient.func_193367_a((Item)ModItems.dirtBucket)});
            if (seedIsSapling) {
                GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(speciesDomain, speciesPath + "sapling"), null, (ItemStack)saplingStack, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{seedStack}), Ingredient.func_193367_a((Item)ModItems.dirtBucket)});
                OreDictionary.registerOre((String)"treeSapling", (ItemStack)seedStack);
            }
        }
    }
}

