/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.trees.Mushroom;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeAcacia;
import com.ferreusveritas.dynamictrees.trees.TreeBirch;
import com.ferreusveritas.dynamictrees.trees.TreeCactus;
import com.ferreusveritas.dynamictrees.trees.TreeDarkOak;
import com.ferreusveritas.dynamictrees.trees.TreeFamilyVanilla;
import com.ferreusveritas.dynamictrees.trees.TreeJungle;
import com.ferreusveritas.dynamictrees.trees.TreeOak;
import com.ferreusveritas.dynamictrees.trees.TreeSpruce;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictrees")
public class ModTrees {
    public static final String NULL = "null";
    public static final String OAK = "oak";
    public static final String BIRCH = "birch";
    public static final String SPRUCE = "spruce";
    public static final String JUNGLE = "jungle";
    public static final String DARKOAK = "darkoak";
    public static final String ACACIA = "acacia";
    public static final String CONIFER = "conifer";
    public static ArrayList<TreeFamilyVanilla> baseFamilies = new ArrayList();
    public static TreeCactus dynamicCactus;

    public static void preInit() {
        Species.REGISTRY.register(Species.NULLSPECIES.setRegistryName(new ResourceLocation("dynamictrees", NULL)));
        Collections.addAll(baseFamilies, new TreeOak(), new TreeSpruce(), new TreeBirch(), new TreeJungle(), new TreeAcacia(), new TreeDarkOak());
        baseFamilies.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        dynamicCactus = new TreeCactus();
        dynamicCactus.registerSpecies(Species.REGISTRY);
        Species.REGISTRY.register((IForgeRegistryEntry)new Mushroom(true));
        Species.REGISTRY.register((IForgeRegistryEntry)new Mushroom(false));
        for (TreeFamilyVanilla vanillaFamily : baseFamilies) {
            TreeRegistry.registerSaplingReplacer(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)vanillaFamily.woodType), vanillaFamily.getCommonSpecies());
        }
    }

    @SubscribeEvent
    public static void newRegistry(RegistryEvent.NewRegistry event) {
        Species.newRegistry(event);
    }
}

