/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.IRayTraceCollision;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicLeaves
extends BlockLeaves
implements ITreePart,
IAgeable,
IRayTraceCollision {
    public static boolean passableLeavesModLoaded = false;
    protected static Random backupRng = new Random();
    public static final PropertyInteger HYDRO = PropertyInteger.func_177719_a((String)"hydro", (int)1, (int)4);
    public static final PropertyInteger TREE = PropertyInteger.func_177719_a((String)"tree", (int)0, (int)3);
    public ILeavesProperties[] properties = new ILeavesProperties[]{LeavesProperties.NULLPROPERTIES, LeavesProperties.NULLPROPERTIES, LeavesProperties.NULLPROPERTIES, LeavesProperties.NULLPROPERTIES};

    public BlockDynamicLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(0)));
    }

    public Block setDefaultNaming(String modid, String name) {
        this.setRegistryName(modid, name);
        this.func_149663_c(this.getRegistryName().toString());
        return this;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HYDRO, TREE, field_176237_a});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(meta >> 2 & 3)).func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf((meta & 3) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)HYDRO) - 1 | (Integer)state.func_177229_b((IProperty)TREE) << 2;
    }

    public void setProperties(int tree, ILeavesProperties properties) {
        this.properties[tree & 3] = properties;
    }

    public ILeavesProperties getProperties(IBlockState blockState) {
        return this.properties[(Integer)blockState.func_177229_b((IProperty)TREE) & 3];
    }

    @Override
    public TreeFamily getFamily(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos) {
        return this.getProperties(blockState).getTree();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getProperties(world.func_180495_p(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getProperties(world.func_180495_p(pos)).getFireSpreadSpeed();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand == null) {
            rand = backupRng;
        }
        if (rand.nextInt(ModConfigs.treeGrowthFolding) == 0) {
            float attempts = (float)ModConfigs.treeGrowthFolding * ModConfigs.treeGrowthMultiplier;
            if (attempts >= 1.0f || rand.nextFloat() < attempts) {
                this.doTick(worldIn, pos, state, rand);
            }
            int start = rand.nextInt(26);
            while (true) {
                int r;
                BlockPos dPos;
                IBlockState dState;
                float f;
                attempts -= 1.0f;
                if (!(f > 0.0f)) break;
                if (!(attempts >= 1.0f) && !(rand.nextFloat() < attempts) || !((dState = worldIn.func_180495_p(dPos = pos.func_177982_a((r = (r = start++ % 26 + 14) > 26 ? r - 13 : r - 14) % 3 - 1, r / 3 % 3 - 1, r / 9 % 3 - 1))).func_177230_c() instanceof BlockDynamicLeaves)) continue;
                ((BlockDynamicLeaves)dState.func_177230_c()).doTick(worldIn, dPos, dState, rand);
            }
        }
    }

    protected void doTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((pos.func_177958_n() != 0 && pos.func_177958_n() != 15 & pos.func_177952_p() != 0 & pos.func_177952_p() != 15 || worldIn.func_175697_a(pos, 1)) && this.getProperties(state).updateTick(worldIn, pos, state, rand)) {
            this.age(worldIn, pos, state, rand, SafeChunkBounds.ANY);
        }
    }

    @Override
    public int age(World world, BlockPos pos, IBlockState state, Random rand, SafeChunkBounds safeBounds) {
        ILeavesProperties leavesProperties = this.getProperties(state);
        int oldHydro = (Integer)state.func_177229_b((IProperty)HYDRO);
        boolean worldGen = safeBounds != SafeChunkBounds.ANY;
        int newHydro = this.getHydrationLevelFromNeighbors((IBlockAccess)world, pos, leavesProperties);
        if (newHydro == 0 || !worldGen && !this.hasAdequateLight(state, world, leavesProperties, pos)) {
            world.func_175698_g(pos);
            return -1;
        }
        if (oldHydro != newHydro) {
            world.func_180501_a(pos, leavesProperties.getDynamicLeavesState(newHydro), leavesProperties.appearanceChangesWithHydro() ? 2 : 4);
        }
        NewLeavesPropertiesHandler newLeavesHander = this.getNewLeavesPropertiesHandler(world, pos, state, newHydro, worldGen);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int hydro;
            BlockPos offpos;
            if (newHydro <= 1 && rand.nextInt(4) != 0 || !safeBounds.inBounds(offpos = pos.func_177972_a(dir), true) || !this.isLocationSuitableForNewLeaves(world, leavesProperties, offpos) || (hydro = this.getHydrationLevelFromNeighbors((IBlockAccess)world, offpos, leavesProperties)) <= 0) continue;
            world.func_180501_a(offpos, newLeavesHander.getLeaves(world, offpos, leavesProperties.getDynamicLeavesState(hydro)), 2);
        }
        return newHydro;
    }

    protected NewLeavesPropertiesHandler getNewLeavesPropertiesHandler(World world, BlockPos pos, IBlockState state, int newHydro, boolean worldGen) {
        return (w, p, l) -> l;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getProperties(state).getPrimitiveLeavesItemStack();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getProperties(state).getPrimitiveLeaves().func_185909_g(world, pos);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean unknown) {
        if (entityIn instanceof EntityItem) {
            EntityItem item = (EntityItem)entityIn;
            if (item.func_92059_d().func_77973_b() instanceof Seed) {
                return;
            }
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, unknown);
            return;
        }
        if (entityIn == null || entityIn instanceof EntityFallingTree) {
            return;
        }
        if (passableLeavesModLoaded || ModConfigs.vanillaLeavesCollision) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, unknown);
        } else if (!ModConfigs.isLeavesPassable) {
            AxisAlignedBB aabb = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
            BlockDynamicLeaves.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (ModConfigs.canopyCrash && entity instanceof EntityLivingBase) {
            entity.field_70143_R -= 1.0f;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            int minX = MathHelper.func_76128_c((double)(aabb.field_72340_a + 0.001));
            int minZ = MathHelper.func_76128_c((double)(aabb.field_72339_c + 0.001));
            int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d - 0.001));
            int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f - 0.001));
            boolean crushing = true;
            boolean hasLeaves = true;
            SoundType stepSound = this.func_185467_w();
            float volume = MathHelper.func_76131_a((float)(stepSound.func_185843_a() / 16.0f * fallDistance), (float)0.0f, (float)3.0f);
            world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stepSound.func_185845_c(), SoundCategory.BLOCKS, volume, stepSound.func_185847_b(), false);
            int iy = 0;
            while (entity.field_70143_R > 3.0f && crushing && pos.func_177956_o() - iy > 0) {
                if (hasLeaves) {
                    entity.field_70143_R *= 0.66f;
                    hasLeaves = false;
                }
                for (int ix = minX; ix <= maxX; ++ix) {
                    for (int iz = minZ; iz <= maxZ; ++iz) {
                        BlockPos iPos = new BlockPos(ix, pos.func_177956_o() - iy, iz);
                        IBlockState state = world.func_180495_p(iPos);
                        if (TreeHelper.isLeaves(state)) {
                            hasLeaves = true;
                            DynamicTrees.proxy.crushLeavesBlock(world, iPos, state, entity);
                            world.func_175698_g(iPos);
                            continue;
                        }
                        if (world.func_175623_d(iPos)) continue;
                        crushing = false;
                    }
                }
                ++iy;
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem || passableLeavesModLoaded || ModConfigs.vanillaLeavesCollision) {
            super.func_180634_a(world, pos, state, entity);
        } else {
            if (entity.field_70181_x < 0.0 && entity.field_70143_R < 2.0f) {
                entity.field_70143_R = 0.0f;
                entity.field_70181_x *= 0.5;
            } else if (entity.field_70181_x > 0.0 && entity.field_70181_x < 0.25) {
                entity.field_70181_x += 0.025;
            }
            entity.func_70031_b(false);
            entity.field_70159_w *= 0.25;
            entity.field_70179_y *= 0.25;
        }
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public boolean growLeavesIfLocationIsSuitable(World world, ILeavesProperties leavesProp, BlockPos pos, int hydro) {
        int n = hydro = hydro == 0 ? leavesProp.getCellKit().getDefaultHydration() : hydro;
        if (this.isLocationSuitableForNewLeaves(world, leavesProp, pos)) {
            world.func_180501_a(pos, leavesProp.getDynamicLeavesState(hydro), 2 | (leavesProp.appearanceChangesWithHydro() ? 1 : 0));
            return true;
        }
        return false;
    }

    public boolean isLocationSuitableForNewLeaves(World world, ILeavesProperties leavesProperties, BlockPos pos) {
        BlockDoublePlant.EnumPlantType type;
        IBlockState bs;
        BlockDoublePlant.EnumBlockHalf half;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockDynamicLeaves) {
            return false;
        }
        IBlockState belowBlockState = world.func_180495_p(pos.func_177977_b());
        if (belowBlockState.func_185917_h() && !(belowBlockState.func_177230_c() instanceof BlockLeaves) || belowBlockState.func_177230_c() instanceof BlockLiquid) {
            return false;
        }
        if (block == Blocks.field_150398_cm && (half = (BlockDoublePlant.EnumBlockHalf)(bs = world.func_180495_p(pos)).func_177229_b((IProperty)BlockDoublePlant.field_176492_b)) == BlockDoublePlant.EnumBlockHalf.UPPER && belowBlockState.func_177230_c() == Blocks.field_150398_cm && ((type = (BlockDoublePlant.EnumPlantType)belowBlockState.func_177229_b((IProperty)BlockDoublePlant.field_176493_a)) == BlockDoublePlant.EnumPlantType.GRASS || type == BlockDoublePlant.EnumPlantType.FERN)) {
            world.func_175698_g(pos);
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)(type == BlockDoublePlant.EnumPlantType.GRASS ? BlockTallGrass.EnumType.GRASS : BlockTallGrass.EnumType.FERN)), 3);
        }
        return world.func_175623_d(pos) && this.hasAdequateLight(blockState, world, leavesProperties, pos);
    }

    public boolean hasAdequateLight(IBlockState blockState, World world, ILeavesProperties leavesProperties, BlockPos pos) {
        if (world.func_175710_j(pos)) {
            return true;
        }
        int smother = leavesProperties.getSmotherLeavesMax();
        if (smother != 0 && BlockDynamicLeaves.isBottom(world, pos)) {
            int smotherLeaves = 0;
            for (int i = 0; i < smother; ++i) {
                smotherLeaves += TreeHelper.isTreePart((IBlockAccess)world, pos.func_177981_b(i + 1)) ? 1 : 0;
            }
            if (smotherLeaves >= smother) {
                return false;
            }
        }
        return world.func_175642_b(EnumSkyBlock.SKY, pos) >= (TreeHelper.isLeaves(blockState) ? leavesProperties.getLightRequirement() - 2 : leavesProperties.getLightRequirement());
    }

    public static boolean isBottom(World world, BlockPos pos) {
        IBlockState belowBlockState = world.func_180495_p(pos.func_177977_b());
        ITreePart belowTreepart = TreeHelper.getTreePart(belowBlockState);
        if (belowTreepart != TreeHelper.nullTreePart) {
            return belowTreepart.getRadius(belowBlockState) > 1;
        }
        return true;
    }

    public int getHydrationLevelFromNeighbors(IBlockAccess access, BlockPos pos, ILeavesProperties leavesProp) {
        ICell[] cells = new ICell[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            IBlockState state = access.func_180495_p(deltaPos);
            ITreePart part = TreeHelper.getTreePart(state);
            cells[dir.ordinal()] = part.getHydrationCell(access, deltaPos, state, dir, leavesProp);
        }
        return leavesProp.getCellKit().getCellSolver().solve(cells);
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, ILeavesProperties leavesProperties) {
        return dir != null ? leavesProperties.getCellKit().getCellForLeaves((Integer)blockState.func_177229_b((IProperty)HYDRO)) : CellNull.NULLCELL;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            this.branchOut(world, pos, signal);
        }
        return signal;
    }

    public boolean needLeaves(World world, BlockPos pos, ILeavesProperties leavesProperties) {
        if (world.func_175623_d(pos)) {
            return this.growLeavesIfLocationIsSuitable(world, leavesProperties, pos, leavesProperties.getCellKit().getDefaultHydration());
        }
        IBlockState blockState = world.func_180495_p(pos);
        ITreePart treepart = TreeHelper.getTreePart(blockState);
        return treepart == this && leavesProperties == this.getProperties(blockState);
    }

    public GrowSignal branchOut(World world, BlockPos pos, GrowSignal signal) {
        ILeavesProperties leavesProperties = signal.getSpecies().getLeavesProperties();
        if (!this.needLeaves(world, pos, leavesProperties)) {
            signal.success = false;
            return signal;
        }
        EnumFacing originDir = signal.dir.func_176734_d();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch(world.func_180495_p(pos.func_177972_a(dir)))) continue;
            signal.success = false;
            return signal;
        }
        boolean hasLeaves = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.needLeaves(world, pos.func_177972_a(dir), leavesProperties)) continue;
            hasLeaves = true;
            break;
        }
        if (hasLeaves) {
            TreeFamily family = signal.getSpecies().getFamily();
            family.getDynamicBranch().setRadius(world, pos, (int)family.getPrimaryThickness(), null);
            signal.radius = family.getSecondaryThickness();
        }
        signal.success = hasLeaves;
        return signal;
    }

    @Override
    public int probabilityForBlock(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return from.getFamily().isCompatibleDynamicLeaves(blockState, blockAccess, pos) ? 2 : 0;
    }

    public List<ItemStack> getDrops(IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.getExactSpecies(access, pos, this.getProperties(state)).getLeavesDrops(access, pos, ret, fortune);
        return ret;
    }

    Species getExactSpecies(IBlockAccess access, BlockPos pos, ILeavesProperties leavesProperties) {
        if (access instanceof World) {
            World world = (World)access;
            ArrayList<BlockPos> branchList = new ArrayList<BlockPos>();
            for (BlockPos blockPos : leavesProperties.getCellKit().getLeafCluster().getAllNonZero()) {
                BlockBranch branch;
                BlockPos blockPos2 = pos.func_177971_a((Vec3i)BlockPos.field_177992_a.func_177973_b((Vec3i)blockPos));
                IBlockState state = access.func_180495_p(blockPos2);
                if (!TreeHelper.isBranch(state) || (branch = TreeHelper.getBranch(state)).getFamily() != leavesProperties.getTree() || branch.getRadius(state) != 1) continue;
                branchList.add(blockPos2);
            }
            if (!branchList.isEmpty()) {
                BlockPos closest = (BlockPos)branchList.get(0);
                double d = 999.0;
                for (BlockPos dPos : branchList) {
                    double d2 = pos.func_177951_i((Vec3i)dPos);
                    if (!(d2 < d)) continue;
                    d = d2;
                    closest = dPos;
                }
                return TreeHelper.getExactSpecies(world.func_180495_p(closest), world, closest);
            }
        }
        return Species.NULLSPECIES;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess blockAccess, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ILeavesProperties properties = this.getProperties(blockAccess.func_180495_p(pos));
        ItemStack stack = properties.getPrimitiveLeavesItemStack().func_77946_l();
        stack.func_190920_e(1);
        ret.add(stack);
        return ret;
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return this.getProperties(blockState).getRadiusForConnection(blockState, blockAccess, pos, from, side, fromRadius);
    }

    public boolean func_176205_b(IBlockAccess access, BlockPos pos) {
        return passableLeavesModLoaded ? super.func_176205_b(access, pos) : ModConfigs.isLeavesPassable;
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return 0;
    }

    @Override
    public boolean shouldAnalyse() {
        return false;
    }

    @Override
    public MapSignal analyse(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return radius == 1 && branch.getFamily() == this.getFamily(blockState, blockAccess, pos) ? BlockBranch.setSupport(0, 1) : 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        this.func_150122_b(!Blocks.field_150362_t.func_149662_c(blockState));
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    public final ITreePart.TreePartType getTreePartType() {
        return ITreePart.TreePartType.LEAVES;
    }

    @Override
    public boolean isRayTraceCollidable() {
        return true;
    }

    protected static interface NewLeavesPropertiesHandler {
        public IBlockState getLeaves(World var1, BlockPos var2, IBlockState var3);
    }
}

