/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WailaBranchHandler
implements IWailaDataProvider {
    private BlockPos lastPos = BlockPos.field_177992_a;
    private Species lastSpecies = Species.NULLSPECIES;
    private float lastVolume = 0.0f;

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound nbtData = accessor.getNBTData();
        BlockPos pos = accessor.getPosition();
        Species species = Species.NULLSPECIES;
        if (nbtData.func_74764_b("species")) {
            species = TreeRegistry.findSpecies(new ResourceLocation(nbtData.func_74779_i("species")));
        }
        if (species == Species.NULLSPECIES && this.lastPos.equals((Object)pos)) {
            species = this.lastSpecies;
        }
        if (species == Species.NULLSPECIES) {
            species = this.getWailaSpecies(accessor.getWorld(), pos);
        }
        if (!this.lastPos.equals((Object)pos)) {
            this.lastVolume = this.getTreeVolume(accessor.getWorld(), pos);
        }
        this.lastSpecies = species;
        this.lastPos = pos;
        if (species != Species.NULLSPECIES) {
            tooltip.add("Species: " + species.getRegistryName().func_110623_a());
            String renderString = "";
            ItemStack seedStack = species.getSeedStack(1);
            String seedName = seedStack.func_77973_b().getRegistryName().toString();
            renderString = renderString + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", seedName, String.valueOf(1), String.valueOf(seedStack.func_77952_i())});
            if (this.lastVolume > 0.0f) {
                Species.LogsAndSticks las = species.getLogsAndSticks(this.lastVolume);
                if (las.logs > 0) {
                    ItemStack logStack = species.getFamily().getPrimitiveLogItemStack(1);
                    String logName = logStack.func_77973_b().getRegistryName().toString();
                    renderString = renderString + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", logName, String.valueOf(las.logs), String.valueOf(logStack.func_77952_i())});
                }
                if (las.sticks > 0) {
                    ItemStack stickStack = species.getFamily().getStick(1);
                    String stickName = stickStack.func_77973_b().getRegistryName().toString();
                    renderString = renderString + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", stickName, String.valueOf(las.sticks), String.valueOf(stickStack.func_77952_i())});
                }
            }
            tooltip.add(renderString);
        }
        return tooltip;
    }

    private float getTreeVolume(World world, BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockTrunkShell && (muse = ((BlockTrunkShell)block).getMuse((IBlockAccess)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)block;
            NodeNetVolume volumeSum = new NodeNetVolume();
            branch.analyse(state, world, pos, null, new MapSignal(volumeSum));
            return volumeSum.getVolume() * ModConfigs.treeHarvestMultiplier;
        }
        return 0.0f;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        Species species = this.getWailaSpecies(world, pos);
        if (species != Species.NULLSPECIES) {
            tag.func_74778_a("species", species.getRegistryName().toString());
        }
        return tag;
    }

    private Species getWailaSpecies(World world, BlockPos pos) {
        BlockTrunkShell.ShellMuse muse;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockTrunkShell && (muse = ((BlockTrunkShell)block).getMuse((IBlockAccess)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BlockBranch) {
            BlockBranch branch = (BlockBranch)state.func_177230_c();
            Species species = TreeHelper.getExactSpecies(state, world, pos);
            if (species == Species.NULLSPECIES) {
                species = branch.getFamily().getCommonSpecies();
            }
            return species;
        }
        return Species.NULLSPECIES;
    }
}

