/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.IRadiusCoordinator;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class BiomeRadiusCoordinator
implements IRadiusCoordinator {
    public NoiseGeneratorPerlin noiseGenerator = new NoiseGeneratorPerlin(new Random(96L), 1);
    protected final TreeGenerator treeGenerator;
    protected final World world;
    protected int pass;
    protected Function<Integer, Integer> chunkMultipass;

    public BiomeRadiusCoordinator(TreeGenerator treeGenerator, World world) {
        this.world = world;
        this.treeGenerator = treeGenerator;
    }

    @Override
    public int getRadiusAtCoords(int x, int z) {
        int rad = this.chunkMultipass.apply(this.pass);
        if (rad >= 2 && rad <= 8) {
            return rad;
        }
        double scale = 128.0;
        Biome biome = this.world.func_180494_b(new BlockPos(x + 8, 0, z + 8));
        double noiseDensity = (this.noiseGenerator.func_151601_a((double)x / scale, (double)z / scale) + 1.0) / 2.0;
        double density = this.treeGenerator.getBiomeDataBase(this.world).getDensity(biome).getDensity(this.world.field_73012_v, noiseDensity);
        double size = (1.0 - density) * 9.0;
        int kindaRandom = (x * 674365771 ^ z * 254326997) >> 4;
        int shakelow = (kindaRandom & 3) % 3;
        int shakehigh = (kindaRandom & 0xC) % 3;
        return MathHelper.func_76125_a((int)((int)size), (int)(2 + shakelow), (int)(8 - shakehigh));
    }

    @Override
    public boolean runPass(int chunkX, int chunkZ, int pass) {
        this.pass = pass;
        if (pass == 0) {
            Biome biome = this.world.func_180494_b(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
            this.chunkMultipass = this.treeGenerator.getBiomeDataBase(this.world).getMultipass(biome);
        }
        return this.chunkMultipass.apply(pass) >= 0;
    }
}

