/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.proxies;

import de.impelon.disenchanter.DisenchanterMain;
import de.impelon.disenchanter.blocks.BlockDisenchantmentTable;
import de.impelon.disenchanter.blocks.ItemBlockDisenchantment;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.blocks.TileEntityDisenchantmentTableAutomatic;
import de.impelon.disenchanter.crafting.UpgradeTableRecipe;
import de.impelon.disenchanter.gui.GUIHandler;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonProxy {
    public static final BlockDisenchantmentTable disenchantmentTable = new BlockDisenchantmentTable();
    public static final ItemBlockDisenchantment itemDisenchantmentTable = new ItemBlockDisenchantment();
    private static final ResourceLocation disenchantmentTableUseLocation = new ResourceLocation("disenchanter", "block.disenchantment_table.use");
    public static final SoundEvent disenchantmentTableUse = (SoundEvent)new SoundEvent(disenchantmentTableUseLocation).setRegistryName(disenchantmentTableUseLocation);

    public void preInit(FMLPreInitializationEvent ev) {
        Configuration config;
        DisenchanterMain.config = config = new Configuration(ev.getSuggestedConfigurationFile());
        config.load();
        config.get("general", "CheckVersion", true, "Should Disenchanter check for new versions on startup?");
        config.get("general", "EnableAutomaticRecipe", true, "Should the recipe for the automatic-upgrade be avalible?");
        config.get("general", "EnableVoidingRecipe", true, "Should the recipe for the voiding-upgrade be avalible?");
        config.get("general", "EnableBulkDisenchantingRecipe", true, "Should the recipe for the bulk-disenchanting-upgrade be avalible?");
        config.get("general", "EnableClearRecipe", true, "Should the recipe for clearing all upgrades be avalible?");
        config.get("disenchanting", "FlatDamage", 10, "How much flat damage should be dealt to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamage", 0.025, "How much of the Item's maximal durability should be dealt as damage to Items when disenchanting?");
        config.get("disenchanting", "MaxDurabilityDamageReduceable", 0.2, "How much of the Item's maximal durability should be dealt as reduceable damage to Items when disenchanting?");
        config.get("disenchanting", "MachineDamageMultiplier", 2.5, "By how much should the dammage on the item be multiplied when using an automaic Disenchantment Table?");
        config.get("disenchanting", "EnchantmentLossChance", 0.0, "What should the probability be of additional enchantments being lost from Items when disenchanting?");
        config.get("disenchanting", "EnableTCBehaviour", true, "Should Items from Tinkers Construct be handeled differently? (banned / modifiers removed [in TC2])");
        config.get("disenchanting", "AutomaticDisenchantmentProcessTicks", 100, "How many ticks should a disenchantment process last when using an automaic Disenchantment Table?");
        config.save();
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTable.class, (String)"TileDisentchantmentTable");
        GameRegistry.registerTileEntity(TileEntityDisenchantmentTableAutomatic.class, (String)"TileDisentchantmentTableAutomatic");
    }

    public void load(FMLInitializationEvent ev) {
        if (DisenchanterMain.config.get("general", "CheckVersion", true).getBoolean()) {
            MinecraftForge.EVENT_BUS.register((Object)DisenchanterMain.versionChecker);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DisenchanterMain.instance, (IGuiHandler)new GUIHandler());
    }

    public void postInit(FMLPostInitializationEvent ev) {
    }

    public void registerBlocks(RegistryEvent.Register<Block> ev) {
        ev.getRegistry().register((IForgeRegistryEntry)disenchantmentTable);
    }

    public void registerItems(RegistryEvent.Register<Item> ev) {
        ev.getRegistry().register(itemDisenchantmentTable.setRegistryName(disenchantmentTable.getRegistryName()));
    }

    public void registerPotions(RegistryEvent.Register<Potion> ev) {
    }

    public void registerBiomes(RegistryEvent.Register<Biome> ev) {
    }

    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> ev) {
        ev.getRegistry().register((IForgeRegistryEntry)disenchantmentTableUse);
    }

    public void registerPotionTypes(RegistryEvent.Register<PotionType> ev) {
    }

    public void registerEnchantments(RegistryEvent.Register<Enchantment> ev) {
    }

    public void registerRecipes(RegistryEvent.Register<IRecipe> ev) {
        ItemStack table = new ItemStack(Item.func_150898_a((Block)disenchantmentTable), 1, Short.MAX_VALUE);
        ev.getRegistry().register(new ShapedOreRecipe(null, new ItemStack((Item)itemDisenchantmentTable, 1, 0), new Object[]{"   ", "YEY", "ETE", Character.valueOf('T'), Blocks.field_150381_bn, Character.valueOf('E'), "gemEmerald", Character.valueOf('Y'), "dyeYellow"}).setRegistryName(itemDisenchantmentTable.getRegistryName()));
        if (DisenchanterMain.config.get("general", "EnableAutomaticRecipe", true).getBoolean()) {
            ev.getRegistry().register(new UpgradeTableRecipe(BlockDisenchantmentTable.AUTOMATIC, new ItemStack((Item)itemDisenchantmentTable, 1, 1), "IMI", "BCB", "ITI", Character.valueOf('T'), table, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('B'), "dyeBlack", Character.valueOf('M'), Items.field_151132_bS).setRegistryName("disenchanter", "upgradetable_automatic"));
        }
        if (DisenchanterMain.config.get("general", "EnableBulkDisenchantingRecipe", true).getBoolean()) {
            ev.getRegistry().register(new UpgradeTableRecipe(BlockDisenchantmentTable.BULKDISENCHANTING, new ItemStack((Item)itemDisenchantmentTable, 1, 2), "QGQ", "GDG", "QTQ", Character.valueOf('T'), table, Character.valueOf('D'), "gemDiamond", Character.valueOf('Q'), "gemQuartz", Character.valueOf('G'), "ingotGold").setRegistryName("disenchanter", "upgradetable_bulkdisenchanting"));
        }
        if (DisenchanterMain.config.get("general", "EnableVoidingRecipe", true).getBoolean()) {
            ev.getRegistry().register(new UpgradeTableRecipe(BlockDisenchantmentTable.VOIDING, new ItemStack((Item)itemDisenchantmentTable, 1, 4), "POP", "EHE", "PTP", Character.valueOf('T'), table, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('P'), "dyePurple", Character.valueOf('O'), Blocks.field_150343_Z).setRegistryName("disenchanter", "upgradetable_voiding"));
        }
        if (DisenchanterMain.config.get("general", "EnableClearRecipe", true).getBoolean()) {
            ev.getRegistry().register(new ShapedOreRecipe(null, new ItemStack((Item)itemDisenchantmentTable, 1, 0), new Object[]{"PPP", "PTP", "PPP", Character.valueOf('T'), table, Character.valueOf('P'), Items.field_151121_aF}).setRegistryName("disenchanter", "clearupgrades"));
        }
    }

    public void registerVillagerProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> ev) {
    }

    public void registerEntityEntries(RegistryEvent.Register<EntityEntry> ev) {
    }
}

