/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.event;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.event.BlockUpdateEvent;

@SideOnly(value=Side.CLIENT)
public class WorldEventDetector
implements IWorldEventListener {
    protected final World world;

    public WorldEventDetector(@Nonnull World world) {
        this.world = world;
    }

    public void func_184376_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
        if (worldIn.field_73011_w.getDimension() == EnvironStateHandler.EnvironState.getDimensionId()) {
            BlockUpdateEvent event = new BlockUpdateEvent(worldIn, pos, oldState, newState, flags);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public void func_174959_b(@Nonnull BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player2, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player2, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }

    public void func_190570_a(int p_190570_1_, boolean p_190570_2_, boolean p_190570_3_, double p_190570_4_, double p_190570_6_, double p_190570_8_, double p_190570_10_, double p_190570_12_, double p_190570_14_, int ... p_190570_16_) {
    }

    @SubscribeEvent(receiveCanceled=false)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        try {
            event.getWorld().func_72954_a((IWorldEventListener)new WorldEventDetector(event.getWorld()));
        }
        catch (Throwable t) {
            ModBase.log().warn("Unable to add world listener - is world fake? [%s]", new Object[]{event.getWorld().getClass().getName()});
        }
    }
}

