/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.blockstate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.IDataAccessor;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;

public final class BlockStateUtil {
    @Nullable
    public static <T extends BlockStateData> T getStateData(@Nonnull IBlockState state) {
        IDataAccessor accessor = (IDataAccessor)state;
        BlockStateData result = (BlockStateData)accessor.getData();
        if (result == null) {
            RegistryManager.BLOCK.reload();
            result = (BlockStateData)accessor.getData();
            if (result == null) {
                ModBase.log().warn("Unable to find BlockStateData for state [%s]", new Object[]{state.toString()});
                result = BlockStateData.DEFAULT;
                accessor.setData(result);
            }
        }
        return (T)result;
    }

    static <T extends BlockStateData> T getStateDataRaw(@Nonnull IBlockState state) {
        return (T)((BlockStateData)((IDataAccessor)state).getData());
    }

    public static <T extends BlockStateData> void setStateData(@Nonnull IBlockState state, @Nonnull T data) {
        ((IDataAccessor)state).setData(data);
    }
}

