/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.texture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.BetterFoliageMod;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.betterfoliage.client.texture.IGrassRegistry;
import mods.octarinecore.client.render.HSB;
import mods.octarinecore.client.resource.LoadModelDataEvent;
import mods.octarinecore.client.resource.ModelVariant;
import mods.octarinecore.client.resource.TextureListModelProcessor;
import mods.octarinecore.client.resource.TextureMediatedRegistry;
import mods.octarinecore.client.resource.Utils;
import mods.octarinecore.common.config.ConfigurableBlockMatcher;
import mods.octarinecore.common.config.ModelTextureList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\u00020\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\bJ\u001b\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0096\u0002J3\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.H\u0096\u0002J&\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u00108\u001a\u000209H\u0016J&\u0010:\u001a\u00020;2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\u0006\u0010<\u001a\u00020\u00022\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010=\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00022\u0006\u00108\u001a\u000209R\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR,\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001dR,\u0010&\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0(0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010\u001d\u00a8\u0006>"}, d2={"Lmods/betterfoliage/client/texture/StandardGrassSupport;", "Lmods/octarinecore/client/resource/TextureListModelProcessor;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "Lmods/octarinecore/client/resource/TextureMediatedRegistry;", "", "", "Lmods/betterfoliage/client/texture/GrassInfo;", "Lmods/betterfoliage/client/texture/IGrassRegistry;", "()V", "logName", "getLogName", "()Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "matchClasses", "Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "getMatchClasses", "()Lmods/octarinecore/common/config/ConfigurableBlockMatcher;", "modelTextures", "Lmods/octarinecore/common/config/ModelTextureList;", "getModelTextures", "()Ljava/util/List;", "textureToValue", "", "getTextureToValue", "()Ljava/util/Map;", "setTextureToValue", "(Ljava/util/Map;)V", "variantToKey", "Lmods/octarinecore/client/resource/ModelVariant;", "getVariantToKey", "setVariantToKey", "variantToValue", "", "getVariantToValue", "setVariantToValue", "variants", "Lnet/minecraft/block/state/IBlockState;", "", "getVariants", "setVariants", "get", "state", "rand", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "face", "Lnet/minecraft/util/EnumFacing;", "processStitch", "variant", "key", "atlas", "Lnet/minecraft/client/renderer/texture/TextureMap;", "processTexture", "", "texture", "registerGrass", "BetterFoliage-MC1.12"})
public final class StandardGrassSupport
implements TextureListModelProcessor<TextureAtlasSprite>,
TextureMediatedRegistry<List<? extends String>, GrassInfo>,
IGrassRegistry {
    @NotNull
    private static Map<IBlockState, List<ModelVariant>> variants;
    @NotNull
    private static Map<ModelVariant, List<String>> variantToKey;
    @NotNull
    private static Map<ModelVariant, ? extends TextureAtlasSprite> variantToValue;
    @NotNull
    private static Map<TextureAtlasSprite, GrassInfo> textureToValue;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String logName = "StandardGrassSupport";
    public static final StandardGrassSupport INSTANCE;

    @Override
    @NotNull
    public Map<IBlockState, List<ModelVariant>> getVariants() {
        return variants;
    }

    @Override
    public void setVariants(@NotNull Map<IBlockState, List<ModelVariant>> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        variants = map2;
    }

    @Override
    @NotNull
    public Map<ModelVariant, List<String>> getVariantToKey() {
        return variantToKey;
    }

    @Override
    public void setVariantToKey(@NotNull Map<ModelVariant, List<String>> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        variantToKey = map2;
    }

    @Override
    @NotNull
    public Map<ModelVariant, TextureAtlasSprite> getVariantToValue() {
        return variantToValue;
    }

    @Override
    public void setVariantToValue(@NotNull Map<ModelVariant, ? extends TextureAtlasSprite> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        variantToValue = map2;
    }

    @Override
    @NotNull
    public Map<TextureAtlasSprite, GrassInfo> getTextureToValue() {
        return textureToValue;
    }

    @Override
    public void setTextureToValue(@NotNull Map<TextureAtlasSprite, GrassInfo> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        textureToValue = map2;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public String getLogName() {
        return logName;
    }

    @Override
    @NotNull
    public ConfigurableBlockMatcher getMatchClasses() {
        return Config.blocks.INSTANCE.getGrassClasses();
    }

    @Override
    @NotNull
    public List<ModelTextureList> getModelTextures() {
        return Config.blocks.INSTANCE.getGrassModels().getList();
    }

    @Override
    @Nullable
    public GrassInfo get(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face, int rand) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)face, (String)"face");
        ModelVariant modelVariant = this.getVariant(state, rand);
        if (modelVariant == null) {
            return null;
        }
        ModelVariant variant = modelVariant;
        TextureAtlasSprite textureAtlasSprite = this.getVariantToValue().get(variant);
        if (textureAtlasSprite == null) {
            return null;
        }
        TextureAtlasSprite baseTexture = textureAtlasSprite;
        GrassInfo grassInfo = this.getTextureToValue().get(OptifineCTM.INSTANCE.override(baseTexture, world, pos, face));
        if (grassInfo == null) {
            grassInfo = this.getTextureToValue().get(baseTexture);
        }
        return grassInfo;
    }

    @Override
    @Nullable
    public GrassInfo get(@NotNull IBlockState state, int rand) {
        TextureAtlasSprite textureAtlasSprite;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ModelVariant modelVariant = this.getVariant(state, rand);
        if (modelVariant == null) {
            return null;
        }
        ModelVariant variant = modelVariant;
        TextureAtlasSprite it = textureAtlasSprite = this.getVariantToValue().get(variant);
        return it == null ? null : INSTANCE.getTextureToValue().get(it);
    }

    @Override
    @NotNull
    public TextureAtlasSprite processStitch(@NotNull ModelVariant variant, @NotNull List<String> key, @NotNull TextureMap atlas) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)atlas, (String)"atlas");
        return Utils.registerSprite(atlas, key.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processTexture(@NotNull List<ModelVariant> variants, @NotNull TextureAtlasSprite texture, @NotNull TextureMap atlas) {
        Collection<IBlockState> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)atlas, (String)"atlas");
        this.registerGrass(texture, atlas);
        Iterable iterable = variants;
        OptifineCTM optifineCTM = OptifineCTM.INSTANCE;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ModelVariant modelVariant = (ModelVariant)item$iv$iv;
            collection = destination$iv$iv;
            IBlockState iBlockState = it.getState();
            collection.add(iBlockState);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv = optifineCTM.getAllCTM((List<? extends IBlockState>)collection, texture);
        for (Object element$iv : $receiver$iv) {
            TextureAtlasSprite it = (TextureAtlasSprite)element$iv;
            INSTANCE.registerGrass(it, atlas);
        }
    }

    public final void registerGrass(@NotNull TextureAtlasSprite texture, @NotNull TextureMap atlas) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)atlas, (String)"atlas");
        this.getLogger().log(Level.DEBUG, "" + this.getLogName() + ": texture " + texture.func_94215_i());
        Integer n2 = Utils.getAverageColor(texture);
        HSB hsb = HSB.Companion.fromColor(n2 != null ? n2 : 0);
        if ((double)hsb.getSaturation() >= Config.shortGrass.INSTANCE.getSaturationThreshold()) {
            this.getLogger().log(Level.DEBUG, "" + this.getLogName() + ":         brightness " + hsb.getBrightness());
            this.getLogger().log(Level.DEBUG, "" + this.getLogName() + ":         saturation " + hsb.getSaturation() + " >= " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using texture color");
            n = HSB.copy$default(hsb, 0.0f, 0.0f, Math.min(0.9f, hsb.getBrightness() * 2.0f), 3, null).getAsColor();
        } else {
            this.getLogger().log(Level.DEBUG, "" + this.getLogName() + ":         saturation " + hsb.getSaturation() + " < " + Config.shortGrass.INSTANCE.getSaturationThreshold() + ", using block color");
            n = null;
        }
        Integer overrideColor = n;
        Map<TextureAtlasSprite, GrassInfo> map2 = this.getTextureToValue();
        GrassInfo grassInfo = new GrassInfo(texture, overrideColor);
        map2.put(texture, grassInfo);
    }

    private StandardGrassSupport() {
    }

    static {
        StandardGrassSupport standardGrassSupport;
        INSTANCE = standardGrassSupport = new StandardGrassSupport();
        MinecraftForge.EVENT_BUS.register((Object)standardGrassSupport);
        variants = new LinkedHashMap();
        variantToKey = new LinkedHashMap();
        variantToValue = MapsKt.emptyMap();
        textureToValue = new LinkedHashMap();
        logger = BetterFoliageMod.INSTANCE.getLogDetail();
        logName = logName;
    }

    @Override
    public void onPreStitch() {
        TextureListModelProcessor.DefaultImpls.onPreStitch(this);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void clearBeforeLoadModelData(@NotNull LoadModelDataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        TextureListModelProcessor.DefaultImpls.clearBeforeLoadModelData(this, event);
    }

    @Override
    public void addVariant(@NotNull IBlockState state, @NotNull ModelVariant variant) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        TextureListModelProcessor.DefaultImpls.addVariant(this, state, variant);
    }

    @Override
    public void processModelLoad(@NotNull IBlockState state, @NotNull ModelResourceLocation modelLoc, @NotNull IModel model) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)modelLoc, (String)"modelLoc");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        TextureListModelProcessor.DefaultImpls.processModelLoad(this, state, modelLoc, model);
    }

    @Override
    @SubscribeEvent
    public void handleLoadModelData(@NotNull LoadModelDataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        TextureListModelProcessor.DefaultImpls.handleLoadModelData(this, event);
    }

    @Override
    public void putKeySingle(@NotNull IBlockState state, @NotNull List<String> key) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        TextureListModelProcessor.DefaultImpls.putKeySingle(this, state, key);
    }

    @Override
    public void onPostLoad() {
        TextureListModelProcessor.DefaultImpls.onPostLoad(this);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOW)
    public void handlePreStitch(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        TextureMediatedRegistry.DefaultImpls.handlePreStitch(this, event);
    }

    @Override
    @Nullable
    public ModelVariant getVariant(@NotNull IBlockState state, int rand) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return TextureListModelProcessor.DefaultImpls.getVariant(this, state, rand);
    }
}

