/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.capability.RLCapabilities;
import com.charles445.rltweaker.capability.TweakerProvider;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.network.MessageUpdateDismountStatus;
import com.charles445.rltweaker.network.MessageUpdateEntityMovement;
import com.charles445.rltweaker.network.PacketHandler;
import com.charles445.rltweaker.network.TaskScheduler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MinecraftHandler {
    public MinecraftHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("rltweaker", "tweaker"), (ICapabilityProvider)new TweakerProvider(RLCapabilities.TWEAKER));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientScheduled(TickEvent.ClientTickEvent event) {
        TaskScheduler.processClientTick(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDismount(EntityMountEvent event) {
        World world = event.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.server.minecraft.playerDismountSync && event.isDismounting() && event.getEntityMounting() instanceof EntityPlayerMP && event.getEntityBeingMounted() != null) {
            MessageUpdateDismountStatus message = new MessageUpdateDismountStatus();
            PacketHandler.instance.sendTo((IMessage)message, (EntityPlayerMP)event.getEntityMounting());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorldLowest(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            this.handleArrowJoinWorld((EntityArrow)event.getEntity());
        }
    }

    private void handleArrowJoinWorld(EntityArrow arrow) {
        World world = arrow.func_130014_f_();
        if (!world.field_72995_K && ModConfig.server.minecraft.playerArrowSync && arrow.field_70250_c instanceof EntityPlayer) {
            MessageUpdateEntityMovement message = new MessageUpdateEntityMovement((Entity)arrow);
            PacketHandler.instance.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, 24.0));
        }
    }
}

