/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.debug.DebugUtil;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MotionCheckHandler {
    public Set<UUID> rotationErrors = new HashSet<UUID>();
    public Set<UUID> motionErrors = new HashSet<UUID>();

    public MotionCheckHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingUpdateHighest(LivingEvent.LivingUpdateEvent event) {
        this.handleLivingUpdate(event, EventPriority.HIGHEST);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingUpdateHigh(LivingEvent.LivingUpdateEvent event) {
        this.handleLivingUpdate(event, EventPriority.HIGH);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingUpdateNormal(LivingEvent.LivingUpdateEvent event) {
        this.handleLivingUpdate(event, EventPriority.NORMAL);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingUpdateLow(LivingEvent.LivingUpdateEvent event) {
        this.handleLivingUpdate(event, EventPriority.LOW);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingUpdateLowest(LivingEvent.LivingUpdateEvent event) {
        this.handleLivingUpdate(event, EventPriority.LOWEST);
    }

    private void handleLivingUpdate(LivingEvent.LivingUpdateEvent event, EventPriority priority) {
        if (!ModConfig.server.minecraft.motionChecker) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (this.testMotion(entity.field_70159_w, entity, priority)) {
            entity.field_70159_w = 0.0;
            event.setCanceled(true);
            entity.field_70133_I = true;
        }
        if (this.testMotion(entity.field_70181_x, entity, priority)) {
            entity.field_70181_x = 0.0;
            event.setCanceled(true);
            entity.field_70133_I = true;
        }
        if (this.testMotion(entity.field_70179_y, entity, priority)) {
            entity.field_70179_y = 0.0;
            event.setCanceled(true);
            entity.field_70133_I = true;
        }
        if (this.testAngle(entity.field_70125_A, entity, priority)) {
            this.fixAngle(entity);
        } else if (this.testAngle(entity.field_70177_z, entity, priority)) {
            this.fixAngle(entity);
        }
    }

    private void fixAngle(EntityLivingBase entity) {
        entity.field_70125_A = 0.0f;
        entity.field_70177_z = 0.0f;
    }

    private boolean testAngle(float angle, EntityLivingBase entity, EventPriority priority) {
        if (!Float.isFinite(angle)) {
            if (!this.rotationErrors.contains(entity.func_110124_au())) {
                this.rotationErrors.add(entity.func_110124_au());
                RLTweaker.logger.error("Entity has bad rotation! " + priority.name() + " " + angle + " " + this.dumpEntity(entity));
                ErrorUtil.logSilent("Motion Checker Angle " + priority.name());
                if (ModConfig.server.minecraft.debug) {
                    DebugUtil.messageAll("Entity has bad angles! " + priority.name() + " " + angle);
                }
            }
            return true;
        }
        return false;
    }

    private boolean testMotion(double motion, EntityLivingBase entity, EventPriority priority) {
        if (motion > ModConfig.server.minecraft.motionCheckerSpeedCap || motion < -ModConfig.server.minecraft.motionCheckerSpeedCap || !Double.isFinite(motion)) {
            if (!this.motionErrors.contains(entity.func_110124_au())) {
                this.motionErrors.add(entity.func_110124_au());
                RLTweaker.logger.error("Entity moving too fast! " + priority.name() + " " + motion + " " + this.dumpEntity(entity));
                ErrorUtil.logSilent("Motion Checker Speed " + priority.name());
                if (ModConfig.server.minecraft.debug) {
                    DebugUtil.messageAll("Entity moving too fast! " + priority.name() + " " + motion);
                }
            }
            return true;
        }
        return false;
    }

    private String dumpEntity(EntityLivingBase entity) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity.getClass().getName());
        sb.append(" - ");
        sb.append(entity.field_70165_t);
        sb.append(" ");
        sb.append(entity.field_70163_u);
        sb.append(" ");
        sb.append(entity.field_70161_v);
        sb.append(" ");
        sb.append(entity.field_70159_w);
        sb.append(" ");
        sb.append(entity.field_70181_x);
        sb.append(" ");
        sb.append(entity.field_70179_y);
        sb.append(" hurt time:");
        sb.append(entity.field_70737_aN);
        sb.append(" dead:");
        sb.append(entity.field_70128_L);
        sb.append(" pitch:");
        sb.append(entity.field_70125_A);
        sb.append(" yaw:");
        sb.append(entity.field_70177_z);
        if (entity instanceof EntityLiving) {
            EntityLivingBase attack;
            EntityLivingBase revenge;
            EntityLiving living = (EntityLiving)entity;
            DamageSource damagesource = living.func_189748_bU();
            if (damagesource != null) {
                sb.append(" damagesource class:");
                sb.append(damagesource.getClass().getName());
            }
            if ((revenge = living.func_70643_av()) != null) {
                sb.append(" revenge target class:");
                sb.append(revenge.getClass().getName());
            }
            if ((attack = living.func_70638_az()) != null) {
                sb.append(" attack target class:");
                sb.append(attack.getClass().getName());
            }
        }
        return sb.toString();
    }
}

