/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.SMEReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SMEHandler {
    public static long protectCounter = 0L;
    private SMEReflect reflector;

    public SMEHandler() {
        block2: {
            try {
                this.reflector = new SMEReflect();
                this.tryRegister(AdvancedMending.class, "advancedmending", this.reflector.c_Enchantmentadvancedmending, this.reflector.m_Enchantmentadvancedmending_handler, ModConfig.server.somanyenchantments.manageAdvancedMending);
                this.tryRegister(ArcSlash.class, "swiper", this.reflector.c_EnchantmentSwiper, this.reflector.m_EnchantmentSwiper_handler, ModConfig.server.somanyenchantments.manageArcSlash);
                this.tryRegister(CurseOfPossession.class, "CurseofPossession", this.reflector.c_EnchantmentCurseofPossession, this.reflector.m_EnchantmentCurseofPossession_onExist, ModConfig.server.somanyenchantments.manageCurseOfPossession);
                this.tryRegister(EmpoweredDefence.class, "empowereddefence", this.reflector.c_EnchantmentEmpoweredDefence, this.reflector.m_EnchantmentEmpoweredDefence_handler, ModConfig.server.somanyenchantments.manageEmpoweredDefence);
                this.tryRegister(Evasion.class, "evasion", this.reflector.c_EnchantmentEvasion, this.reflector.m_EnchantmentEvasion_handler, ModConfig.server.somanyenchantments.manageEvasion);
                this.tryRegister(Freezing.class, "freezing", this.reflector.c_EnchantmentFreezing, this.reflector.m_EnchantmentFreezing_handler, ModConfig.server.somanyenchantments.manageFreezing);
                this.tryRegister(Parry.class, "parry", this.reflector.c_EnchantmentParry, this.reflector.m_EnchantmentParry_handler, ModConfig.server.somanyenchantments.manageParry);
                this.tryRegister(Unreasonable.class, "frenzy", this.reflector.c_EnchantmentFrenzy, this.reflector.m_EnchantmentFrenzy_handler, ModConfig.server.somanyenchantments.manageUnreasonable);
                this.tryRegister(UpgradedPotentials.class, "upgrade", this.reflector.c_EnchantmentUpgradedPotentials, this.reflector.m_EnchantmentUpgradedPotentials_handler, ModConfig.server.somanyenchantments.manageUpgradedPotentials);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup SMEHandler!", (Throwable)e);
                ErrorUtil.logSilent("SME Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    private void tryRegister(Class toRegisterClazz, String enchName, Class reflectorClazz, Method reflectorMethod, boolean config) throws Exception {
        Object handler;
        if (config && (handler = CompatUtil.findAndRemoveHandlerFromEventBus(reflectorClazz)) != null) {
            RLTweaker.logger.info("Registering " + toRegisterClazz.getName() + " to the event bus");
            MinecraftForge.EVENT_BUS.register(toRegisterClazz.getConstructor(this.getClass(), Object.class, String.class, Method.class).newInstance(this, handler, enchName, reflectorMethod));
        }
    }

    private Enchantment getEnchantment(String name) {
        ResourceLocation loc = new ResourceLocation("somanyenchantments", name);
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(loc);
        if (enchantment == null) {
            RLTweaker.logger.error("Failed to find enchantment " + loc);
        }
        return enchantment;
    }

    private abstract class Wrapper {
        protected final Object handler;
        protected final Enchantment enchantment;
        protected final Method original;

        public Wrapper(Object handler, String ench, Method original) {
            this.handler = handler;
            this.enchantment = SMEHandler.this.getEnchantment(ench);
            this.original = original;
        }

        protected void invokeOriginal(Event event) throws Exception {
            this.original.invoke(this.handler, event);
        }

        protected void protectMotion(Entity a, Entity b) {
            if (!(Double.isFinite(a.field_70159_w) && Double.isFinite(a.field_70181_x) && Double.isFinite(a.field_70179_y))) {
                a.field_70159_w = 0.0;
                a.field_70181_x = 0.0;
                a.field_70179_y = 0.0;
                a.field_70133_I = true;
                ++protectCounter;
                ErrorUtil.logEnchantmentError(this.enchantment);
            }
            if (!(Double.isFinite(b.field_70159_w) && Double.isFinite(b.field_70181_x) && Double.isFinite(b.field_70179_y))) {
                b.field_70159_w = 0.0;
                b.field_70181_x = 0.0;
                b.field_70179_y = 0.0;
                b.field_70133_I = true;
                ++protectCounter;
                ErrorUtil.logEnchantmentError(this.enchantment);
            }
        }
    }

    public class UpgradedPotentials
    extends Wrapper {
        public UpgradedPotentials(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent
        public void upgradedPotentialsEnchant(AnvilUpdateEvent event) {
            Map enchantments;
            ItemStack left = event.getLeft();
            ItemStack right = event.getRight();
            if (left.func_190926_b() || right.func_190926_b()) {
                return;
            }
            if (right.func_77973_b() == Items.field_151134_bR && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)right)).containsKey(this.enchantment) && (Integer)enchantments.get(this.enchantment) >= 1) {
                if (left.func_77985_e()) {
                    event.setOutput(ItemStack.field_190927_a);
                    return;
                }
                if (EnchantmentHelper.func_82781_a((ItemStack)left).size() == 0) {
                    event.setOutput(ItemStack.field_190927_a);
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)left) >= 1) {
                    event.setOutput(ItemStack.field_190927_a);
                    return;
                }
                int cost = left.func_82838_A();
                cost = Math.max(0, cost / 4 - 20);
                ItemStack output = left.func_77946_l();
                output.func_82841_c(cost);
                output.func_77966_a(this.enchantment, 1);
                event.setOutput(output);
                event.setCost(10);
            }
        }
    }

    public class Unreasonable
    extends Wrapper {
        public Unreasonable(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void unreasonableEnchant(LivingAttackEvent event) {
            try {
                if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
                    return;
                }
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
                ItemStack weapon = attacker.func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)weapon) <= 0) {
                    return;
                }
                this.invokeOriginal((Event)event);
                if (event.isCanceled()) {
                    event.setCanceled(false);
                    EntityLivingBase victim = event.getEntityLiving();
                    if (victim.func_110138_aP() > victim.func_110143_aJ()) {
                        return;
                    }
                    EntityLivingBase revenge = victim.func_70643_av();
                    if (revenge == null) {
                        return;
                    }
                    World world = victim.func_130014_f_();
                    if (world instanceof WorldServer) {
                        ((WorldServer)world).func_152344_a(() -> {
                            try {
                                if (victim != null && attacker != null && revenge != null && !victim.field_70128_L && victim instanceof EntityLiving && !victim.func_110124_au().equals(revenge.func_110124_au())) {
                                    EntityLiving victimLiving = (EntityLiving)victim;
                                    victimLiving.func_70604_c(revenge);
                                    victimLiving.func_70624_b(revenge);
                                }
                            }
                            catch (Exception e) {
                                RLTweaker.logger.error("Error in scheduled Unreasonable task", (Throwable)e);
                                ErrorUtil.logSilent("Unreasonable Scheduled");
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in Unreasonable Invoke");
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class Parry
    extends Wrapper {
        public Parry(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
        public void parryEnchant(LivingAttackEvent event) {
            try {
                EntityLivingBase victim = event.getEntityLiving();
                ItemStack weapon = victim.func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)weapon) <= 0) {
                    return;
                }
                Entity attacker = event.getSource().func_76346_g();
                if (attacker == null) {
                    return;
                }
                this.invokeOriginal((Event)event);
                this.protectMotion((Entity)victim, attacker);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in Parry Invoke");
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class Freezing
    extends Wrapper {
        public Freezing(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void freezingEnchant(LivingDamageEvent event) {
            try {
                if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
                    return;
                }
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
                ItemStack weapon = attacker.func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)weapon) <= 0) {
                    return;
                }
                this.invokeOriginal((Event)event);
                EntityLivingBase victim = event.getEntityLiving();
                this.protectMotion((Entity)victim, (Entity)attacker);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in Freezing Invoke", (Throwable)e);
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class Evasion
    extends Wrapper {
        public Evasion(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void evasionEnchant(LivingAttackEvent event) {
            try {
                EntityLivingBase victim = event.getEntityLiving();
                if (EnchantmentHelper.func_185284_a((Enchantment)this.enchantment, (EntityLivingBase)victim) <= 0) {
                    return;
                }
                Entity attacker = event.getSource().func_76346_g();
                if (attacker == null) {
                    return;
                }
                this.invokeOriginal((Event)event);
                this.protectMotion((Entity)victim, attacker);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in Evasion Invoke", (Throwable)e);
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class EmpoweredDefence
    extends Wrapper {
        public EmpoweredDefence(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void empoweredDefenceEnchant(LivingAttackEvent event) {
            try {
                EntityLivingBase victim = event.getEntityLiving();
                ItemStack shield = victim.func_184592_cb();
                if (shield.func_190926_b()) {
                    shield = victim.func_184614_ca();
                }
                if (shield.func_190926_b()) {
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)shield) <= 0) {
                    return;
                }
                Entity attacker = event.getSource().func_76346_g();
                if (attacker == null) {
                    return;
                }
                this.invokeOriginal((Event)event);
                this.protectMotion((Entity)victim, attacker);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in EmpoweredDefence Invoke", (Throwable)e);
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class CurseOfPossession
    extends Wrapper {
        private final Method onExist;
        private final Method toss;
        private final Map<Integer, Integer> dimensionMap;

        public CurseOfPossession(Object handler, String ench, Method original) {
            super(handler, ench, original);
            this.onExist = ((SMEHandler)SMEHandler.this).reflector.m_EnchantmentCurseofPossession_onExist;
            this.toss = ((SMEHandler)SMEHandler.this).reflector.m_EnchantmentCurseofPossession_toss;
            this.dimensionMap = new HashMap<Integer, Integer>();
        }

        @SubscribeEvent
        public void onExist(TickEvent.WorldTickEvent event) {
            int dimCount;
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            int dimension = event.world.field_73011_w.getDimension();
            Integer dimensionCounterObj = this.dimensionMap.get(dimension);
            int n = dimCount = dimensionCounterObj == null ? 0 : dimensionCounterObj;
            if (++dimCount >= ModConfig.server.somanyenchantments.curseOfPossessionDelay) {
                this.dimensionMap.put(dimension, 0);
                try {
                    this.onExist.invoke(this.handler, event);
                }
                catch (Exception e) {
                    RLTweaker.logger.error("Error in CurseOfPossession onExist Invoke", (Throwable)e);
                    ErrorUtil.logEnchantmentHandlerError(this.enchantment);
                }
            } else {
                this.dimensionMap.put(dimension, dimCount);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void toss(ItemTossEvent event) {
            try {
                this.toss.invoke(this.handler, event);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in CurseOfPossession toss Invoke", (Throwable)e);
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class ArcSlash
    extends Wrapper {
        public ArcSlash(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
        public void arcSlashEnchant(LivingDamageEvent event) {
            try {
                Entity attacker = event.getSource().func_76346_g();
                if (!(attacker instanceof EntityLivingBase)) {
                    return;
                }
                ItemStack weapon = ((EntityLivingBase)attacker).func_184614_ca();
                if (weapon.func_190926_b()) {
                    return;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)weapon) <= 0) {
                    return;
                }
                this.invokeOriginal((Event)event);
                this.protectMotion((Entity)event.getEntityLiving(), attacker);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Error in ArcSlash Invoke", (Throwable)e);
                ErrorUtil.logEnchantmentHandlerError(this.enchantment);
            }
        }
    }

    public class AdvancedMending
    extends Wrapper {
        public AdvancedMending(Object handler, String ench, Method original) {
            super(handler, ench, original);
        }

        @SubscribeEvent
        public void advancedMendingEnchant(PlayerPickupXpEvent event) {
            ItemStack itemstack;
            EntityPlayer player = event.getEntityPlayer();
            EntityXPOrb orb = event.getOrb();
            if (ModConfig.server.somanyenchantments.advancedMendingDoubleXP && orb.field_70530_e > 0) {
                player.func_71023_q(orb.field_70530_e);
            }
            if (!(itemstack = EnchantmentHelper.func_92099_a((Enchantment)this.enchantment, (EntityLivingBase)player)).func_190926_b() && itemstack.func_77951_h()) {
                int value = Math.min(orb.field_70530_e * 3, itemstack.func_77952_i());
                itemstack.func_77964_b(itemstack.func_77952_i() - value);
                orb.field_70530_e -= value / 2;
                if (orb.field_70530_e < 0) {
                    orb.field_70530_e = 0;
                }
            }
        }
    }
}

