/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CriticalException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CompatUtil {
    private static CompatUtil instance;
    private final Class c_EventBus = Class.forName("net.minecraftforge.fml.common.eventhandler.EventBus");
    private final Method m_register = this.c_EventBus.getDeclaredMethod("register", Class.class, Object.class, Method.class, ModContainer.class);
    private final Field f_listeners;
    private final Field f_busID;

    public CompatUtil() throws Exception {
        this.m_register.setAccessible(true);
        this.f_listeners = this.c_EventBus.getDeclaredField("listeners");
        this.f_listeners.setAccessible(true);
        this.f_busID = this.c_EventBus.getDeclaredField("busID");
        this.f_busID.setAccessible(true);
    }

    public static void subscribeEventManually(Class<?> clazz, Object thiz, Method thiz_toCall) throws Exception {
        if (instance == null) {
            instance = new CompatUtil();
        }
        if (!thiz_toCall.isAnnotationPresent(SubscribeEvent.class)) {
            throw new RuntimeException("Method needs a SubscribeEvent annotation.");
        }
        CompatUtil.instance.m_register.invoke((Object)MinecraftForge.EVENT_BUS, clazz, thiz, thiz_toCall, Loader.instance().getMinecraftModContainer());
        RLTweaker.logger.info("Registered " + thiz.getClass().getName() + " " + thiz_toCall.getName() + " to the event bus");
    }

    @Nullable
    public static Object getModInstance(String modid) {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            if (!modContainer.getModId().equals(modid)) continue;
            return modContainer.getMod();
        }
        RLTweaker.logger.warn("Asked to find mod instance " + modid + ", but could not find it!");
        return null;
    }

    @Nullable
    public static Object findAndRemoveHandlerFromEventBus(Class clazz) throws Exception {
        return CompatUtil.findAndRemoveHandlerFromEventBus(clazz.getName());
    }

    @Nullable
    public static Object findAndRemoveHandlerFromEventBus(String name) throws Exception {
        return CompatUtil.findAndRemoveHandlerFromEventBus(name, null);
    }

    @Nullable
    public static Object findAndRemoveHandlerFromEventBus(String name, @Nullable String specific) throws Exception {
        boolean criticalCrash = false;
        try {
            if (instance == null) {
                instance = new CompatUtil();
            }
            boolean found_listener = false;
            ConcurrentHashMap listeners = (ConcurrentHashMap)CompatUtil.instance.f_listeners.get(MinecraftForge.EVENT_BUS);
            RLTweaker.logger.debug("Listener Size: " + listeners.size());
            Object handler = null;
            for (Map.Entry listener_entry : listeners.entrySet()) {
                ArrayList eventListeners;
                handler = listener_entry.getKey();
                if (!handler.getClass().getName().equals(name)) continue;
                if (ModConfig.server.minecraft.debug) {
                    eventListeners = (ArrayList)listener_entry.getValue();
                    if (eventListeners == null) {
                        RLTweaker.logger.debug("eventListeners: null");
                    } else {
                        for (IEventListener eventListener : eventListeners) {
                            RLTweaker.logger.debug(eventListener.toString());
                        }
                    }
                }
                found_listener = true;
                if (specific == null) {
                    MinecraftForge.EVENT_BUS.unregister(handler);
                    RLTweaker.logger.info("Found and removed " + name + " from the event bus");
                    RLTweaker.logger.debug("Listener Size Post Unregister: " + listeners.size());
                    return handler;
                }
                eventListeners = (ArrayList)listener_entry.getValue();
                RLTweaker.logger.debug("EventListener Size Pre Unregister: " + eventListeners.size());
                Iterator elIterator = eventListeners.iterator();
                while (elIterator.hasNext()) {
                    IEventListener eventListener;
                    eventListener = (IEventListener)elIterator.next();
                    if (!eventListener.toString().contains(specific)) continue;
                    criticalCrash = true;
                    elIterator.remove();
                    RLTweaker.logger.debug("EventListener Size Post Unregister: " + eventListeners.size());
                    int busID = CompatUtil.instance.f_busID.getInt(MinecraftForge.EVENT_BUS);
                    ListenerList.unregisterAll((int)busID, (IEventListener)eventListener);
                    RLTweaker.logger.info("Found and removed " + name + " IEventListener " + specific + " from the event bus");
                    return handler;
                }
                break block2;
            }
            return null;
        }
        catch (Exception e) {
            if (criticalCrash) {
                throw new CriticalException(e);
            }
            throw e;
        }
    }
}

