/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals;

import com.sonicjumper.enhancedvisuals.EnhancedVisualsServer;
import com.sonicjumper.enhancedvisuals.addon.igcm.IGCMLoader;
import com.sonicjumper.enhancedvisuals.death.DeathMessages;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enhancedvisuals", name="Enhanced Visuals", acceptedMinecraftVersions="")
public class EnhancedVisuals {
    public static final String modid = "enhancedvisuals";
    public static final String name = "Enhanced Visuals";
    public static final String version = "1.2.0";
    public static Logger log = LogManager.getLogger((String)"enhancedvisuals");
    @SidedProxy(clientSide="com.sonicjumper.enhancedvisuals.EnhancedVisualsClient", serverSide="com.sonicjumper.enhancedvisuals.EnhancedVisualsServer")
    public static EnhancedVisualsServer proxy;
    public static boolean noEffectsForCreative;

    @Mod.EventHandler
    public void init(FMLLoadCompleteEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        noEffectsForCreative = config.getBoolean("noEffectsForCreative", "general", noEffectsForCreative, "If players in creative mod should have effects");
        VisualType.onLoad();
        for (int i = 0; i < VisualCategory.values().length; ++i) {
            VisualCategory category = VisualCategory.values()[i];
            for (int j = 0; j < category.types.size(); ++j) {
                category.types.get(j).initConfig(config);
            }
        }
        for (VisualHandler handler : VisualHandler.getAllHandlers()) {
            handler.initConfig(config);
        }
        VisualHandler.afterInit();
        DeathMessages.loadConfig(config);
        config.save();
        if (Loader.isModLoaded((String)"igcm")) {
            IGCMLoader.initConfiguration();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.load(event);
    }

    static {
        noEffectsForCreative = false;
    }
}

