/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class DamageHandler
extends VisualHandler {
    public final ArrayList<Item> sharpList = new ArrayList();
    public final ArrayList<Item> bluntList = new ArrayList();
    public final ArrayList<Item> pierceList = new ArrayList();
    public static boolean hitEffect = false;
    public static float hitEffectIntensity = 1.0f;
    public static int hitEffectMinDuration = 1;
    public static int hitEffectMaxDuration = 10;
    public int fireSplashes = 1;
    public int fireMinDuration = 100;
    public int fireMaxDuration = 1000;
    public int drownSplashes = 4;
    public int drownMinDuration = 10;
    public int drownMaxDuration = 15;
    public int bloodDurationMin = 500;
    public int bloodDurationMax = 1500;

    public DamageHandler() {
        super("damage", "when the player is taking damage");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.sharpList.add(Items.field_151040_l);
        this.sharpList.add(Items.field_151041_m);
        this.sharpList.add(Items.field_151052_q);
        this.sharpList.add(Items.field_151048_u);
        this.sharpList.add(Items.field_151010_B);
        this.sharpList.add(Items.field_151036_c);
        this.sharpList.add(Items.field_151053_p);
        this.sharpList.add(Items.field_151049_t);
        this.sharpList.add(Items.field_151056_x);
        this.sharpList.add(Items.field_151006_E);
        this.bluntList.add(Items.field_151035_b);
        this.bluntList.add(Items.field_151039_o);
        this.bluntList.add(Items.field_151050_s);
        this.bluntList.add(Items.field_151046_w);
        this.bluntList.add(Items.field_151005_D);
        this.bluntList.add(Items.field_151037_a);
        this.bluntList.add(Items.field_151038_n);
        this.bluntList.add(Items.field_151051_r);
        this.bluntList.add(Items.field_151047_v);
        this.bluntList.add(Items.field_151011_C);
        this.pierceList.add(Items.field_151019_K);
        this.pierceList.add(Items.field_151017_I);
        this.pierceList.add(Items.field_151018_J);
        this.pierceList.add(Items.field_151012_L);
        this.pierceList.add(Items.field_151013_M);
        this.pierceList.add(Items.field_151032_g);
        hitEffect = config.getBoolean("hitEffect", this.name, hitEffect, "Red overlay effect once you get hit");
        hitEffectIntensity = config.getFloat("hitEffectIntensity", this.name, hitEffectIntensity, 0.0f, 1.0f, "Intensity of red overlay");
        hitEffectMinDuration = config.getInt("hitEffectMinDuration", this.name, hitEffectMinDuration, 1, 100000, "min duration of hit effect");
        hitEffectMaxDuration = config.getInt("hitEffectMaxDuration", this.name, hitEffectMaxDuration, 1, 100000, "max duration of hit effect");
        this.fireSplashes = config.getInt("fireSplashes", this.name, this.fireSplashes, 0, 10000, "splashes per tick");
        this.fireMinDuration = config.getInt("fireMinDuration", this.name, this.fireMinDuration, 1, 10000, "min duration of one particle");
        this.fireMaxDuration = config.getInt("fireMaxDuration", this.name, this.fireMaxDuration, 1, 10000, "max duration of one particle");
        this.drownSplashes = config.getInt("drownSplashes", this.name, this.drownSplashes, 0, 10000, "splashes per hit");
        this.drownMinDuration = config.getInt("drownMinDuration", this.name, this.drownMinDuration, 1, 10000, "min duration of one splash");
        this.drownMaxDuration = config.getInt("drownMaxDuration", this.name, this.drownMaxDuration, 1, 10000, "max duration of one splash");
        this.bloodDurationMin = config.getInt("bloodDurationMin", this.name, this.bloodDurationMin, 1, 100000, "min duration of blood splash");
        this.bloodDurationMax = config.getInt("bloodDurationMax", this.name, this.bloodDurationMax, 1, 100000, "max duration of blood splash");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("hitEffect", (ConfigElement)new BooleanSegment("hitEffect", Boolean.valueOf(false)).setToolTip(new String[]{"Red overlay effect once you get hit"}));
        branch.registerElement("hitEffectIntensity", (ConfigElement)new FloatSegment("hitEffectIntensity", Float.valueOf(1.0f), 0.0f, 1.0f).setToolTip(new String[]{"Intensity of red overlay"}));
        branch.registerElement("hitEffectMinDuration", (ConfigElement)new IntegerSegment("hitEffectMinDuration", Integer.valueOf(1), 1, 10000).setToolTip(new String[]{"min duration of hit effect"}));
        branch.registerElement("hitEffectMaxDuration", (ConfigElement)new IntegerSegment("hitEffectMaxDuration", Integer.valueOf(10), 1, 10000).setToolTip(new String[]{"max duration of hit effecte"}));
        branch.registerElement("fireSplashes", (ConfigElement)new IntegerSegment("fireSplashes", Integer.valueOf(1), 0, 10000).setToolTip(new String[]{"splashes per tick"}));
        branch.registerElement("fireMinDuration", (ConfigElement)new IntegerSegment("fireMinDuration", Integer.valueOf(100), 0, 10000).setToolTip(new String[]{"min duration of one particle"}));
        branch.registerElement("fireMaxDuration", (ConfigElement)new IntegerSegment("fireMaxDuration", Integer.valueOf(1000), 0, 10000).setToolTip(new String[]{"max duration of one particle"}));
        branch.registerElement("drownSplashes", (ConfigElement)new IntegerSegment("drownSplashes", Integer.valueOf(4), 0, 10000).setToolTip(new String[]{"splashes per tick"}));
        branch.registerElement("drownMinDuration", (ConfigElement)new IntegerSegment("drownMinDuration", Integer.valueOf(10), 0, 10000).setToolTip(new String[]{"min duration of one splash"}));
        branch.registerElement("drownMaxDuration", (ConfigElement)new IntegerSegment("drownMaxDuration", Integer.valueOf(15), 0, 10000).setToolTip(new String[]{"max duration of one splash"}));
        branch.registerElement("bloodDurationMin", (ConfigElement)new IntegerSegment("bloodDurationMin", Integer.valueOf(500), 0, 100000).setToolTip(new String[]{"min duration of blood slpash"}));
        branch.registerElement("bloodDurationMax", (ConfigElement)new IntegerSegment("bloodDurationMax", Integer.valueOf(1500), 0, 100000).setToolTip(new String[]{"max duration of blood slpash"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        hitEffect = (Boolean)branch.getValue("hitEffect");
        hitEffectIntensity = ((Float)branch.getValue("hitEffectIntensity")).floatValue();
        hitEffectMinDuration = (Integer)branch.getValue("hitEffectMinDuration");
        hitEffectMaxDuration = (Integer)branch.getValue("hitEffectMaxDuration");
        this.fireSplashes = (Integer)branch.getValue("fireSplashes");
        this.fireMinDuration = (Integer)branch.getValue("fireMinDuration");
        this.fireMaxDuration = (Integer)branch.getValue("fireMaxDuration");
        this.drownSplashes = (Integer)branch.getValue("drownSplashes");
        this.drownMinDuration = (Integer)branch.getValue("drownMinDuration");
        this.drownMaxDuration = (Integer)branch.getValue("drownMaxDuration");
        this.bloodDurationMin = (Integer)branch.getValue("bloodDurationMin");
        this.bloodDurationMax = (Integer)branch.getValue("bloodDurationMax");
    }

    @Override
    public void onPlayerDamaged(EntityPlayer player, DamageSource source, float damage) {
        Entity attacker = source.func_76364_f();
        double distanceSq = 1.0;
        if (attacker instanceof EntityArrow) {
            VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
        }
        if (attacker instanceof EntityLivingBase) {
            EntityLivingBase lastAttacker = (EntityLivingBase)attacker;
            if (lastAttacker.func_184614_ca() != null) {
                if (this.isSharp(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.slash, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
                } else if (this.isBlunt(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.impact, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
                } else if (this.isPierce(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
                } else {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.splatter, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
                }
            } else if (lastAttacker instanceof EntityZombie || lastAttacker instanceof EntitySkeleton || lastAttacker instanceof EntityOcelot) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.slash, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
            } else if (lastAttacker instanceof EntityGolem || lastAttacker instanceof EntityPlayer) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.impact, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
            } else if (lastAttacker instanceof EntityWolf || lastAttacker instanceof EntitySpider) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
            }
        }
        if (source == DamageSource.field_76367_g) {
            VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
        }
        if (source == DamageSource.field_76379_h || source == DamageSource.field_82729_p) {
            VisualManager.createVisualFromDamageAndDistance(VisualType.impact, damage, (EntityLivingBase)player, distanceSq, this.bloodDurationMin, this.bloodDurationMax);
        }
        if (source.equals(DamageSource.field_76369_e)) {
            VisualManager.addVisualsWithShading(VisualType.waterS, 1.0f, this.drownSplashes, this.drownMinDuration, this.drownMaxDuration, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        }
        if (source.func_76347_k() || source == DamageSource.field_76370_b) {
            VisualManager.addVisualsWithShading(VisualType.fire, 1.0f, this.fireSplashes, this.fireMinDuration, this.fireMaxDuration, new Color(1, 1, 1));
        }
    }

    private boolean isSharp(Item item) {
        return this.sharpList.contains(item);
    }

    private boolean isBlunt(Item item) {
        return this.bluntList.contains(item);
    }

    private boolean isPierce(Item item) {
        return this.pierceList.contains(item);
    }
}

