/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class SplashHandler
extends VisualHandler {
    public int splashMinDuration = 10;
    public int splashMaxDuration = 10;
    public float splashMinIntensity = 10.0f;
    public float splashMaxIntensity = 5.0f;
    public static int waterSubstractFactor = 10;
    public boolean wasInWater = false;

    public SplashHandler() {
        super("splash", "heart beat & splash blur effect");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.splashMinDuration = config.getInt("splashMinDuration", this.name, this.splashMinDuration, 0, 10000, "minimum splash duration");
        this.splashMaxDuration = config.getInt("splashMaxDuration", this.name, this.splashMaxDuration, 0, 10000, "maximum additional splash duration");
        this.splashMinIntensity = config.getFloat("splashMinIntensity", this.name, this.splashMinIntensity, 0.0f, 10000.0f, "minimum splash intensity");
        this.splashMaxIntensity = config.getFloat("splashMaxIntensity", this.name, this.splashMaxIntensity, 0.0f, 10000.0f, "maximum additional splash intensity");
        waterSubstractFactor = config.getInt("waterSubstractFactor", this.name, waterSubstractFactor, 0, 100000, "increased fade out factor in water");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("splashMinDuration", (ConfigElement)new IntegerSegment("splashMinDuration", Integer.valueOf(10), 0, 10000).setToolTip(new String[]{"minimum splash duration"}));
        branch.registerElement("splashMaxDuration", (ConfigElement)new IntegerSegment("splashMaxDuration", Integer.valueOf(10), 0, 10000).setToolTip(new String[]{"maximum additional splash duration"}));
        branch.registerElement("splashMinIntensity", (ConfigElement)new FloatSegment("splashMinIntensity", Float.valueOf(10.0f), 0.0f, 10000.0f).setToolTip(new String[]{"minimum splash intensity"}));
        branch.registerElement("splashMaxIntensity", (ConfigElement)new FloatSegment("splashMaxIntensity", Float.valueOf(5.0f), 0.0f, 10000.0f).setToolTip(new String[]{"maximum additional splash intensity"}));
        branch.registerElement("waterSubstractFactor", (ConfigElement)new IntegerSegment("waterSubstractFactor", Integer.valueOf(10), 0, 10000).setToolTip(new String[]{"increased fade out factor in water"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.splashMinDuration = (Integer)branch.getValue("splashMinDuration");
        this.splashMaxDuration = (Integer)branch.getValue("splashMaxDuration");
        this.splashMinIntensity = ((Float)branch.getValue("splashMinIntensity")).floatValue();
        this.splashMaxIntensity = ((Float)branch.getValue("splashMaxIntensity")).floatValue();
        waterSubstractFactor = (Integer)branch.getValue("waterSubstractFactor");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        if (player != null) {
            boolean isInWater = player.func_70055_a(Material.field_151586_h);
            if (isInWater != this.wasInWater) {
                VisualManager.addVisualWithShading(VisualType.blur, (float)((double)this.splashMinIntensity + Math.random() * (double)this.splashMaxIntensity), this.splashMinDuration, this.splashMaxDuration, Color.WHITE);
            }
            if (isInWater) {
                for (VisualCategory category : VisualManager.visuals.getKeys()) {
                    for (Visual visual : VisualManager.visuals.getValues(category)) {
                        if (!visual.type.isAffectedByWater) continue;
                        for (int i = 0; i < waterSubstractFactor; ++i) {
                            visual.onTick(player);
                        }
                    }
                }
            }
            this.wasInWater = isInWater;
        }
    }
}

