/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.gui;

import ivorius.ivtoolkit.gui.GuiControlListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiSliderMultivalue
extends GuiButton {
    private float[] values;
    public int mousePressedInsideIndex = -1;
    private List<GuiControlListener<GuiSliderMultivalue>> listeners = new ArrayList<GuiControlListener<GuiSliderMultivalue>>();
    private float minValue = 0.0f;
    private float maxValue = 1.0f;

    public GuiSliderMultivalue(int id, int x, int y, int width, int height, int values, String displayString) {
        super(id, x, y, width, height, displayString);
        this.values = new float[values];
    }

    public int func_146114_a(boolean mouseHovering) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int x, int y) {
        if (this.field_146125_m) {
            if (this.mousePressedInsideIndex >= 0) {
                this.values[this.mousePressedInsideIndex] = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.values[this.mousePressedInsideIndex] = this.values[this.mousePressedInsideIndex] * (this.maxValue - this.minValue) + this.minValue;
                if (this.values[this.mousePressedInsideIndex] < this.minValue) {
                    this.values[this.mousePressedInsideIndex] = this.minValue;
                }
                if (this.values[this.mousePressedInsideIndex] > this.maxValue) {
                    this.values[this.mousePressedInsideIndex] = this.maxValue;
                }
                this.notifyOfChanges();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (float value : this.values) {
                float drawVal = (value - this.minValue) / (this.maxValue - this.minValue);
                this.func_73729_b(this.field_146128_h + (int)(drawVal * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + (int)(drawVal * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, this.field_146121_g);
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        if (super.func_146116_c(mc, x, y)) {
            float value = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            value = value * (this.maxValue - this.minValue) + this.minValue;
            float nearestDist = -1.0f;
            for (int i = 0; i < this.values.length; ++i) {
                float dist = Math.abs(this.values[i] - value);
                if (!(dist < nearestDist) && !(nearestDist < 0.0f)) continue;
                this.mousePressedInsideIndex = i;
                nearestDist = dist;
            }
            this.values[this.mousePressedInsideIndex] = value;
            if (this.values[this.mousePressedInsideIndex] < this.minValue) {
                this.values[this.mousePressedInsideIndex] = this.minValue;
            }
            if (this.values[this.mousePressedInsideIndex] > this.maxValue) {
                this.values[this.mousePressedInsideIndex] = this.maxValue;
            }
            this.notifyOfChanges();
            return true;
        }
        return false;
    }

    public void func_146118_a(int x, int y) {
        this.mousePressedInsideIndex = -1;
    }

    private void notifyOfChanges() {
        for (GuiControlListener<GuiSliderMultivalue> listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    public float getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, float value) {
        this.values[index] = value;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public void addListener(GuiControlListener<GuiSliderMultivalue> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GuiControlListener<GuiSliderMultivalue> listener) {
        this.listeners.remove(listener);
    }

    public List<GuiControlListener<GuiSliderMultivalue>> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

