/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.CitySphere;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TerrainEventHandlers {
    @SubscribeEvent
    public void onCreateDecorate(DecorateBiomeEvent.Decorate event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (!WorldTypeTools.isLostCities(world)) {
                return;
            }
            LostCityChunkGenerator provider = WorldTypeTools.getLostCityChunkGenerator(world);
            if (provider == null) {
                return;
            }
            switch (event.getType()) {
                case CLAY: 
                case DEAD_BUSH: 
                case ICE: 
                case LAKE_LAVA: 
                case ROCK: 
                case SAND: 
                case SAND_PASS2: 
                case CUSTOM: {
                    break;
                }
                case FOSSIL: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_FOSSILS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case DESERT_WELL: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_DESERT_WELL) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case LAKE_WATER: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_LAKE_WATER) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case PUMPKIN: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_PUMPKINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case GRASS: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_GRASS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case SHROOM: 
                case BIG_SHROOM: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_MUSHROOMS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case CACTUS: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_CACTII) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case REED: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_REEDS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case LILYPAD: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_LILYPADS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case FLOWERS: {
                    if (!this.getProfile((DecorateBiomeEvent.Decorate)event, (WorldServer)((WorldServer)world)).AVOID_GENERATED_FLOWERS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case TREE: {
                    int chunkZ;
                    LostCityProfile profile = WorldTypeTools.getProfile(world);
                    if (profile.AVOID_GENERATED_TREES) {
                        event.setResult(Event.Result.DENY);
                        break;
                    }
                    if (!profile.isSpace() || !profile.CITYSPHERE_LANDSCAPE_OUTSIDE) break;
                    int chunkX = event.getPos().func_177958_n() >> 4;
                    CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ = event.getPos().func_177952_p() >> 4, provider);
                    if (!sphere.isEnabled()) {
                        return;
                    }
                    if (!CitySphere.onCitySphereBorder(chunkX, chunkZ, provider)) break;
                    float radius = sphere.getRadius();
                    double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
                    BlockPos cc = sphere.getCenterPos();
                    int cx = cc.func_177958_n();
                    int cz = cc.func_177952_p();
                    Biome biome = world.getBiomeForCoordsBody(event.getPos());
                    BiomeDecorator decorator = biome.field_76760_I;
                    int treesPerChunk = decorator.field_76832_z;
                    if (world.field_73012_v.nextFloat() < decorator.field_189870_A) {
                        ++treesPerChunk;
                    }
                    for (int i = 0; i < treesPerChunk; ++i) {
                        int treex = world.field_73012_v.nextInt(16) + 8;
                        int treez = world.field_73012_v.nextInt(16) + 8;
                        WorldGenAbstractTree worldgenabstracttree = biome.func_150567_a(world.field_73012_v);
                        worldgenabstracttree.func_175904_e();
                        BlockPos blockpos = world.func_175645_m(event.getPos().func_177982_a(treex, 0, treez));
                        if (!(CitySphere.squaredDistance(cx, cz, treex, treez) < sqradiusOffset) || !worldgenabstracttree.func_180709_b(world, world.field_73012_v, blockpos)) continue;
                        worldgenabstracttree.func_180711_a(world, world.field_73012_v, blockpos);
                    }
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private LostCityProfile getProfile(DecorateBiomeEvent.Decorate event, WorldServer world) {
        LostCityChunkGenerator provider = WorldTypeTools.getChunkGenerator(world.field_73011_w.getDimension());
        int chunkX = event.getPos().func_177958_n() >> 4;
        int chunkZ = event.getPos().func_177952_p() >> 4;
        return BuildingInfo.getProfile(chunkX, chunkZ, provider);
    }
}

