/*
 * Decompiled with CFR 0.152.
 */
package tschipp.tschipplib.compat.gamestages;

import com.blamejared.recipestages.handlers.Recipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.itemstages.ItemStages;
import net.darkhax.itemstages.compat.crt.ActionAddItemRestriction;
import net.darkhax.itemstages.compat.crt.ActionRemoveRestriction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tschipp.tschipplib.TschippLib;

@ZenRegister
@ZenClass(value="mods.tschipplib.gamestagehelper")
public class GamestagesHelper {
    private static Method stagePrimitive;
    private static Class<?> ctIntegration;

    @ZenMethod
    public static void stageRecipes(Map<String, Integer> stageMap, List<String> blacklist) {
        CraftTweakerAPI.apply((IAction)new StageRecipes(stageMap, blacklist));
    }

    public static String itemString(ItemStack stack) {
        return stack.func_77973_b().getRegistryName() + "@" + stack.func_77960_j() + "$" + (stack.func_77942_o() ? stack.func_77978_p().toString() : "");
    }

    public static String ingredientString(Ingredient ing) {
        String name = "";
        for (ItemStack stack : ing.func_193365_a()) {
            name = name + GamestagesHelper.itemString(stack) + "#";
        }
        return name;
    }

    private static class StageRecipes
    implements IAction {
        private Map<String, Integer> stageMap;
        private List<String> blacklist;

        public StageRecipes(Map<String, Integer> stageMap, List<String> blacklist) {
            this.stageMap = stageMap;
            this.blacklist = blacklist;
        }

        public void apply() {
            List recipes = ForgeRegistries.RECIPES.getValues();
            HashMap<String, Integer> stagedItemStacks = new HashMap<String, Integer>();
            HashMap<String, String> knownIngredients = new HashMap<String, String>();
            long totalTime = System.currentTimeMillis();
            TschippLib.LOGGER.debug("Starting mass auto staging of recipes. Staging " + recipes.size() + " recipes in total");
            for (IRecipe recipe : recipes) {
                long startTime = System.currentTimeMillis();
                boolean blacklisted = false;
                if (this.blacklist.contains(recipe.getRegistryName().toString())) {
                    blacklisted = true;
                }
                boolean recipeUnstaged = true;
                String stageName = "";
                for (Ingredient ingr : recipe.func_192400_c()) {
                    String str = GamestagesHelper.ingredientString(ingr);
                    if (knownIngredients.containsKey(str)) {
                        String stage = (String)knownIngredients.get(str);
                        if (stage.equals("TSCHIPPLIBUNSTAGED")) continue;
                        recipeUnstaged = false;
                        stageName = stage;
                        continue;
                    }
                    boolean ingredientStaged = true;
                    int lowestIngredientStage = Integer.MAX_VALUE;
                    boolean nonNull = false;
                    for (ItemStack stack : ingr.func_193365_a()) {
                        Integer stageVal;
                        if (stack.func_190926_b()) continue;
                        nonNull = true;
                        boolean itemstackStaged = false;
                        String stage = (String)ItemStages.ITEM_STAGES.get((Object)stack);
                        if (stage != null && (stageVal = this.stageMap.get(stage)) != null && stageVal < lowestIngredientStage) {
                            stageName = stage;
                            lowestIngredientStage = stageVal;
                            itemstackStaged = true;
                        }
                        if (itemstackStaged) continue;
                        ingredientStaged = false;
                    }
                    if (ingredientStaged && nonNull) {
                        knownIngredients.put(str, stageName);
                        recipeUnstaged = false;
                        continue;
                    }
                    if (ingredientStaged) continue;
                    knownIngredients.put(str, "TSCHIPPLIBUNSTAGED");
                }
                if (recipeUnstaged) {
                    stagedItemStacks.put(GamestagesHelper.itemString(recipe.func_77571_b()), Integer.MIN_VALUE);
                }
                if (!recipeUnstaged && !stageName.isEmpty()) {
                    int outputStageNum;
                    int otherStageVal;
                    int stageVal = this.stageMap.get(stageName);
                    if (stagedItemStacks.containsKey(GamestagesHelper.itemString(recipe.func_77571_b())) && (otherStageVal = ((Integer)stagedItemStacks.get(GamestagesHelper.itemString(recipe.func_77571_b()))).intValue()) < stageVal) {
                        blacklisted = true;
                    }
                    if (!blacklisted) {
                        stagedItemStacks.put(GamestagesHelper.itemString(recipe.func_77571_b()), this.stageMap.get(stageName));
                    }
                    IItemStack output = CraftTweakerMC.getIItemStack((ItemStack)recipe.func_77571_b());
                    String outputStage = (String)ItemStages.ITEM_STAGES.get((Object)recipe.func_77571_b().func_77946_l().func_77979_a(1));
                    if (outputStage != null && (outputStageNum = this.stageMap.get(outputStage).intValue()) > stageVal) {
                        stageName = outputStage;
                    }
                    if (!blacklisted && !stagedItemStacks.containsKey(GamestagesHelper.itemString(recipe.func_77571_b()))) {
                        CraftTweakerAPI.apply((IAction)new ActionRemoveRestriction((IIngredient)output));
                        CraftTweakerAPI.logInfo((String)("Staging " + output.getName() + " with stage " + stageName));
                        CraftTweakerAPI.apply((IAction)new ActionAddItemRestriction(stageName, (IIngredient)output));
                    }
                    Recipes.setRecipeStage((String)stageName, (String)recipe.getRegistryName().toString());
                    CraftTweakerAPI.logInfo((String)("Staging Recipe " + recipe.getRegistryName().toString() + " with stage " + stageName));
                    if (Loader.isModLoaded((String)"primitivecrafting")) {
                        if (stagePrimitive == null && ctIntegration == null) {
                            try {
                                ctIntegration = Class.forName("tschipp.primitivecrafting.compat.crafttweaker.CTIntegration");
                                stagePrimitive = ctIntegration.getMethod("addRecipeStageForStack", String.class, IItemStack.class);
                            }
                            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                                e.printStackTrace();
                            }
                        }
                        if (stagePrimitive != null && ctIntegration != null) {
                            try {
                                stagePrimitive.invoke(null, stageName, output);
                                CraftTweakerAPI.logInfo((String)("Staging Primitive Recipe " + output.getName() + " with stage " + stageName));
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                TschippLib.LOGGER.debug("Processed recipe " + recipe.getRegistryName() + " in " + (System.currentTimeMillis() - startTime) + " ms");
            }
            TschippLib.LOGGER.info("Finished processing recipes. Took " + (System.currentTimeMillis() - totalTime) / 1000L + " s");
        }

        public String describe() {
            return "Staging all recipes";
        }
    }
}

