/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.block;

import de.Whitedraco.switchbow.Initial;
import de.Whitedraco.switchbow.entity.EntityArrowLauncher;
import de.Whitedraco.switchbow.tileentity.TileEntityArrowDispenser;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArrowDispenser
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> DISPENSE_BEHAVIOR_REGISTRY = new RegistryDefaulted((Object)new BehaviorDefaultDispenseItem());
    private Random rand = new Random();

    public BlockArrowDispenser(String Name) {
        super(Material.field_151575_d);
        this.setRegistryName(Name);
        this.func_149663_c(Name);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(Initial.tabSwitchbow);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149738_a(World worldIn) {
        return 4;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d()).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityArrowDispenser) {
            TileEntityArrowDispenser tet = (TileEntityArrowDispenser)te;
            tet.setCount(9);
            tet.setShootangle(45.5f);
            tet.setRange(0.8f);
            tet.setCanshoot(false);
            worldIn.func_184138_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 3);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityArrowDispenser();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_184614_ca() != ItemStack.field_190927_a && playerIn.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
            this.dispense(worldIn, pos);
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityArrowDispenser) {
            playerIn.openGui((Object)Initial.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    private boolean shooting(World worldIn, BlockPos pos, TileEntityArrowDispenser TileEntityArrowDispenser2) {
        int i = TileEntityArrowDispenser2.getDispenseSlot();
        if (i < 0) {
            worldIn.func_175718_b(1001, pos, 0);
            return false;
        }
        ItemStack itemstack = TileEntityArrowDispenser2.func_70301_a(i);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IBlockState block = worldIn.func_180495_p(pos);
        EnumFacing facing = null;
        if (block.func_177230_c() instanceof BlockArrowDispenser) {
            facing = ((EnumFacing)block.func_177229_b((IProperty)FACING)).func_176734_d();
        }
        float shootangle = TileEntityArrowDispenser2.getShootangle();
        float range = TileEntityArrowDispenser2.getRange();
        float k = 0.0f;
        float j = 0.0f;
        double posx = 0.0;
        double posz = 0.0;
        if (facing == EnumFacing.SOUTH) {
            k = 180.0f;
            posx = (double)x + 0.5;
            posz = (double)z - 0.1;
        }
        if (facing == EnumFacing.WEST) {
            k = -90.0f;
            posx = (double)x + 1.1;
            posz = (double)z + 0.5;
        }
        if (facing == EnumFacing.NORTH) {
            k = 0.0f;
            posx = (double)x + 0.5;
            posz = (double)z + 1.1;
        }
        if (facing == EnumFacing.EAST) {
            k = 90.0f;
            posx = (double)x - 0.1;
            posz = (double)z + 0.5;
        }
        double posy = (double)y + 0.8;
        float ran = 0.0f;
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        boolean Rechnung1 = this.rand.nextBoolean();
        ran = (float)this.rand.nextInt(10) + this.rand.nextFloat();
        if (Rechnung1) {
            ran = k + ran;
        } else if (!Rechnung1) {
            ran = k - ran;
        }
        boolean Rechnung2 = this.rand.nextBoolean();
        ran2 = (float)this.rand.nextInt(5) + this.rand.nextFloat();
        if (Rechnung2) {
            ran2 = shootangle + ran2;
        } else if (!Rechnung2) {
            ran2 = shootangle - ran2;
        }
        boolean Rechnung3 = this.rand.nextBoolean();
        float Anzahl = (float)(this.rand.nextInt(100) + 1) / 1000.0f;
        if (Rechnung3) {
            ran3 = range + Anzahl;
        } else if (!Rechnung3) {
            ran3 = range - Anzahl;
        }
        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
        EntityArrowLauncher fakeCannon = new EntityArrowLauncher(worldIn);
        fakeCannon.func_70107_b(posx, posy, posz);
        EntityArrow arrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)fakeCannon);
        arrow.func_70107_b(posx, posy, posz);
        arrow.func_184547_a((Entity)fakeCannon, arrow.field_70125_A, arrow.field_70177_z, 0.0f, ran3 * 1.5f, 1.0f);
        arrow.func_70012_b(posx, posy, posz, ran, -ran2);
        arrow.field_70159_w = -MathHelper.func_76126_a((float)(arrow.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(arrow.field_70125_A / 180.0f * (float)Math.PI));
        arrow.field_70179_y = MathHelper.func_76134_b((float)(arrow.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(arrow.field_70125_A / 180.0f * (float)Math.PI));
        arrow.field_70181_x = -MathHelper.func_76126_a((float)(arrow.field_70125_A / 180.0f * (float)Math.PI));
        arrow.func_70186_c(arrow.field_70159_w, arrow.field_70181_x, arrow.field_70179_y, ran3 * 1.5f, 1.0f);
        arrow.func_70243_d(true);
        arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        arrow.field_70250_c = null;
        worldIn.func_72838_d((Entity)arrow);
        itemstack.func_190918_g(1);
        TileEntityArrowDispenser2.func_70299_a(i, itemstack.func_190916_E() <= 0 ? ItemStack.field_190927_a : itemstack);
        return true;
    }

    protected void dispense(World worldIn, BlockPos pos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(worldIn, pos);
        TileEntityArrowDispenser TileEntityArrowLancher = (TileEntityArrowDispenser)blocksourceimpl.func_150835_j();
        if (TileEntityArrowLancher != null) {
            for (int a = 0; a < TileEntityArrowLancher.getCount() && this.shooting(worldIn, pos, TileEntityArrowLancher); ++a) {
            }
        }
    }

    protected IBehaviorDispenseItem getBehavior(@Nullable ItemStack stack) {
        return (IBehaviorDispenseItem)DISPENSE_BEHAVIOR_REGISTRY.func_82594_a((Object)(stack == ItemStack.field_190927_a ? null : stack.func_77973_b()));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).isCanshoot();
        if (flag && !flag1) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).setCanshoot(true);
        } else if (!flag && flag1) {
            ((TileEntityArrowDispenser)worldIn.func_175625_s(pos)).setCanshoot(false);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.dispense(worldIn, pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityArrowDispenser) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityArrowDispenser)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }
}

