/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import toughasnails.api.config.TemperatureOption;
import toughasnails.config.ConfigHandler;
import toughasnails.core.ToughAsNails;

public class TemperatureConfig
extends ConfigHandler {
    public static final String RATE_SETTINGS = "Rate Settings";
    public static final String MODIFIER_SETTINGS = "Modifier Settings";
    public int altitudeModifier;
    public int maxBiomeTempOffset;
    public int sprintingModifier;
    public int earlySpringModifier;
    public int midSpringModifier;
    public int lateSpringModifier;
    public int earlySummerModifier;
    public int midSummerModifier;
    public int lateSummerModifier;
    public int earlyAutumnModifier;
    public int midAutumnModifier;
    public int lateAutumnModifier;
    public int earlyWinterModifier;
    public int midWinterModifier;
    public int lateWinterModifier;
    public int timeModifier;
    public float timeExtremityMultiplier;
    public boolean enableDayTimeModifier;
    public boolean enableNightTimeModifier;
    public int wetModifier;
    public int snowModifier;
    public boolean enableUndergroundEffect;
    public int equilibriumDepth;

    public TemperatureConfig(File configFile) {
        super(configFile, "Temperature Settings");
    }

    @Override
    protected void loadConfiguration() {
        try {
            this.addSyncedValue(TemperatureOption.BASE_TEMPERATURE_CHANGE_TICKS, 400, RATE_SETTINGS, "The maximum number of ticks before the temperature changes", 20, Integer.MAX_VALUE);
            this.addSyncedValue(TemperatureOption.MAX_RATE_MODIFIER, 380, RATE_SETTINGS, "The maximum number of ticks to reduce the base rate by", 20, Integer.MAX_VALUE);
            this.altitudeModifier = this.config.getInt("Altitude Modifier", MODIFIER_SETTINGS, 3, 0, Integer.MAX_VALUE, "The maximum to increase/decrease temperature by depending on the altitude");
            this.maxBiomeTempOffset = this.config.getInt("Max Biome Temperature Modifier", MODIFIER_SETTINGS, 10, 0, Integer.MAX_VALUE, "The maximum to increase/decrease temperature by depending on the biome");
            this.sprintingModifier = this.config.getInt("Sprinting Modifier", MODIFIER_SETTINGS, 3, 0, Integer.MAX_VALUE, "The amount to increase the temperature by when sprinting");
            this.earlySpringModifier = this.config.getInt("Early Spring Modifier", MODIFIER_SETTINGS, -3, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midSpringModifier = this.config.getInt("Mid Spring Modifier", MODIFIER_SETTINGS, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateSpringModifier = this.config.getInt("Late Spring Modifier", MODIFIER_SETTINGS, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlySummerModifier = this.config.getInt("Early Summer Modifier", MODIFIER_SETTINGS, 3, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midSummerModifier = this.config.getInt("Mid Summer Modifier", MODIFIER_SETTINGS, 5, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateSummerModifier = this.config.getInt("Late Summer Modifier", MODIFIER_SETTINGS, 3, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlyAutumnModifier = this.config.getInt("Early Autumn Modifier", MODIFIER_SETTINGS, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midAutumnModifier = this.config.getInt("Mid Autumn Modifier", MODIFIER_SETTINGS, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateAutumnModifier = this.config.getInt("Late Autumn Modifier", MODIFIER_SETTINGS, -3, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlyWinterModifier = this.config.getInt("Early Winter Modifier", MODIFIER_SETTINGS, -7, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midWinterModifier = this.config.getInt("Mid Winter Modifier", MODIFIER_SETTINGS, -14, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateWinterModifier = this.config.getInt("Late Winter Modifier", MODIFIER_SETTINGS, -7, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.timeModifier = this.config.getInt("Time Modifier", MODIFIER_SETTINGS, 9, 0, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in the middle of the day/night");
            this.timeExtremityMultiplier = this.config.getFloat("Time Extremity Multiplier", MODIFIER_SETTINGS, 1.25f, 0.0f, Float.MAX_VALUE, "The amount to multiply the temperature increment/decrement by in the middle of the day/night based on how extreme the biome temperature is");
            this.enableDayTimeModifier = this.config.getBoolean("Enable Day Time Modifier", MODIFIER_SETTINGS, false, "Whether the player's temperature should increase closer to the middle of the day");
            this.enableNightTimeModifier = this.config.getBoolean("Enable Night Time Modifier", MODIFIER_SETTINGS, true, "Whether the player's temperature should decrease closer to the middle of the night");
            this.wetModifier = this.config.getInt("Wet Modifier", MODIFIER_SETTINGS, -7, Integer.MIN_VALUE, 0, "The amount to decrease the temperature by when wet");
            this.snowModifier = this.config.getInt("Snow Modifier", MODIFIER_SETTINGS, -10, Integer.MIN_VALUE, 0, "The amount to decrease the temperature by when snowing");
            this.enableUndergroundEffect = this.config.getBoolean("Enable Underground Effect", MODIFIER_SETTINGS, true, "Whether surface modifiers should decrease with depth");
            this.equilibriumDepth = this.config.getInt("Equilibrium Depth", MODIFIER_SETTINGS, 30, 0, Integer.MAX_VALUE, "The vertical distance between the surface and the level where surface modifiers are totally absorbed");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading temperature.cfg", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }
}

